/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.toolkit;

import com.hotent.bpmx.mybatisplus.toolkit.Assert;
import com.hotent.bpmx.mybatisplus.toolkit.ExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.io.Resources;

public final class ClassUtils {
    private static ClassLoader systemClassLoader;
    private static final List<String> PROXY_CLASS_NAMES;

    private ClassUtils() {
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class == type;
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> cls : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null", new Object[0]);
        return ClassUtils.isProxy(clazz) ? clazz.getSuperclass() : clazz;
    }

    public static Class<?> getUserClass(Object object) {
        Assert.notNull(object, "Instance must not be null", new Object[0]);
        return ClassUtils.getUserClass(object.getClass());
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw ExceptionUtils.mpe("\u5b9e\u4f8b\u5316\u5bf9\u8c61\u65f6\u51fa\u73b0\u9519\u8bef,\u8bf7\u5c1d\u8bd5\u7ed9 %s \u6dfb\u52a0\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5", e, clazz.getName());
        }
    }

    public static <T> T newInstance(String clazzName) {
        return (T)ClassUtils.newInstance(ClassUtils.toClassConfident(clazzName));
    }

    public static Class<?> toClassConfident(String name) {
        return ClassUtils.toClassConfident(name, null);
    }

    public static Class<?> toClassConfident(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.loadClass(name, ClassUtils.getClassLoaders(classLoader));
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.mpe("\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5", e, new Object[0]);
        }
    }

    private static Class<?> loadClass(String className, ClassLoader[] classLoaders) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null) continue;
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Cannot find class: " + className);
    }

    public static String getPackageName(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null", new Object[0]);
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull(fqClassName, "Class name must not be null", new Object[0]);
        int lastDotIndex = fqClassName.lastIndexOf(".");
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    @Deprecated
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    private static ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[]{classLoader, Resources.getDefaultClassLoader(), Thread.currentThread().getContextClassLoader(), ClassUtils.class.getClassLoader(), systemClassLoader};
    }

    static {
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    }
}

