/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.toolkit;

import com.hotent.bpmx.mybatisplus.toolkit.CollectionUtils;
import com.hotent.bpmx.mybatisplus.toolkit.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PropertyMapper {
    private final Properties delegate;

    private PropertyMapper(Properties delegate) {
        this.delegate = delegate;
    }

    public static PropertyMapper newInstance(Properties properties) {
        return new PropertyMapper(properties);
    }

    public Set<String> keys() {
        return this.delegate.stringPropertyNames();
    }

    public PropertyMapper whenNotBlank(String key, Consumer<String> consumer) {
        String value = this.delegate.getProperty(key);
        if (StringUtils.isNotBlank(value)) {
            consumer.accept(value);
        }
        return this;
    }

    public <T> PropertyMapper whenNotBlank(String key, Function<String, T> function, Consumer<T> consumer) {
        String value = this.delegate.getProperty(key);
        if (StringUtils.isNotBlank(value)) {
            consumer.accept(function.apply(value));
        }
        return this;
    }

    public Map<String, Properties> group(String group) {
        Set<String> keys = this.keys();
        Set<String> inner = keys.stream().filter(i -> i.startsWith(group)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(inner)) {
            return Collections.emptyMap();
        }
        HashMap<String, Properties> map = CollectionUtils.newHashMap();
        inner.forEach(i -> {
            Properties p = new Properties();
            String key = i.substring(group.length()) + ":";
            int keyIndex = key.length();
            keys.stream().filter(j -> j.startsWith(key)).forEach(j -> p.setProperty(j.substring(keyIndex), this.delegate.getProperty((String)j)));
            map.put(this.delegate.getProperty((String)i), p);
        });
        return map;
    }
}

