/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpmx.mybatisplus.toolkit.sql;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.hotent.bpmx.mybatisplus.toolkit.Assert;
import com.hotent.bpmx.mybatisplus.toolkit.CollectionUtils;
import com.hotent.bpmx.mybatisplus.toolkit.ExceptionUtils;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.MyBatisExceptionTranslator;
import org.mybatis.spring.SqlSessionHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SqlHelper {
    private static final Log log = LogFactory.get();

    public static boolean executeBatch(SqlSessionFactory sqlSessionFactory, Consumer<SqlSession> consumer) throws Throwable {
        SqlSession sqlSession;
        SqlSessionHolder sqlSessionHolder = (SqlSessionHolder)TransactionSynchronizationManager.getResource((Object)sqlSessionFactory);
        boolean transaction = TransactionSynchronizationManager.isSynchronizationActive();
        if (sqlSessionHolder != null) {
            sqlSession = sqlSessionHolder.getSqlSession();
            sqlSession.commit(!transaction);
        }
        sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + String.valueOf(sqlSession) + "] Transaction not enabled", new Object[0]);
        }
        try {
            consumer.accept(sqlSession);
            sqlSession.commit(!transaction);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            MyBatisExceptionTranslator myBatisExceptionTranslator;
            DataAccessException throwable;
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
            if (unwrapped instanceof PersistenceException && (throwable = (myBatisExceptionTranslator = new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true)).translateExceptionIfPossible((RuntimeException)((PersistenceException)unwrapped))) != null) {
                throw throwable;
            }
            throw ExceptionUtils.mpe(unwrapped);
        }
        finally {
            sqlSession.close();
        }
    }

    public static <E> boolean executeBatch(SqlSessionFactory sqlSessionFactory, Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) throws Throwable {
        Assert.isFalse(batchSize < 1, "batchSize must not be less than one", new Object[0]);
        return !CollectionUtils.isEmpty(list) && SqlHelper.executeBatch(sqlSessionFactory, sqlSession -> {
            int size = list.size();
            int idxLimit = Math.min(batchSize, size);
            int i = 1;
            for (Object element : list) {
                consumer.accept((SqlSession)sqlSession, element);
                if (i == idxLimit) {
                    sqlSession.flushStatements();
                    idxLimit = Math.min(idxLimit + batchSize, size);
                }
                ++i;
            }
        });
    }

    public static <E> boolean saveOrUpdateBatch(SqlSessionFactory sqlSessionFactory, Collection<E> list, int batchSize, BiPredicate<SqlSession, E> predicate, BiConsumer<SqlSession, E> insertConsumer, BiConsumer<SqlSession, E> updateConsumer) throws Throwable {
        return SqlHelper.executeBatch(sqlSessionFactory, list, batchSize, (sqlSession, entity) -> {
            if (predicate.test((SqlSession)sqlSession, (Object)entity)) {
                insertConsumer.accept((SqlSession)sqlSession, (Object)entity);
            } else {
                updateConsumer.accept((SqlSession)sqlSession, (Object)entity);
            }
        });
    }
}

