/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.Calendar.manager.CalendarShiftManager;
import com.hotent.Calendar.manager.CalendarShiftPeroidManager;
import com.hotent.Calendar.model.CalendarShift;
import com.hotent.Calendar.model.CalendarShiftPeroid;
import com.hotent.Calendar.params.CalendarShiftVo;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendar/shift/v1/"})
@Api(tags={"\u73ed\u6b21\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class ShiftController
extends BaseController<CalendarShiftManager, CalendarShift> {
    @Resource
    private CalendarShiftManager calendarShiftManager;
    @Resource
    private CalendarShiftPeroidManager calendarShiftPeroidManager;
    @Resource
    IdGenerator idGenerator;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u73ed\u6b21\u7ba1\u7406\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u73ed\u6b21\u7ba1\u7406\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<CalendarShift> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<CalendarShift> queryFilter) throws Exception {
        return this.calendarShiftManager.query(queryFilter);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u73ed\u6b21\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u73ed\u6b21\u660e\u7ec6")
    public CalendarShiftVo get(@ApiParam(name="id", value="\u73ed\u6b21id", required=true) @RequestParam String id) throws Exception {
        ArrayList<CalendarShiftPeroid> shiftPeroidlist = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            CalendarShift shift = (CalendarShift)this.calendarShiftManager.get((Serializable)((Object)id));
            shiftPeroidlist = this.calendarShiftPeroidManager.getByShiftId(id);
            return new CalendarShiftVo(shift, shiftPeroidlist);
        }
        return null;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u73ed\u6b21\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u73ed\u6b21\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="calendarShiftVo", value="\u73ed\u6b21\u4fe1\u606f", required=true) @RequestBody CalendarShiftVo calendarShiftVo) throws Exception {
        String msg = "";
        CalendarShift calendarshift = calendarShiftVo.getCalendarShift();
        List<CalendarShiftPeroid> peroids = calendarShiftVo.getShiftPeroidlist();
        calendarshift.setCalendarShiftPeroidList(peroids);
        String shiftId = calendarshift.getId();
        if (StringUtil.isEmpty((String)shiftId)) {
            shiftId = this.idGenerator.getSuid();
            calendarshift.setId(shiftId);
            this.calendarShiftManager.create((Model)calendarshift);
            msg = "\u4fdd\u5b58\u6210\u529f";
        } else {
            shiftId = calendarshift.getId();
            this.calendarShiftManager.update((Model)calendarshift);
            msg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, msg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u73ed\u6b21\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u73ed\u6b21\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u73ed\u6b21\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.calendarShiftManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"setDefault"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u65f6\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u662f\u9ed8\u8ba4\u7684", httpMethod="GET", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u65f6\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u662f\u9ed8\u8ba4\u7684")
    public CommonResult<String> setDefault(@ApiParam(name="id", value="\u73ed\u6b21id", required=true) @RequestParam String id) throws Exception {
        String msg = "\u8bbe\u7f6e\u6210\u529f";
        this.calendarShiftManager.setDefaultShift(id);
        return new CommonResult(true, msg);
    }
}

