/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.Calendar.dao.CalendarAssignDao;
import com.hotent.Calendar.dao.CalendarDao;
import com.hotent.Calendar.dao.CalendarSettingDao;
import com.hotent.Calendar.manager.CalendarAssignManager;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.model.Calendar;
import com.hotent.Calendar.model.CalendarAssign;
import com.hotent.Calendar.model.CalendarSetting;
import com.hotent.Calendar.model.CalendarShiftPeroid;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="calendarAssignManager")
public class CalendarAssignManagerImpl
extends BaseManagerImpl<CalendarAssignDao, CalendarAssign>
implements CalendarAssignManager {
    @Resource
    CalendarDao calendarDao;
    @Resource
    CalendarSettingManager calendarSettingManager;
    @Resource
    CalendarSettingDao calendarSettingDao;

    @Override
    public String getCalendarIdByUserId(String userId) {
        CalendarAssign calendarAssign = ((CalendarAssignDao)this.baseMapper).getByAssignId(CalendarAssign.TYPE_USER, userId);
        if (calendarAssign == null) {
            // empty if block
        }
        if (calendarAssign != null) {
            return calendarAssign.getCanlendarId();
        }
        Calendar calendar = this.calendarDao.getDefaultCalendar();
        if (calendar != null) {
            return calendar.getId();
        }
        return "0";
    }

    public CalendarAssign get(Serializable id) {
        return ((CalendarAssignDao)this.baseMapper).get(id);
    }

    public PageList<CalendarAssign> query(QueryFilter<CalendarAssign> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        Class currentModelClass = this.currentModelClass();
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, currentModelClass);
        return ((CalendarAssignDao)this.baseMapper).query((IPage<CalendarAssign>)page, (Wrapper<CalendarAssign>)convert2Wrapper);
    }

    @Override
    @Deprecated
    public List<CalendarShiftPeroid> getBycalList(List<CalendarSetting> list) {
        ArrayList<CalendarShiftPeroid> tmplist = new ArrayList<CalendarShiftPeroid>();
        ArrayList<CalendarShiftPeroid> worklist = new ArrayList<CalendarShiftPeroid>();
        for (CalendarSetting setting : list) {
            String calDay = setting.getCalDay();
            List<CalendarShiftPeroid> workTimeList = setting.getCalendarShiftPeroidList();
            for (CalendarShiftPeroid work : workTimeList) {
                work.setCalDay(calDay);
                tmplist.add((CalendarShiftPeroid)work.clone());
            }
        }
        int len = tmplist.size();
        for (int i = 0; i < len; ++i) {
            CalendarShiftPeroid workTime = (CalendarShiftPeroid)tmplist.get(i);
            if (i < len - 1) {
                int j = i + 1;
                CalendarShiftPeroid nextTime = (CalendarShiftPeroid)tmplist.get(j);
                if (workTime.getEndDateTime().compareTo(nextTime.getStartDateTime()) > 0) {
                    workTime.setEndDateTime(nextTime.getEndDateTime());
                    worklist.add(workTime);
                    ++i;
                    continue;
                }
                worklist.add(workTime);
                continue;
            }
            worklist.add(workTime);
        }
        return worklist;
    }

    @Override
    public List<CalendarShiftPeroid> getTaskTimeByDefault(LocalDateTime startDate) {
        Calendar CalCalendar = this.calendarDao.getDefaultCalendar();
        if (CalCalendar != null) {
            String calendarId = CalCalendar.getId();
            List<CalendarShiftPeroid> worklist = this.calendarSettingManager.getByCalendarId(calendarId, startDate);
            return worklist;
        }
        return null;
    }

    @Override
    public List<Map<String, String>> getAssignUserType() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", "1");
        map.put("name", "\u7528\u6237");
        list.add(map);
        map = new HashMap();
        map.put("id", "2");
        map.put("name", "\u7ec4\u7ec7");
        list.add(map);
        return list;
    }

    @Override
    public void delByCalId(String[] calIds) {
        for (String calId : calIds) {
            ((CalendarAssignDao)this.baseMapper).delByCalId(calId);
        }
    }

    @Override
    public CalendarAssign getbyAssignId(String assignId) {
        return ((CalendarAssignDao)this.baseMapper).getbyAssign(assignId);
    }

    @Override
    public List<String> saveAssign(String assign) throws Exception {
        ArrayList<String> duplicateNames = new ArrayList<String>();
        ObjectNode jobject = (ObjectNode)JsonUtil.toJsonNode((String)assign);
        String assignType = jobject.get("assignType").asText();
        String calendarId = jobject.get("calendarId").asText();
        ArrayNode jsonArray = (ArrayNode)jobject.get("assign");
        String id = null;
        try {
            id = jobject.get("id").asText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Object object : jsonArray) {
            CalendarAssign oldAssign;
            ObjectNode jObj = (ObjectNode)JsonUtil.toJsonNode(object);
            String assignId = jObj.get("id").asText();
            String assignUserName = "";
            if (assignType.equals("1")) {
                assignUserName = jObj.get("fullname").asText();
            } else if (assignType.equals("2")) {
                assignUserName = jObj.get("name").asText();
            }
            CalendarAssign calendarAssign = new CalendarAssign();
            calendarAssign.setAssignId(assignId);
            calendarAssign.setAssignType(assignType);
            calendarAssign.setCanlendarId(calendarId);
            calendarAssign.setAssignUserName(assignUserName);
            if (StringUtil.isNotEmpty((String)id)) {
                oldAssign = this.getbyAssignId(assignId);
                if (oldAssign != null && !oldAssign.getId().equals(id)) {
                    duplicateNames.add(jObj.get("name").asText());
                    continue;
                }
                calendarAssign.setId(id);
                this.update((Model)calendarAssign);
                continue;
            }
            oldAssign = this.getbyAssignId(assignId);
            if (oldAssign != null) {
                duplicateNames.add(jObj.get("name").asText());
                continue;
            }
            calendarAssign.setId(UniqueIdUtil.getSuid());
            this.create((Model)calendarAssign);
        }
        return duplicateNames;
    }
}

