/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.Calendar.dao.CalendarShiftDao;
import com.hotent.Calendar.dao.CalendarShiftPeroidDao;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.manager.CalendarShiftManager;
import com.hotent.Calendar.manager.CalendarShiftPeroidManager;
import com.hotent.Calendar.model.CalendarShift;
import com.hotent.Calendar.model.CalendarShiftPeroid;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="calendarShiftManager")
public class CalendarShiftManagerImpl
extends BaseManagerImpl<CalendarShiftDao, CalendarShift>
implements CalendarShiftManager {
    @Resource
    CalendarShiftPeroidDao calendarShiftPeroidDao;
    @Resource
    CalendarShiftPeroidManager calendarShiftPeroidManager;
    @Resource
    CalendarSettingManager calendarSettingManager;

    public void create(CalendarShift calendarShift) {
        super.create((Model)calendarShift);
        String shiftId = calendarShift.getId();
        this.calendarShiftPeroidDao.delByMainId(shiftId);
        List<CalendarShiftPeroid> workTimeList = calendarShift.getCalendarShiftPeroidList();
        for (CalendarShiftPeroid CalendarShiftPeroid2 : workTimeList) {
            CalendarShiftPeroid2.setShiftId(shiftId);
            this.calendarShiftPeroidManager.create((Model)CalendarShiftPeroid2);
        }
    }

    public void remove(String entityId) {
        super.remove((Serializable)((Object)entityId));
        this.calendarShiftPeroidDao.delByMainId(entityId);
    }

    public CalendarShift get(String entityId) {
        CalendarShift CalendarShift2 = (CalendarShift)super.get((Serializable)((Object)entityId));
        List<CalendarShiftPeroid> calendarShiftPeroidList = this.calendarShiftPeroidDao.getCalendarShiftPeroidList(entityId);
        CalendarShift2.setCalendarShiftPeroidList(calendarShiftPeroidList);
        return CalendarShift2;
    }

    public void update(CalendarShift calendarShift) {
        super.update((Model)calendarShift);
        String shiftId = calendarShift.getId();
        this.calendarShiftPeroidDao.delByMainId(shiftId);
        List<CalendarShiftPeroid> calendarShiftPeroidList = calendarShift.getCalendarShiftPeroidList();
        for (CalendarShiftPeroid calendarShiftPeroid : calendarShiftPeroidList) {
            if (StringUtil.isEmpty((String)calendarShiftPeroid.getId())) {
                calendarShiftPeroid.setId(UniqueIdUtil.getSuid());
            }
            calendarShiftPeroid.setShiftId(shiftId);
            this.calendarShiftPeroidDao.insert(calendarShiftPeroid);
        }
    }

    public void workTimeAdd(Long shiftId, String[] startTime, String[] endTime, String[] memo) {
        if (startTime != null && endTime != null) {
            this.calendarShiftPeroidDao.delByMainId(shiftId.toString());
            for (int idx = 0; idx < startTime.length; ++idx) {
                CalendarShiftPeroid CalendarShiftPeroid2 = new CalendarShiftPeroid();
                CalendarShiftPeroid2.setShiftId(shiftId.toString());
                CalendarShiftPeroid2.setStartTime(startTime[idx]);
                CalendarShiftPeroid2.setEndTime(endTime[idx]);
                CalendarShiftPeroid2.setMemo(memo[idx]);
                this.calendarShiftPeroidDao.insert(CalendarShiftPeroid2);
            }
        }
    }

    @Override
    public void setDefaultShift(String id) {
        ((CalendarShiftDao)this.baseMapper).setNotDefaultShift();
        CalendarShift calendarShift = this.get(id);
        calendarShift.setIsDefault("1");
        this.update(calendarShift);
    }
}

