/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.Calendar.dao.CalendarShiftPeroidDao;
import com.hotent.Calendar.manager.CalendarAssignManager;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.manager.CalendarShiftPeroidManager;
import com.hotent.Calendar.model.CalendarSetting;
import com.hotent.Calendar.model.CalendarShiftPeroid;
import com.hotent.Calendar.model.TimePeroid;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.time.TimeUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="calendarShiftPeroidManager")
public class CalendarShiftPeroidManagerImpl
extends BaseManagerImpl<CalendarShiftPeroidDao, CalendarShiftPeroid>
implements CalendarShiftPeroidManager {
    @Resource
    CalendarAssignManager calendarAssignManager;
    @Resource
    CalendarSettingManager calendarSettingManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    public List<TimePeroid> getRealShiftPeroidList(String userId, LocalDateTime start_time, LocalDateTime end_time) {
        List<TimePeroid> timePeroidList = this.getShiftTimePeroidList(userId, start_time, end_time);
        Iterator<TimePeroid> it = timePeroidList.iterator();
        while (it.hasNext()) {
            TimePeroid timePeroid = it.next();
            LocalDateTime starDate = timePeroid.getStartDate();
            LocalDateTime endDate = timePeroid.getEndDate();
            if (timePeroid == null) continue;
            if (starDate.compareTo(start_time) <= 0 && endDate.compareTo(start_time) <= 0 || starDate.compareTo(end_time) >= 0 && endDate.compareTo(end_time) >= 0) {
                it.remove();
                continue;
            }
            if (starDate.compareTo(start_time) < 0 && endDate.compareTo(end_time) > 0) {
                timePeroid.setStartDate(start_time);
                timePeroid.setEndDate(end_time);
                continue;
            }
            if (starDate.compareTo(start_time) < 0 && endDate.compareTo(start_time) > 0) {
                timePeroid.setStartDate(start_time);
                continue;
            }
            if (starDate.compareTo(end_time) >= 0 || endDate.compareTo(end_time) <= 0) continue;
            timePeroid.setEndDate(end_time);
        }
        return timePeroidList;
    }

    public List<CalendarSetting> getShiftPeroidList(String userId, LocalDateTime start_time, LocalDateTime end_time) {
        String calendarId = this.calendarAssignManager.getCalendarIdByUserId(userId);
        List<CalendarSetting> calendarSettingList = this.calendarSettingManager.getByCalendarId(calendarId, start_time, end_time);
        return calendarSettingList;
    }

    public List<TimePeroid> getShiftTimePeroidList(String userId, LocalDateTime start_time, LocalDateTime end_time) {
        List<CalendarSetting> list = this.getShiftPeroidList(userId, start_time, end_time);
        ArrayList<TimePeroid> timePeroidList = new ArrayList<TimePeroid>();
        for (CalendarSetting calendarSetting : list) {
            if (!"1".equals(calendarSetting.getDateType())) continue;
            String claDay = calendarSetting.getCalDay();
            List<CalendarShiftPeroid> cspList = calendarSetting.getCalendarShiftPeroidList();
            if (cspList == null || cspList.size() <= 0) continue;
            for (CalendarShiftPeroid calendarShiftPeroid : cspList) {
                LocalDateTime starDate = TimeUtil.getDateTimeByTimeString((String)(claDay + " " + calendarShiftPeroid.getStartTime() + ":00"));
                LocalDateTime endDate = TimeUtil.getDateTimeByTimeString((String)(claDay + " " + calendarShiftPeroid.getEndTime() + ":00"));
                TimePeroid timePeroid = new TimePeroid(starDate, endDate, "shift");
                timePeroidList.add(timePeroid);
            }
        }
        return timePeroidList;
    }

    @Override
    public List<CalendarShiftPeroid> getByShiftId(String shiftId) {
        return ((CalendarShiftPeroidDao)this.baseMapper).getCalendarShiftPeroidList(shiftId);
    }

    @Override
    public void shiftPeroidAdd(String shiftId, String[] startTime, String[] endTime, String[] memo) {
        if (startTime != null && endTime != null) {
            ((CalendarShiftPeroidDao)this.baseMapper).delByMainId(shiftId);
            for (int idx = 0; idx < startTime.length; ++idx) {
                CalendarShiftPeroid calendarShiftPeroid = new CalendarShiftPeroid();
                try {
                    calendarShiftPeroid.setId(this.idGenerator.getSuid());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                calendarShiftPeroid.setShiftId(shiftId);
                calendarShiftPeroid.setStartTime(startTime[idx]);
                calendarShiftPeroid.setEndTime(endTime[idx]);
                calendarShiftPeroid.setMemo(memo[idx]);
                this.create((Model)calendarShiftPeroid);
            }
        }
    }
}

