/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.model;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.TimeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class TimePeroid
implements Comparable<TimePeroid> {
    protected LocalDateTime startDate;
    protected LocalDateTime endDate;
    protected long time;
    protected String PeroidType;
    public static final String PEROID_TYPE_SHIFT = "shift";
    public static final String PEROID_TYPE_ABSENCE = "absence";
    public static final String PEROID_TYPE_OVER = "over";

    public TimePeroid() {
    }

    public TimePeroid(LocalDateTime strat_date, LocalDateTime end_date, String peroid_type) {
        this.startDate = strat_date;
        this.endDate = end_date;
        this.time = this.getTime(end_date) - this.getTime(strat_date);
        this.PeroidType = peroid_type;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime beginDate) {
        this.startDate = beginDate;
        this.time = this.getTime(this.endDate) - this.getTime(beginDate);
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
        this.time = this.getTime(endDate) - this.getTime(this.getStartDate());
    }

    public long getTime() {
        return this.getTime(this.endDate) - this.getTime(this.startDate);
    }

    public void setTime(Long time) {
        this.time = time;
    }

    @Override
    public int compareTo(TimePeroid timePeroid) {
        if (null == timePeroid) {
            return 1;
        }
        return this.startDate.compareTo(timePeroid.startDate);
    }

    public String toString() {
        return TimeUtil.getDateTimeString((LocalDateTime)this.getStartDate()) + "~" + TimeUtil.getDateTimeString((LocalDateTime)this.getEndDate()) + "[" + this.PeroidType + "][" + this.time / 60000L + "]";
    }

    private long getTime(LocalDateTime date) {
        if (BeanUtils.isEmpty((Object)date)) {
            return 0L;
        }
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = date.atZone(zone).toInstant();
        return instant.toEpochMilli();
    }
}

