/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.service.impl;

import com.hotent.Calendar.calc.ICalendarCalc;
import com.hotent.Calendar.manager.CalendarAssignManager;
import com.hotent.Calendar.model.TimePeroid;
import com.hotent.Calendar.util.CalendarUtil;
import com.hotent.base.calendar.ICalendarService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.TimeUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class CalendarServiceImpl
implements ICalendarService {
    @Resource
    CalendarAssignManager calendarAssignManager;
    @Resource
    SortedMap<String, ICalendarCalc> calendarCalcMap;

    public LocalDateTime getEndTimeByUser(String userId, long time) throws Exception {
        return this.getEndTimeByUser(userId, LocalDateTime.now(), time);
    }

    public LocalDateTime getEndTimeByUser(String userId, LocalDateTime startTime, long time) throws Exception {
        if (BeanUtils.isEmpty((Object)startTime)) {
            return null;
        }
        LocalDateTime date = null;
        LocalDateTime endTime = startTime;
        LocalDateTime finalTime = TimeUtil.getNextDays((LocalDateTime)startTime, (int)10950);
        while (date == null && endTime.compareTo(finalTime) < 0) {
            endTime = TimeUtil.getNextDays((LocalDateTime)endTime, (int)120);
            SortedMap<LocalDateTime, TimePeroid> timePeroidMap = new TreeMap<LocalDateTime, TimePeroid>();
            for (Map.Entry<String, ICalendarCalc> entry : this.calendarCalcMap.entrySet()) {
                ICalendarCalc calc = entry.getValue();
                List<TimePeroid> timePeroid = calc.getRealTimePeroidList(userId, startTime, endTime);
                timePeroidMap = calc.overrideCalendarShiftPeroidMap(timePeroidMap, timePeroid);
            }
            date = CalendarUtil.getEndTime(timePeroidMap, time);
        }
        return date;
    }

    public Long getWorkTimeByUser(String userId, LocalDateTime startTime, LocalDateTime endTime) {
        if (endTime.compareTo(startTime) <= 0) {
            return 0L;
        }
        SortedMap<LocalDateTime, TimePeroid> timePeroidMap = new TreeMap<LocalDateTime, TimePeroid>();
        if (BeanUtils.isEmpty(this.calendarCalcMap)) {
            this.calendarCalcMap = (SortedMap)AppUtil.getBean((String)"calendarCalcMap");
        }
        for (Map.Entry<String, ICalendarCalc> entry : this.calendarCalcMap.entrySet()) {
            ICalendarCalc calc = entry.getValue();
            List<TimePeroid> timePeroid = calc.getRealTimePeroidList(userId, startTime, endTime);
            timePeroidMap = calc.overrideCalendarShiftPeroidMap(timePeroidMap, timePeroid);
        }
        return CalendarUtil.getCountTimePeroid(timePeroidMap);
    }
}

