/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.util;

import com.hotent.Calendar.model.TimePeroid;
import com.hotent.base.util.time.TimeUtil;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CalendarUtil {
    public static LocalDateTime getDefaultEndDate(LocalDateTime startTime) {
        return TimeUtil.getNextDays((LocalDateTime)startTime, (int)30);
    }

    public static SortedMap<LocalDateTime, TimePeroid> getTimePeroidMap(List<TimePeroid> list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        TreeMap<LocalDateTime, TimePeroid> timePeroidMap = new TreeMap<LocalDateTime, TimePeroid>();
        for (TimePeroid timePeroid : list) {
            if (timePeroid == null) continue;
            timePeroidMap.put(timePeroid.getStartDate(), timePeroid);
        }
        return timePeroidMap;
    }

    public static long getCountTimePeroid(SortedMap<LocalDateTime, TimePeroid> sortedMap) {
        if (sortedMap == null || sortedMap.size() == 0) {
            return 0L;
        }
        long countTime = 0L;
        for (Map.Entry<LocalDateTime, TimePeroid> entry : sortedMap.entrySet()) {
            TimePeroid val = entry.getValue();
            long tmpTime = val.getTime();
            countTime += tmpTime;
        }
        return countTime;
    }

    public static LocalDateTime getEndTime(SortedMap<LocalDateTime, TimePeroid> sortedMap, long time) throws Exception {
        Map.Entry<LocalDateTime, TimePeroid> entry;
        TimePeroid val;
        long tmpTime;
        long millisecond = time * 60L * 1000L;
        long countTime = 0L;
        TimePeroid timePeroid = new TimePeroid();
        Iterator<Map.Entry<LocalDateTime, TimePeroid>> iter = sortedMap.entrySet().iterator();
        while (iter.hasNext() && (countTime += (tmpTime = (timePeroid = (val = (entry = iter.next()).getValue())).getTime())) < millisecond) {
        }
        if (countTime < millisecond) {
            return null;
        }
        long moreTime = countTime - millisecond;
        long millisecond2 = TimeUtil.getTimeMillis((LocalDateTime)timePeroid.getEndDate()) - moreTime;
        return TimeUtil.getLocalDateTimeByMills((long)millisecond2);
    }

    public static Integer getDaysOfMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.get(5);
    }
}

