/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.hotent.Calendar.dao.CalendarDateTypeDao;
import com.hotent.Calendar.dao.CalendarSettingDao;
import com.hotent.Calendar.dao.CalendarShiftDao;
import com.hotent.Calendar.dao.CalendarShiftPeroidDao;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.model.CalendarDateType;
import com.hotent.Calendar.model.CalendarSetting;
import com.hotent.Calendar.model.CalendarShift;
import com.hotent.Calendar.model.CalendarShiftPeroid;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="calendarSettingManager")
public class CalendarSettingManagerImpl
extends BaseManagerImpl<CalendarSettingDao, CalendarSetting>
implements CalendarSettingManager {
    @Resource
    CalendarShiftPeroidDao calendarShiftPeroidDao;
    @Resource
    CalendarShiftDao calendarShiftDao;
    @Resource
    CalendarDateTypeDao calendarDateTypeDao;
    @Resource
    protected IdGenerator idGenerator;

    @Override
    @Deprecated
    public List<CalendarShiftPeroid> getByCalendarId(String calendarId, LocalDateTime startTime) {
        ArrayList<CalendarShiftPeroid> rtnList = new ArrayList<CalendarShiftPeroid>();
        ArrayList<CalendarShiftPeroid> tmpList = new ArrayList<CalendarShiftPeroid>();
        List<CalendarSetting> list = ((CalendarSettingDao)this.baseMapper).getByCalendarId(calendarId, startTime);
        for (CalendarSetting calendarSetting : list) {
            String calDay = calendarSetting.getCalDay();
            List<CalendarShiftPeroid> workTimeList = calendarSetting.getCalendarShiftPeroidList();
            for (CalendarShiftPeroid calendarShiftPeroid : workTimeList) {
                calendarShiftPeroid.setCalDay(calDay);
                tmpList.add((CalendarShiftPeroid)calendarShiftPeroid.clone());
            }
        }
        int len = tmpList.size();
        for (int i = 0; i < len; ++i) {
            CalendarShiftPeroid curTime = (CalendarShiftPeroid)tmpList.get(i);
            if (i < len - 1) {
                int j = i + 1;
                CalendarShiftPeroid nextTime = (CalendarShiftPeroid)tmpList.get(j);
                if (curTime.getEndDateTime().compareTo(nextTime.getStartDateTime()) > 0) {
                    curTime.setEndDateTime(nextTime.getEndDateTime());
                    rtnList.add(curTime);
                    ++i;
                    continue;
                }
                rtnList.add(curTime);
                continue;
            }
            rtnList.add(curTime);
        }
        return rtnList;
    }

    @Override
    public List<CalendarSetting> getByCalendarId(String calendarId, LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<CalendarShiftPeroid> tmpList = new ArrayList();
        List<Object> list = new ArrayList();
        if ("0".equals(calendarId)) {
            list = this.generateCalendarByDateType(startTime, endTime);
        } else {
            String endDate;
            String startDate = startTime != null ? TimeUtil.getDateString((LocalDateTime)startTime) : null;
            list = ((CalendarSettingDao)this.baseMapper).getSegmentByCalId(calendarId, startDate, endDate = endTime != null ? TimeUtil.getDateString((LocalDateTime)endTime) : null);
            if (list == null || list.size() <= 0) {
                list = this.generateCalendarByDateType(startTime, endTime);
            }
        }
        for (CalendarSetting calendarSetting : list) {
            String shiftId = calendarSetting.getShiftId();
            tmpList = this.calendarShiftPeroidDao.getCalendarShiftPeroidList(shiftId);
            calendarSetting.setCalendarShiftPeroidList(tmpList);
        }
        return list;
    }

    @Override
    public List<CalendarSetting> getCalByIdYearMon(String id, int year, int month) {
        return ((CalendarSettingDao)this.baseMapper).getCalByIdYearMon(id, year, month);
    }

    @Override
    public List<CalendarSetting> getCalByIdYear(String id, int year) {
        return ((CalendarSettingDao)this.baseMapper).getCalByIdYear(id, year);
    }

    @Override
    public void delByCalidYearMon(String calid, Short year, Short month) {
        ((CalendarSettingDao)this.baseMapper).delByCalidYearMon(calid, year, month);
    }

    @Override
    public void delByCalId(String[] calIds) {
        for (String calId : calIds) {
            ((CalendarSettingDao)this.baseMapper).delByCalId(calId);
        }
    }

    private List<CalendarSetting> generateTempCalendar(LocalDateTime startTime, LocalDateTime endTime) {
        ArrayList<CalendarSetting> list = new ArrayList<CalendarSetting>();
        CalendarShift calendarShift = this.calendarShiftDao.getUniqueDefaultShift();
        if (calendarShift == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u73ed\u6b21");
        }
        String shiftId = calendarShift.getId();
        ZoneId zone = ZoneId.systemDefault();
        Instant sinstant = startTime.atZone(zone).toInstant();
        Instant einstant = endTime.atZone(zone).toInstant();
        double times = (double)(einstant.toEpochMilli() - sinstant.toEpochMilli()) / 8.64E7;
        int n = (int)Math.ceil(times);
        for (int i = 0; i <= n; ++i) {
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zdt = startTime.atZone(zoneId);
            Date date = Date.from(zdt.toInstant());
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(6, i);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String calDay = sdf.format(c.getTime());
            int years = c.get(1);
            int months = c.get(2) + 1;
            int days = c.get(5);
            int weeks = c.get(7) - 1;
            weeks = weeks == 0 ? 7 : weeks;
            CalendarSetting calendarSetting = new CalendarSetting();
            calendarSetting.setId(this.idGenerator.getSuid());
            calendarSetting.setCalendarId(this.idGenerator.getSuid());
            calendarSetting.setYears(Long.valueOf(years));
            calendarSetting.setMonths(Long.valueOf(months));
            calendarSetting.setDays(Long.valueOf(days));
            calendarSetting.setShiftId(shiftId);
            calendarSetting.setCalDay(calDay);
            calendarSetting.setDateType("1");
            list.add(calendarSetting);
        }
        return list;
    }

    @Override
    public List<CalendarSetting> generateCalendarByDateType(LocalDateTime startTime, LocalDateTime endTime) {
        List<CalendarSetting> list = this.generateTempCalendar(startTime, endTime);
        List<CalendarDateType> phList = this.calendarDateTypeDao.getPhByWeekList();
        List<CalendarDateType> lhList = this.calendarDateTypeDao.getLhByYearList();
        List<CalendarDateType> chList = this.calendarDateTypeDao.getChByYearList();
        for (CalendarSetting calendarSetting : list) {
            LocalDateTime date = null;
            try {
                date = DateFormatUtil.parse((String)(calendarSetting.getCalDay() + " 00:00:00"));
            }
            catch (ParseException e) {
                throw new RuntimeException("", e);
            }
            for (CalendarDateType calDateType : lhList) {
                if (date.compareTo(calDateType.getYearBegin()) > 0 || date.compareTo(calDateType.getYearEnd()) < 0) continue;
                calendarSetting.setDateType("2");
            }
            for (CalendarDateType calDateType : chList) {
                if (date.compareTo(calDateType.getYearBegin()) > 0 || date.compareTo(calDateType.getYearEnd()) < 0) continue;
                calendarSetting.setDateType("2");
            }
        }
        return list;
    }
}

