/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.model;

import com.hotent.Calendar.util.CalendarUtil;
import java.util.ArrayList;
import java.util.List;

public class CalendarSettingEvent {
    private Integer startYear;
    private Integer endYear;
    private Integer startMonth;
    private Integer endMonth;
    private Integer startDay;
    private Integer endDay;
    private String shiftId;

    public CalendarSettingEvent() {
    }

    public CalendarSettingEvent(Integer startYear, Integer endYear, Integer startMonth, Integer endMonth, Integer startDay, Integer endDay, String shiftId) {
        this.startYear = startYear;
        this.endYear = endYear;
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        this.startDay = startDay;
        this.endDay = endDay;
        this.shiftId = shiftId;
    }

    public CalendarSettingEvent(Long startYear, Long endYear, Long startMonth, Long endMonth, Long startDay, Long endDay, String shiftId) {
        this.startYear = startYear.intValue();
        this.endYear = endYear.intValue();
        this.startMonth = startMonth.intValue();
        this.endMonth = endMonth.intValue();
        this.startDay = startDay.intValue();
        this.endDay = endDay.intValue();
        this.shiftId = shiftId;
    }

    public Integer getStartYear() {
        return this.startYear;
    }

    public void setStartYear(Integer startYear) {
        this.startYear = startYear;
    }

    public Integer getEndYear() {
        return this.endYear;
    }

    public void setEndYear(Integer endYear) {
        this.endYear = endYear;
    }

    public Integer getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(Integer startMonth) {
        this.startMonth = startMonth;
    }

    public Integer getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(Integer endMonth) {
        this.endMonth = endMonth;
    }

    public Integer getStartDay() {
        return this.startDay;
    }

    public void setStartDay(Integer startDay) {
        this.startDay = startDay;
    }

    public Integer getEndDay() {
        return this.endDay;
    }

    public void setEndDay(Integer endDay) {
        this.endDay = endDay;
    }

    public String getShiftId() {
        return this.shiftId;
    }

    public void setShiftId(String shiftId) {
        this.shiftId = shiftId;
    }

    public List<CalendarSettingEvent> partition() throws Exception {
        ArrayList<CalendarSettingEvent> list = new ArrayList<CalendarSettingEvent>();
        if (this.yearsMinus() > 0) {
            Integer daysOfMonth = CalendarUtil.getDaysOfMonth(this.startYear, 12);
            CalendarSettingEvent startEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.startMonth, 12, this.startDay, daysOfMonth, this.shiftId);
            CalendarSettingEvent endEvent = new CalendarSettingEvent(this.endYear, this.endYear, 1, this.endMonth, 1, this.endDay, this.shiftId);
            list.add(startEvent);
            list.add(endEvent);
        } else if (this.monthMinus() == 1) {
            Integer daysOfMonth = CalendarUtil.getDaysOfMonth(this.startYear, this.startMonth);
            CalendarSettingEvent startEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.startMonth, this.startMonth, this.startDay, daysOfMonth, this.shiftId);
            CalendarSettingEvent endEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.endMonth, this.endMonth, 1, this.endDay, this.shiftId);
            list.add(startEvent);
            list.add(endEvent);
        } else if (this.monthMinus() == 2) {
            Integer daysOfMonth = CalendarUtil.getDaysOfMonth(this.startYear, this.startMonth);
            CalendarSettingEvent startEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.startMonth, this.startMonth, this.startDay, daysOfMonth, this.shiftId);
            Integer daysOfMonth2 = CalendarUtil.getDaysOfMonth(this.startYear, this.startMonth + 1);
            CalendarSettingEvent midEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.startMonth + 1, this.startMonth + 1, 1, daysOfMonth2, this.shiftId);
            CalendarSettingEvent endEvent = new CalendarSettingEvent(this.startYear, this.startYear, this.endMonth, this.endMonth, 1, this.endDay, this.shiftId);
            list.add(startEvent);
            list.add(midEvent);
            list.add(endEvent);
        }
        return list;
    }

    public Boolean shouldPartition() throws Exception {
        if (this.yearsMinus() > 0) {
            return true;
        }
        if (this.monthMinus() > 0) {
            return true;
        }
        return false;
    }

    private Integer yearsMinus() throws Exception {
        Integer minus = this.endYear - this.startYear;
        if (minus < 0 || minus > 1) {
            throw new RuntimeException("\u5de5\u4f5c\u65e5\u5386\u7684\u8bbe\u7f6e\u6709\u8bef");
        }
        return minus;
    }

    private Integer monthMinus() throws Exception {
        Integer minus = this.endMonth - this.startMonth;
        if (minus < 0 || minus > 1) {
            throw new RuntimeException("\u5de5\u4f5c\u65e5\u5386\u7684\u8bbe\u7f6e\u6709\u8bef");
        }
        return minus;
    }
}

