/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.controller;

import com.hotent.Calendar.manager.CalendarAssignManager;
import com.hotent.Calendar.manager.CalendarManager;
import com.hotent.Calendar.model.CalendarAssign;
import com.hotent.Calendar.params.CalendarAssignGetVo;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.calendar.ICalendarService;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendar/assign/v1/"})
@Api(tags={"\u65e5\u5386\u5206\u914d"})
@ApiGroup(group={"group_portal"})
public class CalendarAssignController
extends BaseController<CalendarAssignManager, CalendarAssign> {
    @Resource
    CalendarAssignManager calendarAssignManager;
    @Resource
    CalendarManager calendarManager;
    @Resource
    ICalendarService iCalendarService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65e5\u5386\u5206\u914d\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u65e5\u5386\u5206\u914d\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<CalendarAssign> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<CalendarAssign> queryFilter) throws Exception {
        return this.calendarAssignManager.query(queryFilter);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5386\u5206\u914d\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u65e5\u5386\u5206\u914d\u8be6\u7ec6\u4fe1\u606f")
    public CalendarAssignGetVo get(@ApiParam(name="id", value="\u65e5\u5386\u5206\u914did", required=true) @RequestParam String id) throws Exception {
        List calendarList = this.calendarManager.getAll();
        CalendarAssign calendarAssign = null;
        if (StringUtil.isNotEmpty((String)id)) {
            calendarAssign = (CalendarAssign)this.calendarAssignManager.get((Serializable)((Object)id));
        }
        return new CalendarAssignGetVo(calendarAssign, calendarList);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u65e5\u5386\u5206\u914d\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u65e5\u5386\u5206\u914d\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="map", value="\u65e5\u5386\u5206\u914d\u4fe1\u606f", required=true) @RequestBody Map<String, Object> map) throws Exception {
        String assignStr = MapUtil.getString(map, (String)"assign");
        List<String> duplicateNames = this.calendarAssignManager.saveAssign(assignStr);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)JsonUtil.toJson(duplicateNames));
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u65e5\u5386\u5206\u914d\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u65e5\u5386\u5206\u914d\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u65e5\u5386\u5206\u914d\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.calendarAssignManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

