/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.controller;

import com.hotent.Calendar.manager.CalendarAssignManager;
import com.hotent.Calendar.manager.CalendarDateTypeManager;
import com.hotent.Calendar.manager.CalendarManager;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.manager.CalendarShiftManager;
import com.hotent.Calendar.model.Calendar;
import com.hotent.Calendar.model.CalendarSettingEvent;
import com.hotent.Calendar.params.CalendarSettingGetVo;
import com.hotent.Calendar.params.CalendarSettingVo;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendar/work/v1/"})
@Api(tags={"\u5de5\u4f5c\u65e5\u5386\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class WorkController
extends BaseController<CalendarManager, Calendar> {
    @Resource
    CalendarManager calendarManager;
    @Resource
    CalendarAssignManager calendarAssignManager;
    @Resource
    CalendarSettingManager calendarSettingManager;
    @Resource
    CalendarShiftManager calendarShiftManager;
    @Resource
    CalendarDateTypeManager calendarDateTypeManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u65e5\u5386\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u7cfb\u7edf\u65e5\u5386\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<Calendar> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Calendar> queryFilter) throws Exception {
        return this.calendarManager.query(queryFilter);
    }

    @RequestMapping(value={"detail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u7ec6\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u8be6\u7ec6\u4fe1\u606f")
    public CalendarSettingGetVo detail(@ApiParam(name="id", value="\u5de5\u4f5c\u65e5\u5386id", required=true) @RequestParam String id) throws Exception {
        CalendarSettingGetVo workGetVo = new CalendarSettingGetVo();
        if (StringUtil.isNotEmpty((String)id)) {
            Calendar calendar = (Calendar)this.calendarManager.get((Serializable)((Object)id));
            workGetVo.setCalendar(calendar);
        }
        List shifts = this.calendarShiftManager.getAll();
        workGetVo.setShifts(shifts);
        return workGetVo;
    }

    @RequestMapping(value={"calendarSetting"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e", httpMethod="GET", notes="\u67e5\u8be2\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e")
    public CalendarSettingVo calendarSetting(@ApiParam(name="id", value="\u65e5\u5386id", required=true) @RequestParam String id, @ApiParam(name="year", value="\u5e74\u4efd", required=true) @RequestParam Integer year) throws Exception {
        if (StringUtil.isEmpty((String)id) || BeanUtils.isEmpty((Object)year)) {
            return null;
        }
        List<CalendarSettingEvent> calendarSettingEvent = this.calendarManager.getCalendarSettingEvent(id, year);
        return new CalendarSettingVo(calendarSettingEvent, year, true);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5386\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5386\u4fe1\u606f")
    public Calendar get(@ApiParam(name="id", value="\u7cfb\u7edf\u65e5\u5386id", required=true) @RequestParam String id) throws Exception {
        Calendar calendar = null;
        if (StringUtil.isNotEmpty((String)id)) {
            calendar = (Calendar)this.calendarManager.get((Serializable)((Object)id));
        }
        return calendar;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u65e5\u5386\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u65e5\u5386\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="map", value="\u7cfb\u7edf\u65e5\u5386\u4fe1\u606f", required=true) @RequestBody Map<String, Object> map) throws Exception {
        String json = MapUtil.getString(map, (String)"calendar");
        this.calendarManager.saveCalendar(json);
        return new CommonResult(true, "\u65e5\u5386\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u65e5\u5386(\u903b\u8f91\u5220\u9664)", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u65e5\u5386(\u903b\u8f91\u5220\u9664)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u7cfb\u7edf\u65e5\u5386ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.calendarAssignManager.delByCalId(aryIds);
        this.calendarSettingManager.delByCalId(aryIds);
        this.calendarManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"setDefault"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u65f6\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u662f\u9ed8\u8ba4\u7684", httpMethod="GET", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u65f6\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u662f\u9ed8\u8ba4\u7684")
    public CommonResult<String> setDefault(@ApiParam(name="id", value="\u65e5\u5386id", required=true) @RequestParam String id) throws Exception {
        this.calendarManager.setDefaultCal(id);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f");
    }
}

