/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.hotent.Calendar.dao.CalendarDateTypeDao;
import com.hotent.Calendar.manager.CalendarDateTypeManager;
import com.hotent.Calendar.model.CalendarDateType;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="calDateTypeManager")
public class CalendarDateTypeManagerImpl
extends BaseManagerImpl<CalendarDateTypeDao, CalendarDateType>
implements CalendarDateTypeManager {
    @Override
    public Map<Integer, String> getLhByYearMon(String statTime, String endTime) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        LocalDateTime startDate = TimeUtil.convertString((String)statTime, (String)"yyyy-MM-dd");
        LocalDateTime endDate = TimeUtil.convertString((String)endTime, (String)"yyyy-MM-dd");
        List<CalendarDateType> valist = ((CalendarDateTypeDao)this.baseMapper).getLhByYearList();
        int curMonth = Integer.parseInt(statTime.split("-")[1]);
        for (CalendarDateType va : valist) {
            LocalDateTime[] days;
            if (va.getYearBegin().compareTo(startDate) < 0 && va.getYearEnd().compareTo(endDate) > 0) continue;
            for (LocalDateTime day : days = DateUtil.getDaysBetween((LocalDateTime)va.getYearBegin(), (LocalDateTime)va.getYearEnd())) {
                int tmpMonth = day.getMonthValue();
                if (curMonth != tmpMonth) continue;
                map.put(days.length, va.getName());
            }
        }
        return map;
    }

    @Override
    public Map<Integer, String> getPhByWeekMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        List<CalendarDateType> phList = ((CalendarDateTypeDao)this.baseMapper).getPhByWeekList();
        for (CalendarDateType calendarDateType : phList) {
            map.put(calendarDateType.getWeekBegin().intValue(), calendarDateType.getName());
        }
        return map;
    }
}

