/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.Calendar.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.Calendar.dao.CalendarDao;
import com.hotent.Calendar.dao.CalendarSettingDao;
import com.hotent.Calendar.manager.CalendarManager;
import com.hotent.Calendar.manager.CalendarSettingManager;
import com.hotent.Calendar.model.Calendar;
import com.hotent.Calendar.model.CalendarSetting;
import com.hotent.Calendar.model.CalendarSettingEvent;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="CalendarManager")
public class CalendarManagerImpl
extends BaseManagerImpl<CalendarDao, Calendar>
implements CalendarManager {
    @Resource
    IdGenerator idGenerator;
    @Resource
    CalendarSettingDao calendarSettingDao;
    @Resource
    CalendarSettingManager calendarSettingManager;

    @Override
    public Calendar getDefaultCalendar() {
        return ((CalendarDao)this.baseMapper).getDefaultCalendar();
    }

    @Override
    public void setNotDefaultCal(Long id) {
        ((CalendarDao)this.baseMapper).setNotDefaultCal();
        Calendar syscal = (Calendar)this.get((Serializable)((Object)id.toString()));
        syscal.setIsDefault('1');
        this.update((Model)syscal);
    }

    @Override
    public List<CalendarSettingEvent> getCalendarSettingEvent(String calendarId, int year) {
        ArrayList<CalendarSettingEvent> events = new ArrayList<CalendarSettingEvent>();
        List<CalendarSetting> settings = this.calendarSettingDao.getCalByIdYear(calendarId, year);
        if (BeanUtils.isEmpty(settings)) {
            return events;
        }
        HashSet<List<CalendarSetting>> set = new HashSet<List<CalendarSetting>>();
        CalendarSetting firstSetting = settings.get(0);
        this.hanlderSetting(set, settings, firstSetting.getMonths(), firstSetting.getDays(), firstSetting.getShiftId());
        this.convert2settingEvent(events, set);
        return events;
    }

    private void hanlderSetting(Set<List<CalendarSetting>> set, List<CalendarSetting> settings, Long preMonth, Long preDay, String preShiftId) {
        ArrayList<CalendarSetting> partitions = new ArrayList<CalendarSetting>();
        set.add(partitions);
        Iterator<CalendarSetting> iter = settings.iterator();
        while (iter.hasNext()) {
            CalendarSetting calendarSetting = iter.next();
            Long months = calendarSetting.getMonths();
            Long days = calendarSetting.getDays();
            String shiftId = calendarSetting.getShiftId();
            Boolean shiftCompare = false;
            if (StringUtil.isEmpty((String)preShiftId)) {
                if (StringUtil.isEmpty((String)shiftId)) {
                    shiftCompare = true;
                }
            } else {
                shiftCompare = preShiftId.equals(shiftId);
            }
            if (preMonth.equals(months) && (preDay.equals(days) || days.intValue() - preDay.intValue() == 1) && shiftCompare.booleanValue()) {
                preDay = days;
                partitions.add(calendarSetting);
                iter.remove();
                continue;
            }
            this.hanlderSetting(set, settings, months, days, shiftId);
            break;
        }
    }

    private void convert2settingEvent(List<CalendarSettingEvent> events, Set<List<CalendarSetting>> set) {
        for (List<CalendarSetting> list : set) {
            CalendarSetting startSetting = list.get(0);
            CalendarSetting endSetting = list.get(list.size() - 1);
            Long years = startSetting.getYears();
            Long months = startSetting.getMonths();
            CalendarSettingEvent event = new CalendarSettingEvent(years, years, months, months, startSetting.getDays(), endSetting.getDays(), endSetting.getShiftId());
            events.add(event);
        }
    }

    @Override
    public String saveCalendar(String json) throws Exception {
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String baseStr = jsonObject.get("base").toString();
        String settingEventsStr = jsonObject.get("settingEvents").toString();
        if (StringUtil.isEmpty((String)baseStr) || StringUtil.isEmpty((String)settingEventsStr)) {
            throw new RuntimeException("\u5de5\u4f5c\u65e5\u5386\u7684\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Calendar calendar = (Calendar)JsonUtil.toBean((String)baseStr, Calendar.class);
        ArrayList<CalendarSettingEvent> calendarSettingEvents = new ArrayList<CalendarSettingEvent>();
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)settingEventsStr);
        for (JsonNode jsonNode : array) {
            calendarSettingEvents.add((CalendarSettingEvent)JsonUtil.toBean((JsonNode)jsonNode, CalendarSettingEvent.class));
        }
        String calendarId = calendar.getId();
        if (StringUtil.isEmpty((String)calendarId)) {
            calendarId = this.idGenerator.getSuid();
            Calendar defaultCal = ((CalendarDao)this.baseMapper).getDefaultCalendar();
            calendar.setId(calendarId);
            if (defaultCal == null) {
                calendar.setIsDefault('1');
            } else {
                calendar.setIsDefault('0');
            }
            this.create((Model)calendar);
        } else {
            this.update((Model)calendar);
            this.calendarSettingDao.delByCalendarId(calendarId);
        }
        if (BeanUtils.isNotEmpty(calendarSettingEvents)) {
            this.handlerCalendarSetting(calendarId, calendarSettingEvents);
        }
        return calendarId;
    }

    private void handlerCalendarSetting(String calendarId, List<CalendarSettingEvent> calendarSettingEvents) throws Exception {
        for (CalendarSettingEvent event : calendarSettingEvents) {
            this.handlerCalendarSettingEvent(calendarId, event);
        }
    }

    private void handlerCalendarSettingEvent(String calendarId, CalendarSettingEvent event) throws Exception {
        if (event.shouldPartition().booleanValue()) {
            List<CalendarSettingEvent> partitions = event.partition();
            for (CalendarSettingEvent partition : partitions) {
                this.handlerCalendarSettingEvent(calendarId, partition);
            }
        } else {
            this.addCalendarSetting(calendarId, event);
        }
    }

    private void addCalendarSetting(String calendarId, CalendarSettingEvent event) throws Exception {
        Integer year = event.getStartYear();
        Integer month = event.getStartMonth();
        String shiftId = event.getShiftId();
        int startDay = event.getStartDay();
        int dayMinus = event.getEndDay() - startDay;
        for (int i = 0; i <= dayMinus; ++i) {
            int day = startDay + i;
            CalendarSetting setting = new CalendarSetting();
            setting.setCalendarId(calendarId);
            setting.setYears((long)year);
            setting.setMonths((long)month);
            setting.setDays(Long.valueOf(day));
            setting.setCalDay(this.formatDateString(year, month, day));
            setting.setDateType("2");
            if (StringUtil.isNotEmpty((String)shiftId)) {
                setting.setDateType("1");
                setting.setShiftId(shiftId);
            }
            this.calendarSettingManager.create((Model)setting);
        }
    }

    private String formatDateString(int year, int month, int day) {
        StringBuffer date = new StringBuffer();
        date.append(year);
        date.append("-");
        if (month < 10) {
            date.append("0");
            date.append(month);
        } else {
            date.append(month);
        }
        date.append("-");
        if (day < 10) {
            date.append("0");
            date.append(day);
        } else {
            date.append(day);
        }
        return date.toString();
    }

    @Override
    public void setDefaultCal(String id) {
        ((CalendarDao)this.baseMapper).setNotDefaultCal();
        Calendar syscal = (Calendar)this.get((Serializable)((Object)id));
        syscal.setIsDefault('1');
        this.update((Model)syscal);
    }
}

