/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.column.model.PortalAgendaDay;
import com.hotent.column.persistence.manager.PortalAgendaDayManager;
import com.hotent.column.vo.ReminderPopupVO;
import com.hotent.column.vo.ReminderVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import dm.jdbc.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u65e5\u7a0b\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
@RequestMapping(value={"/portalAgendaDay/v1/"})
public class PortalAgendaDayController
extends BaseController<PortalAgendaDayManager, PortalAgendaDay> {
    @RequestMapping(value={"save"}, method={RequestMethod.POST, RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u65e5\u7a0b")
    public CommonResult<String> save(@ApiParam(name="agendaDay", value="\u65e5\u7a0b\u4fe1\u606f") @RequestBody PortalAgendaDay agendaDay) {
        ((PortalAgendaDayManager)this.baseService).createOrUpdate(agendaDay);
        return new CommonResult("\u4fdd\u5b58\u65e5\u7a0b\u6210\u529f");
    }

    @RequestMapping(value={"getByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u65e5\u7a0b", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u65e5\u7a0b")
    public CommonResult<List<PortalAgendaDay>> getByUserId(@ApiParam(name="userId", value="\u7528\u6237id\uff08\u4e0d\u4f20\u53d6\u5f53\u524d\u7528\u6237\uff09") @RequestParam(required=false) Optional<String> userId) throws Exception {
        String id = userId.orElse("");
        if (StringUtil.isEmpty((String)id)) {
            id = ContextUtil.getCurrentUser().getUserId();
        }
        return CommonResult.success(((PortalAgendaDayManager)this.baseService).getByUserId(id));
    }

    @RequestMapping(value={"getAgendaDayByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u65e5\u7a0b", httpMethod="GET", notes="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u65e5\u7a0b")
    public CommonResult<List<PortalAgendaDay>> getAgendaDay(@ApiParam(name="userId", value="\u7528\u6237id\uff08\u4e0d\u4f20\u53d6\u5f53\u524d\u7528\u6237\uff09") @RequestParam(required=false) Optional<String> userId, @ApiParam(name="startDate", value="\u5f00\u59cb\u65e5\u671f\uff08\u5982\uff1a2021-07-14 00:00:00\uff09") @RequestParam(required=false) Optional<String> startDate, @ApiParam(name="endDate", value="\u7ed3\u675f\u65e5\u671f\uff08\u5982\uff1a2021-07-15 00:00:00\uff09") @RequestParam(required=false) Optional<String> endDate) throws Exception {
        String id = userId.orElse("");
        if (StringUtil.isEmpty((String)id)) {
            id = ContextUtil.getCurrentUserId();
        }
        return CommonResult.success(((PortalAgendaDayManager)this.baseService).getByPeriod(id, startDate, endDate, true));
    }

    @DeleteMapping(value={"/todo/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5f85\u529e\u7c7b\u578b\u65e5\u7a0b")
    public CommonResult<String> deleteTodoById(@ApiParam(name="id", value="\u5f85\u529eid") @PathVariable String id) throws Exception {
        ((PortalAgendaDayManager)this.baseService).deleteTodoById(id);
        return CommonResult.ok();
    }

    @RequestMapping(value={"remind"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d88\u606f\u901a\u77e5", httpMethod="GET", notes="\u6d88\u606f\u901a\u77e5")
    public CommonResult<String> remind() throws Exception {
        ((PortalAgendaDayManager)this.baseService).remind();
        return CommonResult.ok();
    }

    @RequestMapping(value={"reminders"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u9700\u8981\u6d88\u606f\u63d0\u9192\u7684\u65e5\u7a0b\u5217\u8868", httpMethod="GET", notes="\u6d88\u606f\u901a\u77e5")
    public CommonResult<ReminderPopupVO> getMyRemind() throws Exception {
        return CommonResult.success((Object)((PortalAgendaDayManager)this.baseService).getMyRemind());
    }

    @RequestMapping(value={"reminders/update"}, method={RequestMethod.POST, RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u63d0\u524d\u63d0\u9192\u65f6\u95f4")
    public CommonResult<String> updateReminderMinutes(@ApiParam(name="reminderVoList", value="\u65e5\u7a0b\u548c\u63d0\u9192\u65f6\u95f4\u4fe1\u606f") @RequestBody @Valid List<ReminderVO> reminderVoList) {
        ((PortalAgendaDayManager)this.baseService).updateReminderMinutes(reminderVoList);
        return new CommonResult("\u66f4\u65b0\u63d0\u524d\u63d0\u9192\u65f6\u95f4\u6210\u529f");
    }
}

