/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.column.model.PortalCustomTodo;
import com.hotent.column.persistence.manager.PortalCustomTodoManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/portalCustomTodo/v1/"})
@ApiGroup(group={"group_portal"})
@Api(tags={"\u7528\u6237\u81ea\u5b9a\u4e49\u5f85\u529e\u4e8b\u9879"})
public class PortalCustomTodoController
extends BaseController<PortalCustomTodoManager, PortalCustomTodo> {
    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u81ea\u5b9a\u4e49\u5f85\u529e\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u7528\u6237\u81ea\u5b9a\u4e49\u5f85\u529e\u5217\u8868")
    public PageList<PortalCustomTodo> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<PortalCustomTodo> queryFilter) throws Exception {
        queryFilter.addFilter("user_id_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userIdGroup");
        queryFilter.setDefaultSort("sn_", Direction.ASC);
        Boolean isDone = null;
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        String dbType = databaseContext.getDbType();
        List querys = queryFilter.getQuerys();
        for (int i = querys.size() - 1; i >= 0; --i) {
            QueryField query = (QueryField)querys.get(i);
            if (("dm".equalsIgnoreCase(dbType) || "oracle".equalsIgnoreCase(dbType) || "kingbasees".equalsIgnoreCase(dbType)) && "mark".equals(query.getProperty()) && QueryOP.NOT_EQUAL.equals((Object)query.getOperation())) {
                query.setOperation(QueryOP.NOTNULL);
            }
            if (!"isRepeat".equals(query.getProperty())) continue;
            if ("0".equals(query.getValue()) && FieldRelation.AND.equals((Object)query.getRelation())) {
                isDone = true;
                querys.remove(i);
                continue;
            }
            if (!"1".equals(query.getValue()) || !FieldRelation.OR.equals((Object)query.getRelation())) continue;
            isDone = false;
        }
        PageList pageList = ((PortalCustomTodoManager)this.baseService).query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)pageList) && BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            ((PortalCustomTodoManager)this.baseService).handleList(pageList.getRows(), isDone);
        }
        return pageList;
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u81ea\u5b9a\u4e49\u5f85\u529e")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody PortalCustomTodo t) {
        if (StringUtil.isEmpty((String)t.getId())) {
            QueryFilter filter = QueryFilter.build();
            filter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
            filter.addFilter("user_id_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "userIdGroup");
            filter.setDefaultSort("sn_", Direction.DESC);
            PageList query = ((PortalCustomTodoManager)this.baseService).query(filter);
            int sn = 1;
            if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
                sn = ((PortalCustomTodo)((Object)query.getRows().get(0))).getSn() + 1;
            }
            t.setMarkSn(sn);
            t.setSn(sn);
            t.setCreateTime(LocalDateTime.now());
            t.setUserId(ContextUtil.getCurrentUserId());
        }
        if ("1".equals(t.getStatus()) && BeanUtils.isEmpty((Object)t.getCompleteTime())) {
            t.setCompleteTime(LocalDateTime.now());
        }
        t.setUpdateTime(LocalDateTime.now());
        if (BeanUtils.isNotEmpty((Object)t.getCreateTime()) && BeanUtils.isNotEmpty((Object)t.getDeadLine()) && t.getCreateTime().isAfter(t.getDeadLine())) {
            throw new BaseException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u622a\u6b62\u65f6\u95f4\u4e4b\u540e!");
        }
        boolean result = ((PortalCustomTodoManager)this.baseService).saveOrUpdate((Object)t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/batchUpdateSn"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u987a\u5e8f")
    public CommonResult<String> batchUpdateSn(@ApiParam(name="list", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody List<PortalCustomTodo> list) {
        HashMap<String, PortalCustomTodo> todoMap = new HashMap<String, PortalCustomTodo>();
        if (BeanUtils.isNotEmpty(list)) {
            for (PortalCustomTodo todo : list) {
                todoMap.put(todo.getId(), todo);
            }
        }
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("ID_", (Object)StringUtil.join(todoMap.keySet()), QueryOP.IN, FieldRelation.AND, "userIdGroup");
        PageList query = ((PortalCustomTodoManager)this.baseService).query(filter);
        boolean result = false;
        if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
            for (PortalCustomTodo todo : query.getRows()) {
                PortalCustomTodo reqTodo = (PortalCustomTodo)((Object)todoMap.get(todo.getId()));
                if (reqTodo.getSn() != null) {
                    todo.setSn(reqTodo.getSn());
                }
                if (reqTodo.getMarkSn() == null) continue;
                todo.setMarkSn(reqTodo.getMarkSn());
            }
            result = ((PortalCustomTodoManager)this.baseService).updateBatchById(query.getRows());
        }
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }
}

