/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.column.enums.RepeatEndEnum;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.enums.RepeatFrequencyEnum;
import java.lang.reflect.Field;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RepeatExcision<T> {
    public static final Logger logger = LoggerFactory.getLogger(RepeatExcision.class);
    public static final int MAX_DATA = 1000;
    public static final String FIELD_START_TIME = "startTime";
    public static final String FIELD_END_TIME = "endTime";
    public static final String FIELD_REPEAT_END_DATE = "repeatEndDate";
    public static final String FIELD_REPEAT_END_TYPE = "repeatEndType";
    public static final String FIELD_REPEAT_FREQUENCY_TYPE = "repeatFrequencyType";
    public static final String FIELD_REPEAT_TYPE = "repeatType";
    public static final String FIELD_REPEAT_FREQUENCY_INTERVAL = "repeatFrequencyInterval";
    public static final String FIELD_REPEAT_FREQUENCY = "repeatFrequency";

    public RepeatEnum getAgendaRepeatEnum();

    public List<T> handle(T var1, LocalDateTime var2, LocalDateTime var3);

    default public LocalDateTime getFieldDate(T t, String fieldName) {
        try {
            Field field = t.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            if (field.get(t) instanceof LocalDate) {
                LocalDate date = (LocalDate)field.get(t);
                return date.atTime(23, 59, 59);
            }
            return (LocalDateTime)field.get(t);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    default public void setFieldDate(T t, String fieldName, LocalDateTime fieldValue) {
        try {
            Field field = t.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(t, fieldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    default public Integer getFieldInt(T t, String fieldName) {
        try {
            Field field = t.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (Integer)field.get(t);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    default public String getFieldStr(T t, String fieldName) {
        try {
            Field field = t.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(t).toString();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    default public boolean checkStartTime(T t, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        LocalDateTime startTime = this.getFieldDate(t, FIELD_START_TIME);
        LocalDateTime endTime = this.getFieldDate(t, FIELD_END_TIME);
        if (startTime == null || startDateTime == null || endDateTime == null) {
            return false;
        }
        LocalDateTime repeatEndDate = this.getFieldDate(t, FIELD_REPEAT_END_DATE);
        if (repeatEndDate == null) {
            repeatEndDate = LocalDateTime.MAX;
        }
        if (endTime != null && endTime.isBefore(startDateTime)) {
            return false;
        }
        if (startTime.isAfter(endDateTime)) {
            return false;
        }
        return !RepeatEndEnum.ONE_DAY.getValue().equals(this.getFieldInt(t, FIELD_REPEAT_END_TYPE)) || !startTime.toLocalDate().isAfter(repeatEndDate.toLocalDate());
    }

    default public T newInstance(T source) {
        T instance = null;
        try {
            instance = (T)source.getClass().newInstance();
            BeanUtil.copyProperties(source, instance, (String[])new String[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u62f7\u8d1d\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
        }
        return instance;
    }

    default public List<T> partition(T source, List<T> result) {
        LocalDateTime startTime = this.getFieldDate(source, FIELD_START_TIME);
        LocalDateTime endTime = this.getFieldDate(source, FIELD_END_TIME);
        if (startTime == null || endTime == null) {
            return result;
        }
        int compare = endTime.toLocalDate().compareTo(startTime.toLocalDate());
        int compare1 = endTime.plusSeconds(-1L).toLocalDate().compareTo(startTime.toLocalDate());
        if (compare == 0 || compare1 == 0) {
            result.add(source);
        } else if (compare > 0) {
            T newOne = this.newInstance(source);
            this.setFieldDate(newOne, FIELD_END_TIME, startTime.with(LocalTime.MAX));
            result.add(newOne);
            LocalDateTime startTimeNew = startTime.plusDays(1L).with(LocalTime.MIN);
            this.setFieldDate(source, FIELD_START_TIME, startTimeNew);
            this.partition(source, result);
        }
        return result;
    }

    default public List<T> partition(List<T> source) {
        if (CollUtil.isEmpty(source)) {
            return source;
        }
        ArrayList result = Lists.newArrayList();
        source.forEach(t -> this.partition(t, result));
        return result;
    }

    default public Boolean recalculateAgendaDay(T t, LocalDateTime startDateTime) {
        LocalDateTime startTime = this.getFieldDate(t, FIELD_START_TIME);
        if (startDateTime.isAfter(startTime)) {
            LocalDateTime endTime = this.getFieldDate(t, FIELD_END_TIME);
            Duration between = LocalDateTimeUtil.between((LocalDateTime)startTime, (LocalDateTime)endTime);
            LocalDateTime newStartTime = this.alterStartTime(t, startDateTime);
            if (newStartTime == null) {
                return false;
            }
            LocalDateTime newEndTime = newStartTime.plusSeconds(between.toMillis() / 1000L);
            this.setFieldDate(t, FIELD_START_TIME, newStartTime);
            this.setFieldDate(t, FIELD_END_TIME, newEndTime);
        }
        return true;
    }

    default public LocalDateTime alterStartTime(T t, LocalDateTime startDateTime) {
        int dayOfMonth;
        String repeatFrequency = this.getFieldStr(t, FIELD_REPEAT_FREQUENCY);
        Integer frequencyType = this.getFieldInt(t, FIELD_REPEAT_FREQUENCY_TYPE);
        Integer repeatType = this.getFieldInt(t, FIELD_REPEAT_TYPE);
        LocalDateTime startTime = this.getFieldDate(t, FIELD_START_TIME);
        boolean isException = false;
        int min = -1;
        if (StringUtil.isNotEmpty((String)repeatFrequency) && RepeatEnum.CUSTOM.getValue().equals(repeatType)) {
            String[] list;
            for (String s : list = repeatFrequency.split(",")) {
                int temp = NumberUtils.toInt((String)s);
                if (min != -1 && temp >= min) continue;
                min = temp;
            }
        }
        int n = dayOfMonth = min >= 0 ? min : startTime.getDayOfMonth();
        if (RepeatEnum.CUSTOM.getValue().equals(repeatType) && RepeatFrequencyEnum.WEEK.getValue().equals(frequencyType) || RepeatEnum.EVERY_WEEK.getValue().equals(repeatType)) {
            while (startDateTime.isAfter(startTime)) {
                if (min >= 0) {
                    startTime = startTime.with(TemporalAdjusters.next(DayOfWeek.of(min)));
                    continue;
                }
                startTime = startTime.plusWeeks(1L);
            }
        } else if (RepeatEnum.CUSTOM.getValue().equals(repeatType) && RepeatFrequencyEnum.MONTH.getValue().equals(frequencyType) || RepeatEnum.EVERY_MONTH.getValue().equals(repeatType)) {
            while (startDateTime.isAfter(startTime) || isException) {
                isException = false;
                try {
                    startTime = startTime.plusMonths(1L);
                    startTime = startTime.withDayOfMonth(dayOfMonth);
                }
                catch (Exception ignore) {
                    isException = true;
                }
            }
        } else if (RepeatEnum.CUSTOM.getValue().equals(repeatType) && RepeatFrequencyEnum.YEAR.getValue().equals(frequencyType)) {
            while (startDateTime.isAfter(startTime)) {
                startTime = startTime.plusYears(1L);
            }
        } else if (startDateTime != null) {
            startTime = LocalDateTime.of(startDateTime.toLocalDate(), startTime.toLocalTime());
        }
        return isException ? null : startTime;
    }

    default public LocalDateTime plusMonthLoop(LocalDateTime time, long months) {
        boolean isException = false;
        int dayOfMonth = time.getDayOfMonth();
        do {
            isException = false;
            try {
                time = time.plusMonths(months);
                time = time.withDayOfMonth(dayOfMonth);
            }
            catch (Exception ignore) {
                isException = true;
            }
        } while (isException);
        return time;
    }
}

