/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.handler.impl;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.Lists;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.enums.RepeatFrequencyEnum;
import com.hotent.column.handler.RepeatExcision;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CustomExcision<T>
implements RepeatExcision<T> {
    @Override
    public RepeatEnum getAgendaRepeatEnum() {
        return RepeatEnum.CUSTOM;
    }

    @Override
    public List<T> handle(T t, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        List<T> list;
        ArrayList result = Lists.newArrayList();
        if (!this.recalculateAgendaDay(t, startDateTime).booleanValue()) {
            return result;
        }
        if (!this.checkStartTime(t, startDateTime, endDateTime)) {
            return result;
        }
        result.add(this.newInstance(t));
        T current = this.newInstance(t);
        for (int i = 0; i < 1000 && !CollUtil.isEmpty(list = this.next(current, endDateTime)); ++i) {
            result.addAll(list);
            current = this.newInstance(list.get(list.size() - 1));
        }
        return result;
    }

    private List<T> next(T source, LocalDateTime endDateTime) {
        T newOne;
        ArrayList result = Lists.newArrayList();
        Integer frequencyInterval = this.getFieldInt(source, "repeatFrequencyInterval");
        Integer frequencyType = this.getFieldInt(source, "repeatFrequencyType");
        LocalDateTime startTime = this.getFieldDate(source, "startTime");
        LocalDateTime endTime = this.getFieldDate(source, "endTime");
        if (frequencyInterval == null || frequencyInterval <= 0 || frequencyType == null) {
            return result;
        }
        ArrayList tempList = Lists.newArrayList();
        if (RepeatFrequencyEnum.DAY.getValue().equals(frequencyType)) {
            this.setFieldDate(source, "startTime", startTime.plusDays(frequencyInterval.intValue()));
            this.setFieldDate(source, "endTime", endTime.plusDays(frequencyInterval.intValue()));
            newOne = this.newInstance(source);
            tempList.add(newOne);
        } else if (RepeatFrequencyEnum.WEEK.getValue().equals(frequencyType)) {
            newOne = this.newInstance(source);
            this.toWeekHandle(tempList, newOne);
        } else if (RepeatFrequencyEnum.MONTH.getValue().equals(frequencyType)) {
            newOne = this.newInstance(source);
            this.toMonthHandle(tempList, newOne);
        } else if (RepeatFrequencyEnum.YEAR.getValue().equals(frequencyType)) {
            this.setFieldDate(source, "startTime", startTime.plusYears(frequencyInterval.intValue()));
            this.setFieldDate(source, "endTime", endTime.plusYears(frequencyInterval.intValue()));
            newOne = this.newInstance(source);
            tempList.add(newOne);
        }
        for (Object t : tempList) {
            if (!this.checkStartTime(t, this.getFieldDate(source, "startTime"), endDateTime)) continue;
            result.add(t);
        }
        return result;
    }

    private void toMonthHandle(List<T> tempList, T source) {
        LocalDateTime startTime = this.getFieldDate(source, "startTime");
        int startTimeDayOfMonth = startTime.getDayOfMonth();
        String repeatFrequency = this.getFieldStr(source, "repeatFrequency");
        if (StringUtil.isEmpty((String)repeatFrequency)) {
            return;
        }
        Integer frequencyInterval = this.getFieldInt(source, "repeatFrequencyInterval");
        int daysOfMonth = DateUtil.getDaysOfMonth((int)startTime.getYear(), (int)startTime.getMonth().getValue());
        List dayOfMonthList = Arrays.stream(repeatFrequency.split(",")).map(Integer::parseInt).sorted().collect(Collectors.toList());
        List dayOfCurMonthList = dayOfMonthList.stream().filter(day -> day > startTimeDayOfMonth).filter(day -> day <= daysOfMonth).collect(Collectors.toList());
        if (BeanUtils.isEmpty(dayOfCurMonthList)) {
            LocalDateTime startTimeNext = startTime.plusMonths(frequencyInterval.intValue());
            int lenOfMonth = YearMonth.from(startTimeNext).lengthOfMonth();
            if (lenOfMonth < startTimeDayOfMonth) {
                return;
            }
            this.setFieldDate(source, "startTime", this.getFieldDate(source, "startTime").plusMonths(frequencyInterval.intValue()));
            this.setFieldDate(source, "endTime", this.getFieldDate(source, "endTime").plusMonths(frequencyInterval.intValue()));
        } else {
            dayOfMonthList = dayOfCurMonthList;
        }
        for (Integer item : dayOfMonthList) {
            T newOne = this.newInstance(source);
            LocalDateTime startTimeOne = this.getFieldDate(newOne, "startTime");
            LocalDateTime endTimeOne = this.getFieldDate(newOne, "endTime");
            long between = endTimeOne.toLocalDate().toEpochDay() - startTimeOne.toLocalDate().toEpochDay();
            this.setFieldDate(newOne, "startTime", startTimeOne.with(TemporalAdjusters.firstDayOfMonth()).plusDays(item - 1));
            this.setFieldDate(newOne, "endTime", endTimeOne.with(TemporalAdjusters.firstDayOfMonth()).plusDays(between + (long)item.intValue() - 1L));
            tempList.add(newOne);
        }
    }

    private void toWeekHandle(List<T> tempList, T source) {
        int startTimeDayOfWeek = this.getFieldDate(source, "startTime").getDayOfWeek().getValue();
        String repeatFrequency = this.getFieldStr(source, "repeatFrequency");
        if (StringUtil.isEmpty((String)repeatFrequency)) {
            return;
        }
        Integer frequencyInterval = this.getFieldInt(source, "repeatFrequencyInterval");
        List dayOfWeekList = Arrays.stream(repeatFrequency.split(",")).map(Integer::parseInt).sorted().collect(Collectors.toList());
        if (startTimeDayOfWeek >= (Integer)dayOfWeekList.get(dayOfWeekList.size() - 1)) {
            this.setFieldDate(source, "startTime", this.getFieldDate(source, "startTime").plusWeeks(frequencyInterval.intValue()));
            this.setFieldDate(source, "endTime", this.getFieldDate(source, "endTime").plusWeeks(frequencyInterval.intValue()));
        } else {
            dayOfWeekList = dayOfWeekList.stream().filter(day -> day > startTimeDayOfWeek).collect(Collectors.toList());
        }
        for (Integer item : dayOfWeekList) {
            T newOne = this.newInstance(source);
            this.setFieldDate(newOne, "startTime", this.getFieldDate(newOne, "startTime").with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).plusDays(item - 1));
            this.setFieldDate(newOne, "endTime", this.getFieldDate(newOne, "endTime").with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).plusDays(item - 1));
            tempList.add(newOne);
        }
    }
}

