/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.StringUtil;
import com.hotent.column.enums.AgendaRightTypeEnum;
import com.hotent.column.model.PortalAgendaDayAuth;
import com.hotent.column.model.PortalAgendaDayUser;
import com.hotent.column.persistence.dao.PortalAgendaDayAuthDao;
import com.hotent.column.persistence.manager.PortalAgendaDayAuthManager;
import com.hotent.column.persistence.manager.PortalAgendaDayUserManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalAgendaDayAuthManagerImpl
extends BaseManagerImpl<PortalAgendaDayAuthDao, PortalAgendaDayAuth>
implements PortalAgendaDayAuthManager {
    private static final Logger logger = LoggerFactory.getLogger(PortalAgendaDayAuthManagerImpl.class);
    @Resource
    PortalAgendaDayUserManager portalAgendaDayUserManager;

    @Override
    public PortalAgendaDayAuth getByCurrentUserId() {
        List userList;
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userId)) {
            throw new BaseException("\u627e\u4e0d\u5230\u5f53\u524d\u7528\u6237");
        }
        PortalAgendaDayAuth auth = (PortalAgendaDayAuth)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(AutoFillModel::getCreateBy, (Object)userId)));
        if (auth != null && StringUtil.isNotEmpty((String)auth.getId()) && CollUtil.isNotEmpty((Collection)(userList = this.portalAgendaDayUserManager.list((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDayUser::getAuthId, (Object)auth.getId()))))) {
            auth.setAgendaDayUserList(userList);
        }
        return auth;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(PortalAgendaDayAuth portalAgendaDayAuth) {
        this.save((Object)portalAgendaDayAuth);
        if (portalAgendaDayAuth.getRightType().intValue() == AgendaRightTypeEnum.OTHERS.ordinal() && CollUtil.isNotEmpty(portalAgendaDayAuth.getAgendaDayUserList())) {
            this.fillAuthUser(portalAgendaDayAuth);
            this.portalAgendaDayUserManager.saveBatch(portalAgendaDayAuth.getAgendaDayUserList());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOne(PortalAgendaDayAuth portalAgendaDayAuth) {
        this.update((Model)portalAgendaDayAuth);
        this.portalAgendaDayUserManager.remove((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDayUser::getAuthId, (Object)portalAgendaDayAuth.getId()));
        if (portalAgendaDayAuth.getRightType().intValue() == AgendaRightTypeEnum.OTHERS.ordinal() && CollUtil.isNotEmpty(portalAgendaDayAuth.getAgendaDayUserList())) {
            this.fillAuthUser(portalAgendaDayAuth);
            this.portalAgendaDayUserManager.saveBatch(portalAgendaDayAuth.getAgendaDayUserList());
        }
    }

    @Override
    public List<String> getShareEveryOne() {
        List list = this.list((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDayAuth::getRightType, (Object)0));
        if (CollUtil.isEmpty((Collection)list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(AutoFillModel::getCreateBy).filter(StringUtil::isNotEmpty).distinct().collect(Collectors.toList());
    }

    private void fillAuthUser(PortalAgendaDayAuth portalAgendaDayAuth) {
        for (PortalAgendaDayUser item : portalAgendaDayAuth.getAgendaDayUserList()) {
            item.setAuthId(portalAgendaDayAuth.getId());
            if (StringUtil.isNotEmpty((String)portalAgendaDayAuth.getCreateBy())) {
                item.setAuthUserId(portalAgendaDayAuth.getCreateBy());
                continue;
            }
            item.setAuthUserId(ContextUtil.getCurrentUserId());
        }
    }
}

