/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.handler.RepeatContext;
import com.hotent.column.handler.RepeatExcision;
import com.hotent.column.model.PortalAgendaDay;
import com.hotent.column.model.PortalAgendaDayUser;
import com.hotent.column.model.PortalMeetingApply;
import com.hotent.column.persistence.dao.PortalAgendaDayDao;
import com.hotent.column.persistence.manager.PortalAgendaDayAuthManager;
import com.hotent.column.persistence.manager.PortalAgendaDayManager;
import com.hotent.column.persistence.manager.PortalAgendaDayUserManager;
import com.hotent.column.persistence.manager.PortalMeetingApplyManager;
import com.hotent.column.persistence.manager.PortalMeetingDelManager;
import com.hotent.column.vo.ReminderPopupVO;
import com.hotent.column.vo.ReminderVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PortalAgendaDayManagerImpl
extends BaseManagerImpl<PortalAgendaDayDao, PortalAgendaDay>
implements PortalAgendaDayManager {
    public static final Logger logger = LoggerFactory.getLogger(PortalAgendaDayManagerImpl.class);
    @Resource
    private PortalFeignService portalFeignService;
    @Resource
    private BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    private PortalAgendaDayUserManager portalAgendaDayUserManager;
    @Resource
    private PortalAgendaDayAuthManager portalAgendaDayAuthManager;
    @Resource
    private PortalMeetingDelManager portalMeetingDelManager;

    @Override
    public void createOrUpdate(PortalAgendaDay agendaDay) {
        if (StringUtil.isNotEmpty((String)agendaDay.getId())) {
            if (StringUtil.isEmpty((String)agendaDay.getTenantId())) {
                agendaDay.setTenantId(ContextUtil.getCurrentUser().getTenantId());
            }
            this.updateById((Object)agendaDay);
        } else {
            IUser user = ContextUtil.getCurrentUser();
            agendaDay.setCreateBy(user.getUserId());
            agendaDay.setCreator(user.getFullname());
            this.create((Model)agendaDay);
        }
    }

    @Override
    public List<PortalAgendaDay> getByUserId(String userId) throws ParseException {
        List<PortalAgendaDayUser> dayUserList = this.portalAgendaDayUserManager.getAuthUser();
        QueryFilter queryFilter = this.buildQueryFilter(userId, dayUserList);
        List result = super.query(queryFilter).getRows();
        if (CollUtil.isNotEmpty(dayUserList)) {
            result.forEach(row -> this.setAuthType(userId, dayUserList, (PortalAgendaDay)((Object)row)));
        }
        result.addAll(this.getTodo(Optional.empty(), Optional.empty()));
        return result;
    }

    private QueryFilter buildQueryFilter(String userId, List<PortalAgendaDayUser> dayUserList) {
        List<String> authUserIdList = new ArrayList<String>();
        if (CollUtil.isNotEmpty(dayUserList)) {
            authUserIdList = dayUserList.stream().map(PortalAgendaDayUser::getAuthUserId).filter(StringUtil::isNotEmpty).distinct().collect(Collectors.toList());
        }
        if (!authUserIdList.contains(userId)) {
            authUserIdList.add(userId);
        }
        authUserIdList.addAll(this.portalAgendaDayAuthManager.getShareEveryOne());
        authUserIdList = authUserIdList.stream().distinct().collect(Collectors.toList());
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)).withQuery(new QueryField("CREATE_BY_", authUserIdList, QueryOP.IN, FieldRelation.OR)).withQuery(new QueryField("SHARE_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR)).withQuery(new QueryField("SHARE_ID_", (Object)("," + userId), QueryOP.LEFT_LIKE, FieldRelation.OR)).withQuery(new QueryField("SHARE_ID_", (Object)(userId + ","), QueryOP.RIGHT_LIKE, FieldRelation.OR)).withQuery(new QueryField("SHARE_ID_", (Object)("," + userId + ","), QueryOP.LIKE, FieldRelation.OR)).withQuery(new QueryField("PARTICIPANTS_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.OR)).withQuery(new QueryField("PARTICIPANTS_ID_", (Object)("," + userId), QueryOP.LEFT_LIKE, FieldRelation.OR)).withQuery(new QueryField("PARTICIPANTS_ID_", (Object)(userId + ","), QueryOP.RIGHT_LIKE, FieldRelation.OR)).withQuery(new QueryField("PARTICIPANTS_ID_", (Object)("," + userId + ","), QueryOP.LIKE, FieldRelation.OR));
        List<String> excludeIdList = this.portalMeetingDelManager.getExcludeAgendaDay();
        if (CollUtil.isNotEmpty(excludeIdList)) {
            queryFilter.addFilter("ID_", excludeIdList, QueryOP.NOT_IN, FieldRelation.AND, "base");
        }
        return queryFilter;
    }

    private List<PortalAgendaDay> getTodo(Optional<String> startDate, Optional<String> endDate) throws ParseException {
        ArrayList<PortalAgendaDay> result = new ArrayList<PortalAgendaDay>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false)));
        startDate.ifPresent(s -> queryFilter.addFilter("inst.create_time_", s, QueryOP.GREAT_EQUAL, FieldRelation.OR, "myQuery"));
        endDate.ifPresent(s -> queryFilter.addFilter("inst.create_time_", s, QueryOP.LESS_EQUAL, FieldRelation.AND, "myQuery"));
        queryFilter.getSorter().add(new FieldSort("PRIORITY_", Direction.ASC));
        queryFilter.getSorter().add(new FieldSort("inst.create_time_", Direction.DESC));
        try {
            ObjectNode todoList = this.bpmRuntimeFeignService.getTodoList((ObjectNode)JsonUtil.toJsonNode((Object)queryFilter));
            if (todoList != null && todoList.has("rows")) {
                ArrayNode rowsNode = (ArrayNode)todoList.get("rows");
                for (JsonNode row : rowsNode) {
                    int isAgendaDayDele = JsonUtil.getInt((JsonNode)((ObjectNode)row), (String)"isAgendaDayDele", (int)0);
                    if (isAgendaDayDele == 1) continue;
                    PortalAgendaDay portalAgendaDay = new PortalAgendaDay();
                    portalAgendaDay.setMeetingId("1");
                    portalAgendaDay.setId(JsonUtil.getString((JsonNode)row, (String)"id", (String)""));
                    portalAgendaDay.setContent(JsonUtil.getString((JsonNode)row, (String)"subject", (String)""));
                    portalAgendaDay.setInstId(JsonUtil.getString((JsonNode)row, (String)"procInstId", (String)""));
                    String createDate = JsonUtil.getString((JsonNode)row, (String)"createDate", (String)"");
                    if (StringUtil.isNotEmpty((String)createDate)) {
                        LocalDateTime createDateTime = TimeUtil.convertString((String)createDate);
                        portalAgendaDay.setStartTime(createDateTime);
                        portalAgendaDay.setEndTime(createDateTime);
                    }
                    result.add(portalAgendaDay);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e2a\u4eba\u5f85\u529e\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<PortalAgendaDay> getByPeriod(String userId, Optional<String> startDate, Optional<String> endDate, Boolean containsTodo) throws ParseException {
        LocalDateTime start;
        List<PortalAgendaDayUser> dayUserList = this.portalAgendaDayUserManager.getAuthUser();
        QueryFilter filter = this.buildQueryFilter(userId, dayUserList);
        if (startDate.isPresent() && StringUtil.isNotEmpty(startDate) && endDate.isPresent() && StringUtil.isNotEmpty(endDate)) {
            start = LocalDateTimeUtil.parse((CharSequence)startDate.get(), (String)"yyyy-MM-dd HH:mm:ss");
            LocalDateTime end = LocalDateTimeUtil.parse((CharSequence)endDate.get(), (String)"yyyy-MM-dd HH:mm:ss");
            filter.addFilter("start_Time_", (Object)start, QueryOP.GREAT_EQUAL, FieldRelation.AND, "myQuery");
            filter.addFilter("start_Time_", (Object)end, QueryOP.LESS_EQUAL, FieldRelation.AND, "myQuery");
            filter.addFilter("end_Time_", (Object)start, QueryOP.GREAT_EQUAL, FieldRelation.OR, "myQuery");
            filter.addFilter("end_Time_", (Object)end, QueryOP.LESS_EQUAL, FieldRelation.AND, "myQuery");
            filter.addFilter("start_Time_", (Object)start, QueryOP.LESS_EQUAL, FieldRelation.OR, "myQuery");
            filter.addFilter("end_Time_", (Object)end, QueryOP.GREAT_EQUAL, FieldRelation.AND, "myQuery");
        } else if (startDate.isPresent() && StringUtil.isNotEmpty(startDate)) {
            start = LocalDateTimeUtil.parse((CharSequence)startDate.get(), (String)"yyyy-MM-dd HH:mm:ss");
            filter.addFilter("end_Time_", (Object)start, QueryOP.GREAT_EQUAL, FieldRelation.OR, "myQuery");
        } else if (endDate.isPresent() && StringUtil.isNotEmpty(endDate)) {
            LocalDateTime end = LocalDateTimeUtil.parse((CharSequence)endDate.get(), (String)"yyyy-MM-dd HH:mm:ss");
            filter.addFilter("start_Time_", (Object)end, QueryOP.LESS_EQUAL, FieldRelation.AND, "myQuery");
        }
        List<Integer> RepeatEnums = Arrays.asList(RepeatEnum.EVERY_DAY.getValue(), RepeatEnum.EVERY_WORK_DAY.getValue(), RepeatEnum.EVERY_MONTH.getValue(), RepeatEnum.EVERY_WEEK.getValue(), RepeatEnum.CUSTOM.getValue());
        filter.addFilter("REPEAT_TYPE_", RepeatEnums, QueryOP.IN, FieldRelation.OR, "myQuery");
        List rows = super.query(filter).getRows();
        rows.forEach(row -> this.setAuthType(userId, dayUserList, (PortalAgendaDay)((Object)row)));
        List<PortalAgendaDay> result = RepeatContext.assemble(rows, startDate, endDate);
        result = this.fillMeetingApply(result);
        if (containsTodo.booleanValue()) {
            result.addAll(this.getTodo(startDate, endDate));
        }
        return result;
    }

    private void setAuthType(String userId, List<PortalAgendaDayUser> dayUserList, PortalAgendaDay row) {
        String createBy = row.getCreateBy();
        if (StringUtil.isEmpty((String)createBy)) {
            return;
        }
        row.setAuthType(1);
        if (createBy.equals(userId)) {
            return;
        }
        if (CollUtil.isEmpty(dayUserList)) {
            row.setAuthType(0);
            return;
        }
        PortalAgendaDayUser dayUser = dayUserList.stream().filter(authUser -> createBy.equals(authUser.getAuthUserId())).findFirst().orElse(null);
        if (dayUser != null) {
            row.setAuthType(dayUser.getAuthType());
        } else {
            String[] shareIds;
            if (StringUtil.isNotEmpty((String)row.getShareId()) && Arrays.asList(shareIds = row.getShareId().split(",")).contains(userId)) {
                row.setAuthType(0);
            }
            if (StringUtil.isNotEmpty((String)row.getParticipantsId()) && Arrays.asList(shareIds = row.getParticipantsId().split(",")).contains(userId)) {
                row.setAuthType(0);
            }
        }
    }

    private List<PortalAgendaDay> fillMeetingApply(List<PortalAgendaDay> rows) {
        if (CollUtil.isEmpty(rows)) {
            return rows;
        }
        List<String> meetingIdList = rows.stream().filter(r -> StringUtil.isNotEmpty((String)r.getMeetingId()) && r.getMeetingId().length() > 2).map(PortalAgendaDay::getMeetingId).collect(Collectors.toList());
        if (CollUtil.isEmpty(meetingIdList)) {
            return rows;
        }
        PortalMeetingApplyManager portalMeetingApplyManager = (PortalMeetingApplyManager)AppUtil.getBean(PortalMeetingApplyManager.class);
        List<PortalMeetingApply> meetingApplyList = portalMeetingApplyManager.getByIds(meetingIdList);
        if (CollUtil.isEmpty(meetingApplyList)) {
            return rows;
        }
        ArrayList<PortalAgendaDay> meetingList = new ArrayList<PortalAgendaDay>();
        ArrayList<PortalAgendaDay> dayList = new ArrayList<PortalAgendaDay>();
        for (int i = 0; i < rows.size(); ++i) {
            PortalAgendaDay r2 = rows.get(i);
            if (StringUtil.isNotEmpty((String)r2.getMeetingId()) && meetingIdList.contains(r2.getMeetingId())) {
                Optional<PortalMeetingApply> meetingOptional = meetingApplyList.stream().filter(m -> m.getId().equals(r2.getMeetingId())).findFirst();
                meetingOptional.ifPresent(m -> {
                    PortalMeetingApply meetingApply = new PortalMeetingApply();
                    BeanUtil.copyProperties((Object)m, (Object)((Object)meetingApply), (String[])new String[0]);
                    meetingApply.setStartTime(r2.getStartTime());
                    meetingApply.setEndTime(r2.getEndTime());
                    meetingApply = portalMeetingApplyManager.addRecordStatusOne(meetingApply);
                    r2.setMeetingApply(meetingApply);
                });
                meetingList.add(r2);
                continue;
            }
            dayList.add(r2);
        }
        if (CollUtil.isNotEmpty(dayList)) {
            meetingList.addAll(dayList);
        }
        return meetingList;
    }

    @Override
    public CommonResult<String> deleteById(String id) {
        PortalAgendaDay portalAgendaDay = (PortalAgendaDay)((Object)((PortalAgendaDayDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (BeanUtils.isEmpty((Object)((Object)portalAgendaDay))) {
            return CommonResult.error((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!");
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        if (currentUser.getUserId().equals(portalAgendaDay.getCreateBy())) {
            ((PortalAgendaDayDao)this.baseMapper).deleteById((Serializable)((Object)id));
            return CommonResult.success((Object)"\u5220\u9664\u6210\u529f!");
        }
        String[] shareIds = Optional.ofNullable(portalAgendaDay.getShareId()).map(ss -> ss.split(",")).orElse(new String[0]);
        String[] shareNames = Optional.ofNullable(portalAgendaDay.getShareName()).map(ss -> ss.split(",")).orElse(new String[0]);
        portalAgendaDay.setShareId(Arrays.stream(shareIds).filter(ss -> !currentUser.getUserId().equals(ss)).collect(Collectors.joining(",")));
        portalAgendaDay.setShareName(Arrays.stream(shareNames).filter(ss -> !currentUser.getAccount().equals(ss)).collect(Collectors.joining(",")));
        ((PortalAgendaDayDao)this.baseMapper).updateById((Object)portalAgendaDay);
        return CommonResult.success((Object)"\u5220\u9664\u6210\u529f!");
    }

    @Override
    public void deleteTodoById(String id) throws Exception {
        this.bpmRuntimeFeignService.deleteAgendaDay(id);
    }

    @Override
    public void remind() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime endTime = now.plusHours(1L);
        List<PortalAgendaDay> data = ((PortalAgendaDayDao)this.baseMapper).remindData(now, endTime);
        for (PortalAgendaDay portalAgendaDay : data) {
            RepeatExcision repeatExcision = RepeatContext.getAgendaRepeatExcision(portalAgendaDay.getRepeatType());
            List<PortalAgendaDay> list = repeatExcision.handle(portalAgendaDay, now, endTime);
            for (PortalAgendaDay agendaDay : list) {
                CommonResult result;
                Notice notice;
                if (StringUtil.isEmpty((String)agendaDay.getReminderType()) || agendaDay.getReminderMinutes() == null) continue;
                Integer reminderMinutes = agendaDay.getReminderMinutes();
                LocalDateTime reminderTime = agendaDay.getStartTime().minusMinutes(reminderMinutes.intValue());
                if (BeanUtils.isNotEmpty((Object)agendaDay.getLastReminderTime()) && reminderTime.compareTo(agendaDay.getLastReminderTime()) == 0 || !reminderTime.isBefore(now) || !agendaDay.getStartTime().isAfter(now) || !ArrayUtil.isNotEmpty((Object[])(notice = this.buildNotice(agendaDay)).getMessageTypes()) || !BeanUtils.isNotEmpty((Object)notice.getReceivers()) || !(result = this.portalFeignService.sendNoticeToQueue(notice)).getState().booleanValue()) continue;
                LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(PortalAgendaDay::getId, (Object)agendaDay.getId())).set(PortalAgendaDay::getLastReminderTime, (Object)reminderTime);
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public ReminderPopupVO getMyRemind() throws ParseException {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime endTime = now.plusHours(1L);
        String startDate = TimeUtil.getDateTimeString((LocalDateTime)now);
        String endDate = TimeUtil.getDateTimeString((LocalDateTime)endTime);
        List<PortalAgendaDay> myDayList = this.getByPeriod(ContextUtil.getCurrentUserId(), Optional.of(startDate), Optional.of(endDate), false);
        return this.filterRemindList(myDayList, now);
    }

    @Override
    public void updateReminderMinutes(List<ReminderVO> reminderVoList) {
        if (CollUtil.isEmpty(reminderVoList)) {
            return;
        }
        ArrayList<PortalAgendaDay> list = new ArrayList<PortalAgendaDay>();
        reminderVoList.forEach(r -> {
            if (StringUtil.isEmpty((String)r.getAgendaDayId()) || r.getReminderMinutes() == null || r.getReminderMinutes() < 0) {
                return;
            }
            PortalAgendaDay day = new PortalAgendaDay();
            day.setId(r.getAgendaDayId());
            day.setReminderMinutes(r.getReminderMinutes());
            list.add(day);
        });
        if (CollUtil.isEmpty(list)) {
            return;
        }
        ((PortalAgendaDayDao)this.baseMapper).updateReminderMinutesBatch(list);
    }

    @Override
    public void deleteByMeetingId(String meetingId) {
        if (StringUtil.isEmpty((String)meetingId) || meetingId.equals("0") || meetingId.equals("1")) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDay::getMeetingId, (Object)meetingId));
    }

    private ReminderPopupVO filterRemindList(List<PortalAgendaDay> dayList, LocalDateTime now) {
        ArrayList<PortalAgendaDay> remindList = new ArrayList<PortalAgendaDay>();
        for (PortalAgendaDay portalAgendaDay : dayList) {
            LocalDateTime reminderTime;
            Integer reminderMinutes;
            Set reminderTypeValues;
            boolean isSystemNotice = false;
            if (StringUtil.isNotEmpty((String)portalAgendaDay.getReminderType()) && portalAgendaDay.getReminderType().contains(",") && (reminderTypeValues = Arrays.stream(portalAgendaDay.getReminderType().split(",")).collect(Collectors.toSet())).contains("popup")) {
                isSystemNotice = true;
            }
            if (!isSystemNotice || BeanUtils.isEmpty((Object)(reminderMinutes = portalAgendaDay.getReminderMinutes())) || !(reminderTime = portalAgendaDay.getStartTime().minusMinutes(reminderMinutes.intValue())).isBefore(now) || !portalAgendaDay.getStartTime().isAfter(now)) continue;
            remindList.add(portalAgendaDay);
        }
        PortalAgendaDay lastRecord = remindList.stream().max(Comparator.comparing(PortalAgendaDay::getStartTime)).orElse(null);
        ReminderPopupVO reminderPopupVO = new ReminderPopupVO();
        reminderPopupVO.setAgendaDay(lastRecord);
        if (lastRecord != null && StringUtil.isNotEmpty((String)lastRecord.getMeetingId()) && lastRecord.getMeetingId().length() > 1) {
            PortalMeetingApplyManager portalMeetingApplyManager = (PortalMeetingApplyManager)AppUtil.getBean(PortalMeetingApplyManager.class);
            PortalMeetingApply meetingApply = (PortalMeetingApply)portalMeetingApplyManager.get((Serializable)((Object)lastRecord.getMeetingId()));
            reminderPopupVO.setMeetingApply(meetingApply);
        }
        return reminderPopupVO;
    }

    private Notice buildNotice(PortalAgendaDay agendaDay) {
        Notice notice = new Notice();
        Set reminderTypeValues = Arrays.stream(agendaDay.getReminderType().split(",")).collect(Collectors.toSet());
        NoticeMessageType[] noticeMessageTypes = (NoticeMessageType[])Arrays.stream(NoticeMessageType.values()).filter(r -> reminderTypeValues.contains(r.key())).toArray(NoticeMessageType[]::new);
        if (BeanUtils.isNotEmpty((Object)noticeMessageTypes)) {
            notice.setMessageTypes(noticeMessageTypes);
        }
        String subject = StringUtil.isEmpty((String)agendaDay.getMeetingId()) ? "\u65b0\u589e\u65e5\u7a0b" : "\u65b0\u589e\u4f1a\u8bae";
        notice.setSubject(subject);
        notice.setContent(agendaDay.getContent());
        List<JmsActor> actors = this.buildJmsActor(agendaDay);
        String[] receivers = (String[])actors.stream().map(JmsActor::getAccount).toArray(String[]::new);
        if (BeanUtils.isNotEmpty(actors)) {
            notice.setReceiver(actors);
            notice.setReceivers(receivers);
        }
        return notice;
    }

    private List<JmsActor> buildJmsActor(PortalAgendaDay agendaDay) {
        ArrayNode users;
        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        HashSet<String> userIds = new HashSet<String>();
        if (StringUtil.isNotEmpty((String)agendaDay.getCreateBy())) {
            userIds.add(agendaDay.getCreateBy());
        }
        if (StringUtil.isNotEmpty((String)agendaDay.getShareId())) {
            Arrays.stream(agendaDay.getShareId().split(",")).forEach(userIds::add);
        }
        if (StringUtil.isNotEmpty((String)agendaDay.getParticipantsId())) {
            Arrays.stream(agendaDay.getParticipantsId().split(",")).forEach(userIds::add);
        }
        if (BeanUtils.isNotEmpty((Object)(users = ucFeignService.getUserByIdsOrAccounts(StringUtil.join(userIds))))) {
            for (JsonNode userNode : users) {
                JmsActor jmsActor = new JmsActor();
                jmsActor.setId(JsonUtil.getString((JsonNode)userNode, (String)"id"));
                jmsActor.setAccount(JsonUtil.getString((JsonNode)userNode, (String)"account"));
                jmsActor.setName(JsonUtil.getString((JsonNode)userNode, (String)"fullname"));
                jmsActor.setEmail(JsonUtil.getString((JsonNode)userNode, (String)"email"));
                jmsActor.setMobile(JsonUtil.getString((JsonNode)userNode, (String)"mobile"));
                jmsActor.setWeixin(JsonUtil.getString((JsonNode)userNode, (String)"weixin"));
                jmsActor.setClientId(JsonUtil.getString((JsonNode)userNode, (String)"clientId"));
                jmsActor.setClientToken(JsonUtil.getString((JsonNode)userNode, (String)"clientToken"));
                actors.add(jmsActor);
            }
        }
        return actors;
    }
}

