/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.constant.SysIndexColumnEnum;
import com.hotent.column.model.PortalNewsNotice;
import com.hotent.column.model.PortalNewsTree;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.model.SysIndexNewsColumn;
import com.hotent.column.persistence.dao.PortalNewsTreeDao;
import com.hotent.column.persistence.manager.PortalNewsNoticeManager;
import com.hotent.column.persistence.manager.PortalNewsTreeManager;
import com.hotent.column.persistence.manager.SysIndexColumnManager;
import com.hotent.column.persistence.manager.SysIndexNewsColumnManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class PortalNewsTreeManagerImpl
extends BaseManagerImpl<PortalNewsTreeDao, PortalNewsTree>
implements PortalNewsTreeManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SysIndexColumnManager sysIndexColumnManager;
    @Resource
    SysIndexNewsColumnManager sysIndexNewsColumnManager;
    @Resource
    PortalNewsNoticeManager portalNewsNoticeManager;
    @Resource
    PortalNewsTreeDao portalNewsTreeDao;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SaaSConfig saaSConfig;
    private static final String EXPORT_ONLY_MENU = "1";
    private static final String EXPORT_ALL = "2";

    @Override
    public CommonResult<String> issue(String id) throws Exception {
        String templateHtml;
        SysIndexColumn sysIndexColumn2;
        SysIndexColumn sysIndexColumn = new SysIndexColumn();
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        String columnId = portalNewsTree.getColumnId();
        if (StringUtil.isNotEmpty((String)columnId) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn2 = (SysIndexColumn)this.sysIndexColumnManager.get((Serializable)((Object)columnId)))))) {
            return new CommonResult(false, "\u6b64\u5206\u7c7b\u5df2\u7ecf\u88ab\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee,\u65e0\u6cd5\u518d\u6b21\u53d1\u5e03!");
        }
        String path = portalNewsTree.getPath();
        sysIndexColumn.setAlias(id);
        sysIndexColumn.setCatalog("31081");
        sysIndexColumn.setIsPublic((short)2);
        sysIndexColumn.setNeedPage((short)0);
        sysIndexColumn.setCatalogName("\u9ed8\u8ba4\u5206\u7c7b");
        sysIndexColumn.setColHeight(BeanUtils.isNotEmpty((Object)portalNewsTree.getColHeight()) && portalNewsTree.getColHeight().longValue() > 0L ? portalNewsTree.getColHeight().longValue() : Long.valueOf(432L).longValue());
        String suid = UniqueIdUtil.getSuid();
        sysIndexColumn.setId(suid);
        sysIndexColumn.setName(portalNewsTree.getName());
        if (path.startsWith("100.")) {
            String template = "<home-news-list classifyId='" + id + "'/>";
            templateHtml = Base64.getBase64((String)template);
            sysIndexColumn.setTemplateHtml(templateHtml);
            sysIndexColumn.setColUrl("/newsList/" + id);
            sysIndexColumn.setDataParam("{\"colType\":\"news\",\"announcementOrPictures\":[\"" + id + "\"],\"colHeightType\":\"default\"}");
            sysIndexColumn.setColType(SysIndexColumnEnum.ColnumType.HT_NEWS.getValue());
        } else {
            String template = "<homeCarousel height='" + portalNewsTree.getColHeight() + "' classifyId='" + id + "' :interval='" + portalNewsTree.getIntervalTime() + "'/>";
            templateHtml = Base64.getBase64((String)template);
            sysIndexColumn.setTemplateHtml(templateHtml);
            sysIndexColumn.setDataParam("{\"colType\":\"swipeSlide\",\"announcementOrPictures\":[\"" + id + "\"],\"colHeightType\":\"default\"}");
            sysIndexColumn.setColType(SysIndexColumnEnum.ColnumType.HT_SWIPE_SLIDE.getValue());
        }
        this.sysIndexColumnManager.create((Model)sysIndexColumn);
        portalNewsTree.setColumnId(suid);
        this.update((Model)portalNewsTree);
        String indexColumnId = sysIndexColumn.getId();
        String objType = "indexColumn";
        String ownerNameJson = "[{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
        this.sysAuthUserManager.saveRights(indexColumnId, objType, ownerNameJson);
        IUser currentUser = ContextUtil.getCurrentUser();
        this.sysAuthUserManager.delUserMenuCache(currentUser.getUserId());
        return new CommonResult();
    }

    @Override
    public void updateEntity(PortalNewsTree t) throws Exception {
        PortalNewsTree oldData;
        SysIndexColumn sysIndexColumn;
        if (StringUtil.isNotEmpty((String)t.getColumnId()) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn = (SysIndexColumn)this.sysIndexColumnManager.get((Serializable)((Object)t.getColumnId())))))) {
            String path = t.getPath();
            String id = t.getId();
            sysIndexColumn.setColHeight(t.getColHeight().longValue());
            sysIndexColumn.setName(t.getName());
            if (path.startsWith("100.")) {
                String template = "<home-news-list classifyId='" + id + "'/>";
                String templateHtml = Base64.getBase64((String)template);
                sysIndexColumn.setTemplateHtml(templateHtml);
            } else {
                String template = "<homeCarousel height='" + t.getColHeight() + "' classifyId='" + id + "' :interval='" + t.getIntervalTime() + "'/>";
                String templateHtml = Base64.getBase64((String)template);
                sysIndexColumn.setTemplateHtml(templateHtml);
            }
            this.sysIndexColumnManager.update((Model)sysIndexColumn);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)(oldData = (PortalNewsTree)super.get((Serializable)((Object)t.getId()))))) && !oldData.getName().equals(t.getName())) {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            wrapper.eq(PortalNewsNotice::getClassifyId, (Object)t.getId());
            wrapper.set(PortalNewsNotice::getClassifyName, (Object)t.getName());
            this.portalNewsNoticeManager.update(null, (Wrapper)wrapper);
        }
        super.update((Model)t);
    }

    @Override
    public CommonResult<String> mobileIssue(String id) {
        SysIndexNewsColumn sysIndexColumn2;
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        portalNewsTree.setMobileIssue(new BigDecimal(1));
        this.update((Model)portalNewsTree);
        String columnId = portalNewsTree.getColumnId();
        if (StringUtil.isNotEmpty((String)columnId) && BeanUtils.isNotEmpty((Object)((Object)(sysIndexColumn2 = (SysIndexNewsColumn)((Object)this.sysIndexNewsColumnManager.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysIndexNewsColumn::getPortalNewsId, (Object)id))))))) {
            return new CommonResult(false, "\u6b64\u5206\u7c7b\u5df2\u7ecf\u88ab\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee,\u65e0\u6cd5\u518d\u6b21\u53d1\u5e03!");
        }
        SysIndexNewsColumn sysIndexColumn = new SysIndexNewsColumn();
        sysIndexColumn.setName(portalNewsTree.getName());
        String path = portalNewsTree.getPath();
        if (path.startsWith("100.")) {
            sysIndexColumn.setType("0");
        } else {
            sysIndexColumn.setType(EXPORT_ONLY_MENU);
        }
        sysIndexColumn.setPortalNewsId(id);
        this.sysIndexNewsColumnManager.create((Model)sysIndexColumn);
        return new CommonResult("\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public CommonResult<String> mobileRemove(String id) {
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.get((Serializable)((Object)id));
        portalNewsTree.setMobileIssue(new BigDecimal(0));
        this.update((Model)portalNewsTree);
        this.sysIndexNewsColumnManager.remove((Wrapper)Wrappers.lambdaQuery().eq(SysIndexNewsColumn::getPortalNewsId, (Object)id));
        return new CommonResult("\u53d6\u6d88\u516c\u544a\u53d1\u5e03\u6210\u529f");
    }

    @Transactional
    public boolean removeById(Serializable id) {
        PortalNewsTree tree = (PortalNewsTree)((Object)this.getById(id));
        if (tree.getParentId().equals("0")) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u5220\u9664\u6b64\u5206\u7c7b");
        }
        if (EXPORT_ALL.equals(tree.getRank().toString())) {
            this.portalNewsNoticeManager.deleteNewsByParentId((String)((Object)id));
            this.sysIndexColumnManager.deleteByNewsParentId((String)((Object)id));
            this.portalNewsTreeDao.deleteByParentId((String)((Object)id));
        } else if ("3".equals(tree.getRank().toString())) {
            if (StringUtil.isNotEmpty((String)tree.getColumnId())) {
                this.sysIndexColumnManager.remove((Serializable)((Object)tree.getColumnId()));
            }
            this.portalNewsNoticeManager.deleteByClassifyId((String)((Object)id));
        }
        return super.removeById(id);
    }

    @Override
    public CommonResult<String> importCheck(String uzPath, String classifyId) throws Exception {
        String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "portalTree.json"));
        Map map = (Map)JsonUtil.toBean((String)fileStr, HashMap.class);
        PortalNewsTree targetTree = (PortalNewsTree)((Object)this.getById((Serializable)((Object)classifyId)));
        ArrayList treesObj = (ArrayList)map.get("trees");
        String prefix = targetTree.getPath().substring(0, targetTree.getPath().indexOf("."));
        ArrayList treeNames = Lists.newArrayList();
        for (Object o : treesObj) {
            PortalNewsTree portalNewsTree = (PortalNewsTree)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsTree.class));
            if (!portalNewsTree.getPath().startsWith(prefix)) {
                throw new BaseException("\u6240\u5c5e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u5bfc\u5165");
            }
            treeNames.add(portalNewsTree.getName());
        }
        if (BeanUtils.isNotEmpty((Object)treeNames)) {
            LambdaQueryWrapper treeQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalNewsTree::getParentId, (Object)classifyId)).in(PortalNewsTree::getName, (Collection)treeNames);
            List portalNewsList = ((PortalNewsTreeDao)this.getBaseMapper()).selectList((Wrapper)treeQuery);
            if (BeanUtils.isNotEmpty((Object)portalNewsList)) {
                return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u6709\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8fdb\u884c\u8986\u76d6\uff1f");
            }
        }
        this.importFile(uzPath, classifyId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importFile(String uzPath, String classifyId) throws Exception {
        try {
            String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "portalTree.json"));
            Map map = (Map)JsonUtil.toBean((String)fileStr, HashMap.class);
            PortalNewsTree targetTree = (PortalNewsTree)((Object)this.getById((Serializable)((Object)classifyId)));
            ArrayList treesObj = (ArrayList)map.get("trees");
            ArrayList noticeObj = (ArrayList)map.get("notices");
            ArrayList<PortalNewsTree> treesRank2 = new ArrayList<PortalNewsTree>();
            ArrayList<PortalNewsTree> treesRank3 = new ArrayList<PortalNewsTree>();
            ArrayList<PortalNewsNotice> notices = new ArrayList<PortalNewsNotice>();
            for (Object o : treesObj) {
                PortalNewsTree portalNewsTree = (PortalNewsTree)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsTree.class));
                if (2 == portalNewsTree.getRank().intValue()) {
                    treesRank2.add(portalNewsTree);
                    continue;
                }
                if (3 != portalNewsTree.getRank().intValue()) continue;
                treesRank3.add(portalNewsTree);
            }
            if (1 == targetTree.getRank().intValue() && treesRank2.isEmpty()) {
                throw new BaseException("\u4e0d\u5141\u8bb8\u5728\u9876\u7ea7\u5206\u7c7b\u4e2d\u76f4\u63a5\u5bfc\u5165\u4e09\u7ea7\u5206\u7c7b,\u8bf7\u5148\u6dfb\u52a0\u4e8c\u7ea7\u5206\u7c7b");
            }
            if (2 == targetTree.getRank().intValue() && !treesRank2.isEmpty()) {
                throw new BaseException("\u4e0d\u5141\u8bb8\u5bfc\u5165\u540c\u7ea7\u5206\u7c7b\uff0c\u8bf7\u9009\u62e9\u9876\u7ea7\u5206\u7c7b\u5bfc\u5165");
            }
            if (BeanUtils.isEmpty((Object)treesObj)) {
                throw new BaseException("\u5206\u7c7b\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6587\u4ef6");
            }
            if (BeanUtils.isNotEmpty((Object)noticeObj)) {
                for (Object o : noticeObj) {
                    notices.add((PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsNotice.class)));
                }
            }
            if (1 == targetTree.getRank().intValue()) {
                Map<String, String> changeMap2 = this.handleTreeRank2(treesRank2, targetTree.getId());
                Map<String, String> changeMap3 = this.handleTreeRank3(treesRank3, targetTree.getId(), changeMap2);
                this.handleNotice(notices, changeMap3);
            } else if (2 == targetTree.getRank().intValue()) {
                Map<String, String> changeMap3 = this.handleTreeRank3(treesRank3, targetTree.getId(), new HashMap<String, String>());
                this.handleNotice(notices, changeMap3);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importTree(MultipartHttpServletRequest request, String classifyId) {
        MultipartFile file = request.getFile("file");
        String operate = request.getParameter("operate");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            if (StringUtils.equals((CharSequence)operate, (CharSequence)"check")) {
                CommonResult<String> commonResult = this.importCheck(uzPath, classifyId);
                return commonResult;
            }
            this.importFile(uzPath, classifyId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @Override
    public void exportTree(HttpServletRequest request, HttpServletResponse response, PortalNewsTree portalNewsTree, String exportType) throws Exception {
        BigDecimal rank = portalNewsTree.getRank();
        if (BeanUtils.isNotEmpty((Object)rank)) {
            LambdaQueryWrapper wrapper;
            String json = "";
            HashMap<String, List> exportMap = new HashMap<String, List>(4);
            if (rank.intValue() == 1) {
                wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().likeRight(PortalNewsTree::getPath, (Object)portalNewsTree.getPath().split("\\.")[0])).ne(PortalNewsTree::getId, (Object)portalNewsTree.getId());
                List trees = this.list((Wrapper)wrapper);
                if (BeanUtils.isEmpty((Object)trees)) {
                    throw new BaseException("\u8be5\u5206\u7c7b\u4e0b\u4e0d\u5b58\u5728\u5b50\u5206\u7c7b\uff0c\u4e0d\u53ef\u5bfc\u51fa\uff01");
                }
                exportMap.put("trees", trees);
                if (EXPORT_ONLY_MENU.equals(exportType)) {
                    json = JsonUtil.toJson(exportMap);
                } else if (EXPORT_ALL.equals(exportType)) {
                    LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)Wrappers.lambdaQuery().likeRight(PortalNewsNotice::getClassifyPath, (Object)portalNewsTree.getPath().split("\\.")[0]);
                    List notices = this.portalNewsNoticeManager.list((Wrapper)wrapper1);
                    exportMap.put("notices", notices);
                    json = JsonUtil.toJson(exportMap);
                }
            } else if (rank.intValue() == 2) {
                wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().likeRight(PortalNewsTree::getPath, (Object)(portalNewsTree.getPath().split("\\.")[0] + "." + portalNewsTree.getPath().split("\\.")[1]))).eq(PortalNewsTree::getParentId, (Object)portalNewsTree.getId());
                List trees = this.list((Wrapper)wrapper);
                if (BeanUtils.isEmpty((Object)trees)) {
                    throw new BaseException("\u8be5\u5206\u7c7b\u4e0b\u4e0d\u5b58\u5728\u5b50\u5206\u7c7b\uff0c\u4e0d\u53ef\u5bfc\u51fa\uff01");
                }
                exportMap.put("trees", trees);
                if (EXPORT_ONLY_MENU.equals(exportType)) {
                    json = JsonUtil.toJson(exportMap);
                } else if (EXPORT_ALL.equals(exportType)) {
                    LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)Wrappers.lambdaQuery().likeRight(PortalNewsNotice::getClassifyPath, (Object)(portalNewsTree.getPath().split("\\.")[0] + "." + portalNewsTree.getPath().split("\\.")[1]));
                    List notices = this.portalNewsNoticeManager.list((Wrapper)wrapper1);
                    exportMap.put("notices", notices);
                    json = JsonUtil.toJson(exportMap);
                }
            } else {
                throw new BaseException("\u4e0d\u652f\u6301\u8be5\u5206\u7c7b\u7684\u5bfc\u51fa");
            }
            if (StringUtil.isNotEmpty((String)json)) {
                String fileName = "portalTree" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
                HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"portalTree.json", (String)fileName);
            }
        }
    }

    private Map<String, PortalNewsTree> getPortalNewsTreeByNameMap(List<PortalNewsTree> tree, String targetId) {
        List treeNames = tree.stream().map(PortalNewsTree::getName).collect(Collectors.toList());
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalNewsTree::getParentId, (Object)targetId)).in(PortalNewsTree::getName, treeNames);
        List portalNewsList = ((PortalNewsTreeDao)this.getBaseMapper()).selectList((Wrapper)query);
        if (BeanUtils.isNotEmpty((Object)portalNewsList)) {
            Map<String, PortalNewsTree> treeMap = portalNewsList.stream().collect(Collectors.toMap(PortalNewsTree::getName, m -> m, (key1, key2) -> key2));
            return treeMap;
        }
        return Maps.newHashMap();
    }

    private Map<String, String> handleTreeRank2(List<PortalNewsTree> trees2, String targetId) {
        Map<String, PortalNewsTree> treeMap = this.getPortalNewsTreeByNameMap(trees2, targetId);
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (PortalNewsTree tree : trees2) {
            String newId;
            PortalNewsTree portalNewsTree;
            String oldId;
            tree.setParentId(targetId);
            tree.setPath(targetId + "." + tree.getId() + ".");
            PortalNewsTree oldVal = (PortalNewsTree)((Object)((PortalNewsTreeDao)this.baseMapper).selectById((Serializable)((Object)tree.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getPath(), (String)tree.getPath())) {
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                if (treeMap.containsKey(tree.getName())) {
                    oldId = tree.getId();
                    portalNewsTree = treeMap.get(tree.getName());
                    tree.setId(portalNewsTree.getId());
                    tree.setCreateTime(portalNewsTree.getCreateTime());
                    rtnMap.put(oldId, portalNewsTree.getId());
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                oldId = tree.getId();
                newId = UniqueIdUtil.getSuid();
                tree.setId(newId);
                tree.setPath(tree.getPath().replace(oldId, newId));
                rtnMap.put(oldId, newId);
                if (this.saaSConfig.isEnable()) {
                    tree.setTenantId(null);
                }
                ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
                continue;
            }
            if (treeMap.containsKey(tree.getName())) {
                oldId = tree.getId();
                portalNewsTree = treeMap.get(tree.getName());
                tree.setId(portalNewsTree.getId());
                rtnMap.put(oldId, portalNewsTree.getId());
                ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                continue;
            }
            oldId = tree.getId();
            newId = UniqueIdUtil.getSuid();
            tree.setId(newId);
            tree.setPath(tree.getPath().replace(oldId, newId));
            rtnMap.put(oldId, newId);
            if (this.saaSConfig.isEnable()) {
                tree.setTenantId(null);
            }
            ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
        }
        return rtnMap;
    }

    private Map<String, String> handleTreeRank3(List<PortalNewsTree> tree3, String targetId, Map<String, String> changeMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        PortalNewsTree parent = (PortalNewsTree)((Object)this.getById((Serializable)((Object)targetId)));
        if (BeanUtils.isEmpty((Object)((Object)parent))) {
            throw new BaseException("\u7236\u8282\u70b9\u4e3a\u7a7a");
        }
        Map<String, PortalNewsTree> treeMap = this.getPortalNewsTreeByNameMap(tree3, targetId);
        for (PortalNewsTree tree : tree3) {
            String newId;
            PortalNewsTree portalNewsTree;
            String oldId;
            if (changeMap.containsKey(tree.getParentId())) {
                String newPar = changeMap.get(tree.getParentId());
                tree.setParentId(newPar);
                tree.setPath(targetId + "." + newPar + "." + tree.getId() + ".");
            } else if (2 == parent.getRank().intValue()) {
                tree.setParentId(targetId);
                tree.setPath(tree.getPath().split("\\.")[0] + "." + targetId + "." + tree.getId() + ".");
            }
            PortalNewsTree oldVal = (PortalNewsTree)((Object)this.getById((Serializable)((Object)tree.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getParentId(), (String)tree.getParentId())) {
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                if (treeMap.containsKey(tree.getName())) {
                    oldId = tree.getId();
                    portalNewsTree = treeMap.get(tree.getName());
                    tree.setId(portalNewsTree.getId());
                    rtnMap.put(oldId, portalNewsTree.getId());
                    ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                    continue;
                }
                oldId = tree.getId();
                newId = UniqueIdUtil.getSuid();
                tree.setId(newId);
                tree.setPath(tree.getPath().replace(oldId, newId));
                rtnMap.put(oldId, newId);
                if (this.saaSConfig.isEnable()) {
                    tree.setTenantId(null);
                }
                ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
                continue;
            }
            if (treeMap.containsKey(tree.getName())) {
                oldId = tree.getId();
                portalNewsTree = treeMap.get(tree.getName());
                tree.setId(portalNewsTree.getId());
                rtnMap.put(oldId, portalNewsTree.getId());
                ((PortalNewsTreeDao)this.baseMapper).updateById((Object)tree);
                continue;
            }
            oldId = tree.getId();
            newId = UniqueIdUtil.getSuid();
            tree.setId(newId);
            tree.setPath(tree.getPath().replace(oldId, newId));
            rtnMap.put(oldId, newId);
            if (this.saaSConfig.isEnable()) {
                tree.setTenantId(null);
            }
            ((PortalNewsTreeDao)this.baseMapper).insert((Object)tree);
        }
        return rtnMap;
    }

    private void handleNotice(List<PortalNewsNotice> notices, Map<String, String> changeMap) {
        if (BeanUtils.isEmpty(notices)) {
            return;
        }
        for (PortalNewsNotice notice : notices) {
            PortalNewsTree classify;
            String classifyId = notice.getClassifyId();
            if (changeMap.containsKey(classifyId)) {
                classifyId = changeMap.get(classifyId);
            }
            if (BeanUtils.isEmpty((Object)((Object)(classify = (PortalNewsTree)((Object)((PortalNewsTreeDao)this.baseMapper).selectById((Serializable)((Object)classifyId))))))) {
                throw new BaseException("\u5728\u5bfc\u5165\u516c\u544a\u3010" + notice.getTitle() + "\u3011\u65f6\u6240\u5728\u5206\u7c7b\u672a\u83b7\u53d6\uff0c\u5bfc\u5165\u5931\u8d25");
            }
            notice.setClassifyId(classifyId);
            notice.setClassifyPath(classify.getPath());
            PortalNewsNotice oldVal = (PortalNewsNotice)((Object)this.portalNewsNoticeManager.getById((Serializable)((Object)notice.getId())));
            if (BeanUtils.isNotEmpty((Object)((Object)oldVal))) {
                if (StringUtil.equals((String)oldVal.getClassifyPath(), (String)notice.getClassifyPath())) {
                    this.portalNewsNoticeManager.updateById((Object)notice);
                    continue;
                }
                LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalNewsNotice::getClassifyId, (Object)classifyId)).eq(PortalNewsNotice::getTitle, (Object)notice.getTitle());
                List list = this.portalNewsNoticeManager.list((Wrapper)query);
                if (BeanUtils.isNotEmpty((Object)list)) {
                    PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((Object)list.get(0));
                    notice.setId(portalNewsNotice.getId());
                    this.portalNewsNoticeManager.updateById((Object)notice);
                    continue;
                }
                notice.setId(UniqueIdUtil.getSuid());
                if (this.saaSConfig.isEnable()) {
                    notice.setTenantId(null);
                }
                this.portalNewsNoticeManager.create((Model)notice);
                continue;
            }
            notice.setId(UniqueIdUtil.getSuid());
            if (this.saaSConfig.isEnable()) {
                notice.setTenantId(null);
            }
            this.portalNewsNoticeManager.create((Model)notice);
        }
    }
}

