/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.column.model.PortalMeetingApply;
import com.hotent.column.persistence.manager.PortalMeetingApplyManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f1a\u8bae\u5ba4\u7533\u8bf7"})
@ApiGroup(group={"group_portal"})
@RequestMapping(value={"/portalMeetingApply/v1/"})
public class PortalMeetingApplyController
extends BaseController<PortalMeetingApplyManager, PortalMeetingApply> {
    @RequestMapping(value={"apply"}, method={RequestMethod.POST, RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f1a\u8bae\u5ba4\u7533\u8bf7")
    public CommonResult<String> save(@ApiParam(name="meetingApply", value="\u7533\u8bf7\u4f1a\u8bae\u5ba4\u4fe1\u606f") @RequestBody PortalMeetingApply meetingApply) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).apply(meetingApply);
    }

    @RequestMapping(value={"getApplyByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u4f1a\u8bae\u7533\u8bf7\u8bb0\u5f55", httpMethod="GET", notes="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u4f1a\u8bae\u7533\u8bf7\u8bb0\u5f55")
    public List<PortalMeetingApply> getApplyByTime(@ApiParam(name="userId", value="\u7528\u6237id\uff08\u4e0d\u4f20\u5219\u4e0d\u8fc7\u6ee4\u7528\u6237\uff09") @RequestParam(required=false) Optional<String> userId, @ApiParam(name="startDate", value="\u5f00\u59cb\u65e5\u671f\uff08\u5982\uff1a2021-07-14 00:00:00\uff09") @RequestParam(required=false) Optional<String> startDate, @ApiParam(name="endDate", value="\u7ed3\u675f\u65e5\u671f\uff08\u5982\uff1a2021-07-15 00:00:00\uff09") @RequestParam(required=false) Optional<String> endDate) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).getApplyByTime(userId, startDate, endDate);
    }

    @RequestMapping(value={"updateMeetingApplyStatus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f8bid\u66f4\u65b0\u4f1a\u8bae\u7533\u8bf7\u72b6\u6001\uff08\u6d41\u7a0b\u914d\u7f6e\u7ed3\u675f\u4e8b\u4ef6\u811a\u672c\u89e6\u53d1\uff09")
    public CommonResult<String> updateMeetingApplyStatus(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid") @RequestParam String instId, @ApiParam(name="status", value="\u72b6\u6001") @RequestParam String status, @ApiParam(name="busData", value="bo\u6570\u636e") @RequestParam Optional<String> busData) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).updateByInstId(instId, status, busData.orElse(""));
    }

    @RequestMapping(value={"getApplyCount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7edf\u8ba1\u4f1a\u8bae\u5ba4\u7533\u8bf7\u72b6\u6001\u6570\u91cf", httpMethod="GET", notes="\u7edf\u8ba1\u4f1a\u8bae\u5ba4\u7533\u8bf7\u72b6\u6001\u6570\u91cf")
    public Map<String, Integer> getApplyCount(@ApiParam(name="ownerId", value="\u7533\u8bf7\u4ebaid") @RequestParam(required=false) Optional<String> ownerId, @ApiParam(name="roomId", value="\u4f1a\u8bae\u5ba4id") @RequestParam(required=false) Optional<String> roomId, @ApiParam(name="isOwner", value="\u662f\u5426\u53ea\u62c9\u53d6\u6211\u7533\u8bf7\u7684\uff1atrue\uff08\u662f\uff09\uff0cfalse\uff08\u5426\uff09") @RequestParam Optional<Boolean> isOwner) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).getApplyCount(ownerId, roomId, isOwner);
    }

    @RequestMapping(value={"getApplyPageByType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u7c7b\u578b\u83b7\u53d6\u4f1a\u8bae\u5ba4\u7533\u8bf7\u5206\u9875\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u72b6\u6001\u7c7b\u578b\u83b7\u53d6\u4f1a\u8bae\u5ba4\u7533\u8bf7\u5206\u9875\u6570\u636e")
    public PageList<PortalMeetingApply> getApplyPageByType(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="type", value="order\uff08\u9884\u7ea6\uff09\uff0ccurrent\uff08\u5f85\u6267\u884c\uff09\uff0ccompleted\uff08\u5df2\u5b8c\u6210\uff09") @RequestParam Optional<String> type, @ApiParam(name="isOwner", value="\u662f\u5426\u62c9\u53d6\u6211\u7533\u8bf7\u7684\uff1atrue\uff08\u662f\uff09\uff0cfalse\uff08\u5426\uff09") @RequestParam Optional<Boolean> isOwner) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).getApplyPageByType(queryFilter, type, isOwner);
    }

    @RequestMapping(value={"getApplyPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bae\u5ba4\u7533\u8bf7\u5206\u9875\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u4f1a\u8bae\u5ba4\u7533\u8bf7\u5206\u9875\u6570\u636e")
    public Map<String, PageList<PortalMeetingApply>> getApplyPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return ((PortalMeetingApplyManager)this.baseService).getApplyPage(queryFilter);
    }

    @DeleteMapping(value={"/{id}/{ownerId}"})
    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\uff0c\u4ed6\u4eba\u53d1\u8d77\u7684\u4f1a\u8bae\u4ec5\u5220\u9664\u81ea\u5df1\u7684\u65e5\u7a0b\u548c\u4f1a\u8bae\u8bb0\u5f55")
    public CommonResult<String> deleteLogic(@ApiParam(name="id", value="\u4f1a\u8bae\u4e3b\u952e") @PathVariable String id, @ApiParam(name="ownerId", value="\u4f1a\u8bae\u7533\u8bf7\u4eba") @PathVariable String ownerId) throws Exception {
        ((PortalMeetingApplyManager)this.baseService).deleteLogic(id, ownerId);
        return CommonResult.ok();
    }

    @PostMapping(value={"/cancelled/{id}/{status}"})
    @ApiOperation(value="\u66f4\u65b0\u4f1a\u8bae\u53d6\u6d88\u72b6\u6001")
    public CommonResult<String> cancelled(@ApiParam(name="id", value="\u4f1a\u8bae\u4e3b\u952e") @PathVariable String id, @ApiParam(name="status", value="\u662f\u5426\u5df2\u53d6\u6d88\uff0c0-\u5426\uff1b1-\u662f") @PathVariable Integer status) throws Exception {
        ((PortalMeetingApplyManager)this.baseService).updateCancelled(id, status);
        return CommonResult.ok();
    }
}

