/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.model.PortalNewsNotice;
import com.hotent.column.persistence.manager.PortalNewsNoticeManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"\u65b0\u95fb\u516c\u544a\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
@RequestMapping(value={"/portalNewsNotice/v1/"})
public class PortalNewsNoticeController
extends BaseController<PortalNewsNoticeManager, PortalNewsNotice> {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    PortalNewsNoticeManager portalNewsNoticeManager;

    @GetMapping(value={"/getNews"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u5b9e\u4f53")
    public List<PortalNewsNotice> getNews(@ApiParam(name="classifyId", value="\u5206\u7c7bid") @RequestParam String classifyId) {
        return ((PortalNewsNoticeManager)this.baseService).getNews(classifyId);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<PortalNewsNotice> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<PortalNewsNotice> queryFilter) {
        ArrayNode users;
        PageList list = ((PortalNewsNoticeManager)this.baseService).query(queryFilter);
        HashSet set = new HashSet();
        list.getRows().forEach(item -> set.add(item.getCreateBy()));
        HashMap map = new HashMap();
        if (BeanUtils.isNotEmpty(set) && set.size() > 0 && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getUserByIdsOrAccounts(StringUtil.join(set, (String)",")))) && users.size() > 0) {
            users.forEach(item -> map.put(item.get("id").asText(), item.get("fullname").asText()));
        }
        if (map.size() > 0) {
            list.getRows().forEach(item -> {
                if (map.containsKey(item.getCreateBy())) {
                    item.setCreateByName((String)map.get(item.getCreateBy()));
                }
            });
        }
        return list;
    }

    @GetMapping(value={"/getNewsById"})
    @ApiOperation(value="\u6839\u636e\u65b0\u95fbid\u67e5\u8be2\u5b9e\u4f53")
    public PortalNewsNotice getNewsById(@ApiParam(name="id", value="\u65b0\u95fb\u6570\u636eid") @RequestParam String id, @RequestParam(required=false) Boolean isRead) {
        return ((PortalNewsNoticeManager)this.baseService).getNewsById(id, isRead);
    }

    @PostMapping(value={"read"})
    @ApiOperation(value="\u8bbe\u7f6e\u65b0\u95fb\u516c\u544a\u4e3a\u5df2\u8bfb")
    public void setReadByIds(@RequestBody List<String> ids) {
        ((PortalNewsNoticeManager)this.baseService).setReadByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"exportNews"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u65b0\u95fb\u516c\u544a", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u65b0\u95fb\u516c\u544a")
    public void exportNews(HttpServletResponse response, HttpServletRequest request, @RequestBody List<String> ids) throws Exception {
        String fileName = "newsNotice_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String zipPath = ((PortalNewsNoticeManager)this.baseService).export(ids);
        try {
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)(zipPath + ".zip"), (String)(fileName + ".zip"));
        }
        finally {
            FileUtil.deleteFile((String)(zipPath + ".zip"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"importNews"})
    @ApiOperation(value="\u5bfc\u5165\u65b0\u95fb\u516c\u544a", httpMethod="POST", notes="\u5bfc\u5165\u65b0\u95fb\u516c\u544a")
    public CommonResult importNews(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam String classifyId) throws Exception {
        MultipartFile file = request.getFile("file");
        String operate = request.getParameter("operate");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            if (StringUtils.equals((CharSequence)operate, (CharSequence)"check")) {
                CommonResult<String> commonResult = ((PortalNewsNoticeManager)this.baseService).importCheck(uzPath, classifyId);
                return commonResult;
            }
            ((PortalNewsNoticeManager)this.baseService).importFile(uzPath, classifyId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @PostMapping(value={"/listNewsCurrentUserAuth"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u65b0\u95fb\u516c\u544a/\u8f6e\u64ad\u56fe")
    public PageList<PortalNewsNotice> listNewsCurrentUserAuth(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<PortalNewsNotice> queryFilter) {
        return this.portalNewsNoticeManager.listNewsCurrentUserAuth(queryFilter);
    }
}

