/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.enums;

import cn.hutool.core.collection.CollUtil;
import com.hotent.base.util.StringUtil;
import java.util.Arrays;
import java.util.List;

public enum MeetingTypeEnum {
    OFFLINE,
    ONLINE,
    ALL;


    public static Integer getType(String meetingType) {
        if (StringUtil.isEmpty((String)meetingType)) {
            return OFFLINE.ordinal();
        }
        List<String> list = Arrays.asList(meetingType.split(","));
        if (CollUtil.isEmpty(list)) {
            return OFFLINE.ordinal();
        }
        if (list.size() > 1) {
            return ALL.ordinal();
        }
        if (list.contains(OFFLINE.name().toLowerCase())) {
            return OFFLINE.ordinal();
        }
        if (list.contains(ONLINE.name().toLowerCase())) {
            return ONLINE.ordinal();
        }
        return OFFLINE.ordinal();
    }

    public static String getTypeDesc(Integer type) {
        MeetingTypeEnum typeEnum = OFFLINE;
        for (MeetingTypeEnum c : MeetingTypeEnum.values()) {
            if (type.intValue() != c.ordinal()) continue;
            typeEnum = c;
            break;
        }
        if (typeEnum.equals((Object)ALL)) {
            return OFFLINE.name().toLowerCase() + "," + ONLINE.name().toLowerCase();
        }
        return typeEnum.name().toLowerCase();
    }
}

