/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.handler;

import cn.hutool.extra.spring.SpringUtil;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.handler.RepeatExcision;
import com.hotent.column.model.PortalAgendaDay;
import com.hotent.column.model.PortalMeetingApply;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RepeatContext {
    private static Map<Integer, RepeatExcision> agendaRepeatExcisionMap = new HashMap<Integer, RepeatExcision>();

    RepeatContext() {
        Map beansOfType = SpringUtil.getBeansOfType(RepeatExcision.class);
        Map<RepeatEnum, RepeatExcision> excisionMap = beansOfType.values().stream().collect(Collectors.toMap(RepeatExcision::getAgendaRepeatEnum, o -> o, (o1, o2) -> o1));
        excisionMap.entrySet().forEach(entry -> agendaRepeatExcisionMap.put(((RepeatEnum)((Object)((Object)entry.getKey()))).getValue(), (RepeatExcision)entry.getValue()));
    }

    public static RepeatExcision getAgendaRepeatExcision(Integer repeatFrequencyType) {
        return Optional.ofNullable(repeatFrequencyType).map(agendaRepeatExcisionMap::get).orElse(agendaRepeatExcisionMap.get(RepeatEnum.NONE.getValue()));
    }

    public static <T> List<T> assemble(List<T> portalAgendaDayList, Optional<String> startDate, Optional<String> endDate) {
        if (BeanUtils.isEmpty(portalAgendaDayList)) {
            return portalAgendaDayList;
        }
        LocalDateTime startDateTime = null;
        if (startDate.isPresent() && StringUtil.isNotEmpty((String)startDate.get())) {
            startDateTime = LocalDateTime.parse(startDate.get(), DateFormatUtil.DATE_FORMAT_DATETIME);
        }
        LocalDateTime endDateTime = null;
        if (endDate.isPresent() && StringUtil.isNotEmpty((String)endDate.get())) {
            endDateTime = LocalDateTime.parse(endDate.get(), DateFormatUtil.DATE_FORMAT_DATETIME);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T portalAgendaDay : portalAgendaDayList) {
            Integer repeatType;
            if (portalAgendaDay instanceof PortalAgendaDay) {
                PortalAgendaDay agendaDay = (PortalAgendaDay)((Object)portalAgendaDay);
                repeatType = agendaDay.getRepeatType();
            } else if (portalAgendaDay instanceof PortalMeetingApply) {
                PortalMeetingApply portalMeetingApply = (PortalMeetingApply)((Object)portalAgendaDay);
                repeatType = portalMeetingApply.getRepeatType();
            } else {
                throw new BaseException("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u91cd\u590d\u7c7b\u578b");
            }
            RepeatExcision repeatExcision = RepeatContext.getAgendaRepeatExcision(repeatType);
            List<T> list = repeatExcision.handle(portalAgendaDay, startDateTime, endDateTime);
            result.addAll(repeatExcision.partition(list));
        }
        return result;
    }
}

