/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.column.enums.AgendaRightTypeEnum;
import com.hotent.column.model.PortalAgendaDayUser;
import com.hotent.column.persistence.dao.PortalAgendaDayUserDao;
import com.hotent.column.persistence.manager.AuthorityManager;
import com.hotent.column.persistence.manager.PortalAgendaDayUserManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalAgendaDayUserManagerImpl
extends BaseManagerImpl<PortalAgendaDayUserDao, PortalAgendaDayUser>
implements PortalAgendaDayUserManager {
    @Override
    public PortalAgendaDayUser getDetail(String id) {
        PortalAgendaDayUser portalAgendaDayUser = (PortalAgendaDayUser)this.get((Serializable)((Object)id));
        return portalAgendaDayUser;
    }

    @Override
    @Transactional
    public void createOrUpdate(PortalAgendaDayUser portalAgendaDayUser) {
        this.saveOrUpdate((Object)portalAgendaDayUser);
    }

    @Override
    public List<PortalAgendaDayUser> getAuthUser() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        AuthorityManager authorityManager = (AuthorityManager)AppUtil.getBean(AuthorityManager.class);
        Map<String, Set<String>> authMap = authorityManager.getUserRightMap();
        boolean isExists = false;
        if (authMap != null) {
            for (Map.Entry<String, Set<String>> entry : authMap.entrySet()) {
                AgendaRightTypeEnum rightTypeEnum;
                if (entry.getValue() == null || entry.getValue().size() <= 0 || (rightTypeEnum = AgendaRightTypeEnum.fromKey(entry.getKey())) == null || rightTypeEnum == AgendaRightTypeEnum.EVERY_ONE || rightTypeEnum == AgendaRightTypeEnum.OTHERS) continue;
                isExists = true;
                wrapper.or(wq -> {
                    wq.eq(PortalAgendaDayUser::getRightType, (Object)rightTypeEnum.ordinal());
                    wq.in(PortalAgendaDayUser::getOwnerId, (Collection)entry.getValue());
                });
            }
        }
        if (!isExists) {
            return new ArrayList<PortalAgendaDayUser>();
        }
        return this.list((Wrapper)wrapper);
    }
}

