/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.handler.RepeatContext;
import com.hotent.column.model.PortalAgendaDay;
import com.hotent.column.model.PortalMeetingApply;
import com.hotent.column.model.PortalMeetingConfig;
import com.hotent.column.model.PortalMeetingDel;
import com.hotent.column.model.PortalMeetingRoom;
import com.hotent.column.persistence.dao.PortalMeetingApplyDao;
import com.hotent.column.persistence.manager.PortalAgendaDayManager;
import com.hotent.column.persistence.manager.PortalMeetingApplyManager;
import com.hotent.column.persistence.manager.PortalMeetingConfigManager;
import com.hotent.column.persistence.manager.PortalMeetingDelManager;
import com.hotent.column.persistence.manager.PortalMeetingRoomManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalMeetingApplyManagerImpl
extends BaseManagerImpl<PortalMeetingApplyDao, PortalMeetingApply>
implements PortalMeetingApplyManager {
    private static final Logger logger = LoggerFactory.getLogger(PortalMeetingApplyManagerImpl.class);
    @Resource
    PortalMeetingConfigManager portalMeetingConfigManager;
    @Resource
    BpmRuntimeFeignService runtimeService;
    @Resource
    PortalMeetingRoomManager roomService;
    @Resource
    PortalMeetingApplyDao portalMeetingApplyDao;
    @Resource
    PortalAgendaDayManager portalAgendaDayManager;
    @Resource
    PortalMeetingDelManager portalMeetingDelManager;

    @Override
    @Transactional
    public CommonResult<String> apply(PortalMeetingApply meetingApply) throws Exception {
        if (StringUtil.isNotEmpty((String)meetingApply.getMeetingType()) && meetingApply.getMeetingType().contains("offline") && StringUtil.isEmpty((String)meetingApply.getMeetingId())) {
            return new CommonResult(false, "\u7533\u8bf7\u5931\u8d25\uff1a\u4f1a\u8bae\u5ba4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (BeanUtils.isEmpty((Object)meetingApply.getStartTime()) || BeanUtils.isEmpty((Object)meetingApply.getEndTime())) {
            return new CommonResult(false, "\u7533\u8bf7\u5931\u8d25\uff1a\u7533\u8bf7\u4f1a\u8bae\u5ba4\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String taskId = "";
        String msg = "\u7533\u8bf7\u6210\u529f";
        CommonResult<String> verifyResult = this.verifyApply(meetingApply.getId(), meetingApply.getMeetingId(), meetingApply.getStartTime(), meetingApply.getEndTime());
        if (!verifyResult.getState().booleanValue()) {
            return verifyResult;
        }
        if (StringUtil.isNotEmpty((String)meetingApply.getId())) {
            meetingApply.setTenantId(TenantUtil.getCurrentTenantId());
        }
        if (StringUtil.isEmpty((String)meetingApply.getId())) {
            PortalMeetingRoomManager portalMeetingRoomManager;
            PortalMeetingRoom meetingRoom;
            if (StringUtil.isEmpty((String)meetingApply.getOwnerOwnerId())) {
                IGroup group;
                IUser user = ContextUtil.getCurrentUser();
                if (BeanUtils.isNotEmpty((Object)user)) {
                    meetingApply.setOwnerOwnerId(user.getUserId());
                    meetingApply.setMeetingOwner(user.getFullname());
                }
                if (BeanUtils.isNotEmpty((Object)(group = ContextUtil.getCurrentGroup()))) {
                    meetingApply.setMeetingDepId(group.getGroupId());
                    meetingApply.setMeetingDep(group.getName());
                }
            }
            PortalMeetingConfig config = null;
            if (StringUtil.isNotEmpty((String)meetingApply.getMeetingId()) && (meetingRoom = (PortalMeetingRoom)(portalMeetingRoomManager = (PortalMeetingRoomManager)AppUtil.getBean(PortalMeetingRoomManager.class)).get((Serializable)((Object)meetingApply.getMeetingId()))) != null && meetingRoom.getNeedPending().booleanValue()) {
                config = this.portalMeetingConfigManager.getConfig();
            }
            if (config != null && Integer.valueOf(1).equals(config.getBindFlow())) {
                String instId;
                meetingApply.setCancelled(0);
                try {
                    instId = this.startApplyFlow(config, meetingApply);
                }
                catch (Exception e) {
                    logger.error("\u542f\u52a8\u7533\u8bf7\u4f1a\u8bae\u6d41\u7a0b\u5f02\u5e38", (Throwable)e);
                    CommonResult commonResult = new CommonResult(false, "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u4f1a\u8bae\u5ba4\u914d\u7f6e");
                    commonResult.setErrorCode(ResponseErrorEnums.COMMON_WARNING_CODE.getCode());
                    return commonResult;
                }
                if (instId.contains(":")) {
                    String[] ids = instId.split(":");
                    instId = ids[0];
                    taskId = ids[1];
                    String meetingId = ids[2];
                    if (StringUtil.isNotEmpty((String)meetingId)) {
                        meetingApply.setId(meetingId);
                        if (ContextUtil.getCurrentUser() != null) {
                            meetingApply.setTenantId(ContextUtil.getCurrentUser().getTenantId());
                        }
                    }
                }
                meetingApply.setProInstId(instId);
                meetingApply.setStatus("applying");
                this.saveOrUpdate((Object)meetingApply);
            } else {
                meetingApply.setStatus("approved");
                super.create((Model)meetingApply);
            }
            PortalAgendaDay agendaDay = this.buildAgendaDay(meetingApply, null);
            this.portalAgendaDayManager.createOrUpdate(agendaDay);
        } else {
            super.updateById((Object)meetingApply);
            List dayList = this.portalAgendaDayManager.list((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDay::getMeetingId, (Object)meetingApply.getId()));
            if (CollUtil.isNotEmpty((Collection)dayList)) {
                PortalAgendaDay day = (PortalAgendaDay)((Object)dayList.get(0));
                if (day.getStartTime() == null || !day.getStartTime().equals(meetingApply.getStartTime())) {
                    day.setLastReminderTime(null);
                }
                day = this.buildAgendaDay(meetingApply, day);
                this.portalAgendaDayManager.update((Model)day);
            }
            msg = "\u66f4\u65b0\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)taskId);
    }

    private PortalAgendaDay buildAgendaDay(PortalMeetingApply meetingApply, PortalAgendaDay agendaDay) {
        if (agendaDay == null) {
            agendaDay = new PortalAgendaDay();
        }
        agendaDay.setParticipantsId(meetingApply.getParticipantsId());
        agendaDay.setParticipantsName(meetingApply.getParticipantsName());
        agendaDay.setShareId(meetingApply.getShareId());
        agendaDay.setShareName(meetingApply.getShareName());
        agendaDay.setStartTime(meetingApply.getStartTime());
        agendaDay.setEndTime(meetingApply.getEndTime());
        agendaDay.setContent(meetingApply.getSubject());
        agendaDay.setReminderType(meetingApply.getReminderType());
        agendaDay.setReminderMinutes(meetingApply.getReminderMinutes());
        agendaDay.setMeetingId(meetingApply.getId());
        agendaDay.setRepeatEndDate(meetingApply.getRepeatEndDate());
        agendaDay.setRepeatEndType(meetingApply.getRepeatEndType());
        agendaDay.setRepeatFrequency(meetingApply.getRepeatFrequency());
        agendaDay.setRepeatFrequencyInterval(meetingApply.getRepeatFrequencyInterval());
        agendaDay.setRepeatType(meetingApply.getRepeatType());
        agendaDay.setRepeatFrequencyType(meetingApply.getRepeatFrequencyType());
        return agendaDay;
    }

    @Override
    public CommonResult<String> verifyApply(String applyId, String roomId, LocalDateTime startTime, LocalDateTime endTime) {
        if (StringUtil.isEmpty((String)roomId)) {
            return new CommonResult(true, "\u5728\u7ebf\u4f1a\u8bae\u53ef\u7533\u8bf7\u3002");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("meetingId", roomId);
        param.put("startTime", TimeUtil.getDateTimeString((LocalDateTime)startTime));
        param.put("endTime", TimeUtil.getDateTimeString((LocalDateTime)endTime));
        param.put("id", applyId);
        param.put("status", "rejected");
        param.put("cancelled", 0);
        List<String> excludeIdList = this.portalMeetingDelManager.getExcludeMeeting();
        if (CollUtil.isNotEmpty(excludeIdList)) {
            param.put("excludeIdList", excludeIdList);
        }
        param.put("group", "start");
        if (this.portalMeetingApplyDao.countVerifyApply(param) > 0) {
            return CommonResult.error((String)"\u7533\u8bf7\u5931\u8d25\uff1a\u4f1a\u8bae\u5ba4\u7533\u8bf7\u65f6\u95f4\u51b2\u7a81\u3002");
        }
        param.put("group", "end");
        if (this.portalMeetingApplyDao.countVerifyApply(param) > 0) {
            return CommonResult.error((String)"\u7533\u8bf7\u5931\u8d25\uff1a\u4f1a\u8bae\u5ba4\u7533\u8bf7\u65f6\u95f4\u51b2\u7a81\u3002");
        }
        param.put("group", "eq");
        if (this.portalMeetingApplyDao.countVerifyApply(param) > 0) {
            return CommonResult.error((String)"\u7533\u8bf7\u5931\u8d25\uff1a\u4f1a\u8bae\u5ba4\u7533\u8bf7\u65f6\u95f4\u51b2\u7a81\u3002");
        }
        return new CommonResult(true, "\u4f1a\u8bae\u5ba4\u53ef\u7533\u8bf7\u3002");
    }

    private String startApplyFlow(PortalMeetingConfig config, PortalMeetingApply meetingApply) throws Exception {
        StringBuilder result;
        String boDefKey = "hyssqgl";
        ObjectNode newDataNode = JsonUtil.getMapper().createObjectNode();
        ObjectNode meetingDataNode = (ObjectNode)JsonUtil.toJsonNode((Object)((Object)meetingApply));
        Iterator fields = meetingDataNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            result = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isUpperCase(c)) {
                    result.append('_');
                    result.append(Character.toLowerCase(c));
                    continue;
                }
                result.append(c);
            }
            key = result.toString() + "_";
            key = key.toUpperCase();
            newDataNode.set(key, (JsonNode)next.getValue());
        }
        ObjectNode dataNode = JsonUtil.getMapper().createObjectNode();
        dataNode.set(boDefKey, (JsonNode)newDataNode);
        ObjectNode params = JsonUtil.getMapper().createObjectNode();
        params.put("boDefKey", boDefKey);
        params.set("data", (JsonNode)newDataNode);
        result = this.runtimeService.meetingRoomApply(params, config.getFlowKey());
        if (result.getState().booleanValue()) {
            return (String)result.getValue();
        }
        throw new WorkFlowException("\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + result.getMessage());
    }

    @Override
    public CommonResult<String> updateByInstId(String instId, String status, String busData) throws Exception {
        PortalMeetingApply apply = ((PortalMeetingApplyDao)this.baseMapper).getByInstId(instId);
        if (BeanUtils.isNotEmpty((Object)((Object)apply))) {
            CommonResult<String> verifyResult;
            if (StringUtil.isNotEmpty((String)busData) && !(verifyResult = this.verifyApply((apply = this.backfillFormData(apply, busData)).getId(), apply.getMeetingId(), apply.getStartTime(), apply.getEndTime())).getState().booleanValue()) {
                return verifyResult;
            }
        } else {
            if (StringUtil.isNotEmpty((String)busData)) {
                return new CommonResult(false, "\u5b9e\u4f8bID\u4e3a\uff1a" + instId + " \u7684\u4f1a\u8bae\u7533\u8bf7\u4e0d\u5b58\u5728\u3002");
            }
            return new CommonResult(true, "\u8be5\u5b9e\u4f8bid\u4e0d\u5b58\u5728\u4f1a\u8bae\u5ba4\u7533\u8bf7\u8bb0\u5f55\u3002");
        }
        apply.setStatus("agree".equals(status) ? "approved" : "rejected");
        super.update((Model)apply);
        return new CommonResult(true, "\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }

    private PortalMeetingApply backfillFormData(PortalMeetingApply apply, String busData) throws Exception {
        PortalMeetingConfig config = this.portalMeetingConfigManager.getConfig();
        PortalMeetingRoom meetingRoom = (PortalMeetingRoom)this.roomService.get((Serializable)((Object)apply.getMeetingId()));
        ObjectNode mappingNode = (ObjectNode)JsonUtil.toJsonNode((String)config.getFieldMapping());
        JsonNode formData = JsonUtil.toJsonNode((String)busData);
        Iterator fields = mappingNode.fields();
        while (fields.hasNext()) {
            String path;
            String[] paths;
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            if (!BeanUtils.isNotEmpty(next.getValue()) || (paths = (path = ((JsonNode)next.getValue()).textValue()).split("\\.")).length <= 1) continue;
            String boDefKey = paths[0];
            String field = paths[1];
            if (!formData.has(boDefKey) || !formData.get(boDefKey).has(field)) continue;
            String value = formData.get(boDefKey).get(field).asText();
            switch (key) {
                case "subject": {
                    apply.setSubject(value);
                    break;
                }
                case "endTime": {
                    apply.setEndTime(TimeUtil.convertString((String)value));
                    break;
                }
                case "startTime": {
                    apply.setStartTime(TimeUtil.convertString((String)value));
                    break;
                }
                case "participantsName": {
                    apply.setParticipantsName(value);
                    break;
                }
                case "participantsId": {
                    apply.setParticipantsId(value);
                    break;
                }
                case "alias": {
                    if (meetingRoom.getAlias().equals(value)) break;
                    PortalMeetingRoom nmeetingRoom = this.roomService.getByAlias(value);
                    if (BeanUtils.isNotEmpty((Object)((Object)nmeetingRoom))) {
                        apply.setMeetingId(nmeetingRoom.getId());
                        apply.setMeetingName(nmeetingRoom.getName());
                        break;
                    }
                    throw new WorkFlowException("\u4f1a\u8bae\u5ba4\u522b\u540d\uff1a" + value + " \u4e0d\u5b58\u5728");
                }
            }
        }
        return apply;
    }

    @Override
    public PortalMeetingApply getByInstId(String instId) {
        return ((PortalMeetingApplyDao)this.baseMapper).getByInstId(instId);
    }

    @Override
    public Map<String, Integer> getApplyCount(String ownerId, String roomId) throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List list = ((PortalMeetingApplyDao)this.baseMapper).getApplyCount(StringUtil.isEmpty((String)ownerId) ? null : ownerId, StringUtil.isEmpty((String)roomId) ? null : roomId);
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (Object obj : list) {
                JsonNode node = JsonUtil.toJsonNode(obj);
                map.put(node.get("status").asText(), node.get("amount").asInt());
            }
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLogic(String id, String ownerId) throws Exception {
        if (Objects.equals(ContextUtil.getCurrentUserId(), ownerId)) {
            this.remove((Serializable)((Object)id));
            this.portalAgendaDayManager.remove((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDay::getMeetingId, (Object)id));
        } else {
            List agendaDayList = this.portalAgendaDayManager.list((Wrapper)Wrappers.lambdaQuery().eq(PortalAgendaDay::getMeetingId, (Object)id));
            String agendaDayId = "";
            if (CollUtil.isNotEmpty((Collection)agendaDayList)) {
                agendaDayId = ((PortalAgendaDay)((Object)agendaDayList.get(0))).getId();
            }
            PortalMeetingDel meetingDel = new PortalMeetingDel();
            meetingDel.setUserId(ContextUtil.getCurrentUserId());
            meetingDel.setMeetingId(id);
            meetingDel.setAgendaDayId(agendaDayId);
            this.portalMeetingDelManager.create((Model)meetingDel);
        }
    }

    @Override
    public PageList<PortalMeetingApply> getApplyPageByType(QueryFilter queryFilter, Optional<String> type, Optional<Boolean> isOwner) throws Exception {
        List<String> excludeIdList;
        String userId = ContextUtil.getCurrentUserId();
        if (!isOwner.orElse(false).booleanValue()) {
            queryFilter.addFilter("PARTICIPANTS_ID_", (Object)userId, QueryOP.LIKE, FieldRelation.AND, "base");
        } else {
            queryFilter.addFilter("OWNER_OWNER_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND, "base");
        }
        String typeStr = type.orElse("");
        LocalDateTime nowTime = LocalDateTime.now();
        if (StringUtil.isNotEmpty((String)typeStr)) {
            switch (typeStr) {
                case "order": {
                    queryFilter.addFilter("START_TIME_", (Object)nowTime, QueryOP.GREAT, FieldRelation.AND, "order");
                    queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "order");
                    queryFilter.addFilter("STATUS_", (Object)"applying", QueryOP.NOT_EQUAL, FieldRelation.AND, "order");
                    queryFilter.addFilter("cancelled", (Object)0, QueryOP.EQUAL, FieldRelation.AND, "order");
                    break;
                }
                case "current": {
                    queryFilter.addFilter("START_TIME_", (Object)nowTime, QueryOP.LESS_EQUAL, FieldRelation.AND, "current");
                    queryFilter.addFilter("END_TIME_", (Object)nowTime, QueryOP.GREAT_EQUAL, FieldRelation.AND, "current");
                    queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "current");
                    queryFilter.addFilter("cancelled", (Object)0, QueryOP.EQUAL, FieldRelation.AND, "current");
                    break;
                }
                case "completed": {
                    queryFilter.addFilter("END_TIME_", (Object)nowTime, QueryOP.LESS, FieldRelation.AND, "completed");
                    queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "completed");
                    queryFilter.addFilter("cancelled", (Object)0, QueryOP.EQUAL, FieldRelation.AND, "completed");
                    break;
                }
                case "cancelled": {
                    queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "cancelled");
                    queryFilter.addFilter("cancelled", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "cancelled");
                }
                case "applying": {
                    queryFilter.addFilter("STATUS_", (Object)"applying", QueryOP.EQUAL, FieldRelation.AND, "cancelledOr");
                    queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.EQUAL, FieldRelation.OR, "cancelledOr");
                    queryFilter.addFilter("cancelled", (Object)0, QueryOP.EQUAL, FieldRelation.AND, "cancelled");
                }
            }
        }
        if (CollUtil.isNotEmpty(excludeIdList = this.portalMeetingDelManager.getExcludeMeeting())) {
            queryFilter.addFilter("ID_", excludeIdList, QueryOP.NOT_IN, FieldRelation.AND, "base");
        }
        PageList result = super.query(queryFilter);
        result.setRows(this.addRecordStatus(result.getRows()));
        return result;
    }

    @Override
    public Map<String, PageList<PortalMeetingApply>> getApplyPage(QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("OWNER_OWNER_ID_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND, "base");
        queryFilter.addFilter("PARTICIPANTS_ID_", (Object)userId, QueryOP.LIKE, FieldRelation.OR, "base");
        QueryFilter orderfilter = QueryFilter.build().withPage(queryFilter.getPageBean());
        QueryFilter currentFilter = QueryFilter.build().withPage(queryFilter.getPageBean());
        QueryFilter completedFilter = QueryFilter.build().withPage(queryFilter.getPageBean());
        List queryFields = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)queryFields)) {
            for (QueryField queryField : queryFields) {
                orderfilter.addQueryField(queryField);
                currentFilter.addQueryField(queryField);
                completedFilter.addQueryField(queryField);
            }
        }
        LocalDateTime nowTime = LocalDateTime.now();
        HashMap<String, PageList<PortalMeetingApply>> map = new HashMap<String, PageList<PortalMeetingApply>>();
        queryFilter.addFilter("START_TIME_", (Object)nowTime, QueryOP.GREAT, FieldRelation.AND, "order");
        queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "order");
        map.put("order", super.query(orderfilter));
        queryFilter.addFilter("START_TIME_", (Object)nowTime, QueryOP.LESS_EQUAL, FieldRelation.AND, "current");
        queryFilter.addFilter("END_TIME_", (Object)nowTime, QueryOP.GREAT_EQUAL, FieldRelation.AND, "current");
        currentFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "current");
        map.put("current", super.query(currentFilter));
        queryFilter.addFilter("END_TIME_", (Object)nowTime, QueryOP.LESS, FieldRelation.AND, "completed");
        queryFilter.addFilter("STATUS_", (Object)"rejected", QueryOP.NOT_EQUAL, FieldRelation.AND, "completed");
        map.put("completed", super.query(completedFilter));
        return map;
    }

    @Override
    public Map<String, Integer> getApplyCount(Optional<String> ownerId, Optional<String> roomId, Optional<Boolean> isOwner) throws Exception {
        QueryFilter orderfilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        QueryFilter currentFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        QueryFilter completedFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        if (ownerId.isPresent() && StringUtil.isNotEmpty((String)ownerId.get())) {
            orderfilter.addFilter("OWNER_OWNER_ID_", (Object)ownerId.get(), QueryOP.EQUAL);
            currentFilter.addFilter("OWNER_OWNER_ID_", (Object)ownerId.get(), QueryOP.EQUAL);
            completedFilter.addFilter("OWNER_OWNER_ID_", (Object)ownerId.get(), QueryOP.EQUAL);
        }
        if (roomId.isPresent() && StringUtil.isNotEmpty((String)roomId.get())) {
            orderfilter.addFilter("MEETING_ID_", (Object)roomId.get(), QueryOP.EQUAL);
            currentFilter.addFilter("MEETING_ID_", (Object)roomId.get(), QueryOP.EQUAL);
            completedFilter.addFilter("MEETING_ID_", (Object)roomId.get(), QueryOP.EQUAL);
        }
        PageList<PortalMeetingApply> orderPage = this.getApplyPageByType(orderfilter, Optional.of("order"), isOwner);
        PageList<PortalMeetingApply> currentPage = this.getApplyPageByType(currentFilter, Optional.of("current"), isOwner);
        PageList<PortalMeetingApply> completedPage = this.getApplyPageByType(completedFilter, Optional.of("completed"), isOwner);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("order", (int)orderPage.getTotal());
        map.put("current", (int)currentPage.getTotal());
        map.put("completed", (int)completedPage.getTotal());
        return map;
    }

    @Override
    public List<PortalMeetingApply> getApplyByTime(Optional<String> userIdInput, Optional<String> startDate, Optional<String> endDate) throws Exception {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (userIdInput.isPresent() && StringUtil.isNotEmpty((String)userIdInput.get())) {
            String userId = userIdInput.get();
            wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(PortalMeetingApply::getOwnerOwnerId, (Object)userId)).or()).eq(PortalMeetingApply::getShareId, (Object)userId)).or()).likeLeft(PortalMeetingApply::getShareId, (Object)("," + userId))).or()).likeRight(PortalMeetingApply::getShareId, (Object)(userId + ","))).or()).like(PortalMeetingApply::getShareId, (Object)("," + userId + ","))).or()).eq(PortalMeetingApply::getParticipantsId, (Object)userId)).or()).likeLeft(PortalMeetingApply::getParticipantsId, (Object)("," + userId))).or()).likeRight(PortalMeetingApply::getParticipantsId, (Object)(userId + ","))).or()).like(PortalMeetingApply::getParticipantsId, (Object)("," + userId + ","));
            });
        }
        wrapper.and(w -> w.and(ww -> {
            List<String> excludeIdList = this.portalMeetingDelManager.getExcludeMeeting();
            if (CollUtil.isNotEmpty(excludeIdList)) {
                ww.notIn(PortalMeetingApply::getId, excludeIdList);
            }
            ww.eq(PortalMeetingApply::getCancelled, (Object)0);
        }));
        wrapper.and(w -> {
            w.and(ww -> {
                if (StringUtil.isNotEmpty((Optional)startDate) && startDate.isPresent()) {
                    ww.ge(PortalMeetingApply::getEndTime, (Object)LocalDateTimeUtil.parse((CharSequence)((CharSequence)startDate.get()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtil.isNotEmpty((Optional)endDate) && endDate.isPresent()) {
                    ww.le(PortalMeetingApply::getStartTime, (Object)LocalDateTimeUtil.parse((CharSequence)((CharSequence)endDate.get()), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            });
            ((LambdaQueryWrapper)w.or()).in(PortalMeetingApply::getRepeatType, Arrays.asList(RepeatEnum.EVERY_DAY.getValue(), RepeatEnum.EVERY_WORK_DAY.getValue(), RepeatEnum.EVERY_MONTH.getValue(), RepeatEnum.EVERY_WEEK.getValue(), RepeatEnum.CUSTOM.getValue()));
        });
        List<PortalMeetingApply> rows = this.list((Wrapper)wrapper);
        rows = RepeatContext.assemble(rows, startDate, endDate);
        return this.addRecordStatus(rows);
    }

    @Override
    public PortalMeetingApply addRecordStatusOne(PortalMeetingApply row) {
        LocalDateTime nowTime = LocalDateTime.now();
        String status = "order";
        if (row.getCancelled() != null && row.getCancelled() == 1) {
            status = "cancelled";
        } else if ("applying".equals(row.getStatus()) || "rejected".equals(row.getStatus())) {
            status = row.getStatus();
        } else {
            boolean isCurrent;
            boolean bl = isCurrent = !(!row.getStartTime().isBefore(nowTime) && !row.getStartTime().equals(nowTime) || !row.getEndTime().isAfter(nowTime) && !row.getEndTime().equals(nowTime));
            if (row.getStartTime().isAfter(nowTime)) {
                status = "order";
            } else if (isCurrent) {
                status = "current";
            } else if (row.getEndTime().isBefore(nowTime)) {
                status = "completed";
            }
        }
        row.setRecordStatus(status);
        return row;
    }

    private List<PortalMeetingApply> addRecordStatus(List<PortalMeetingApply> rows) {
        if (CollUtil.isEmpty(rows)) {
            return rows;
        }
        rows.forEach(row -> {
            row = this.addRecordStatusOne((PortalMeetingApply)((Object)row));
        });
        return rows;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCancelled(String id, Integer status) {
        ((PortalMeetingApplyDao)this.baseMapper).updateCancelled(id, status);
        this.portalAgendaDayManager.deleteByMeetingId(id);
    }

    @Override
    public List<PortalMeetingApply> getByIds(List<String> ids) {
        return this.list((Wrapper)Wrappers.lambdaQuery().in(PortalMeetingApply::getId, ids));
    }
}

