/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.service.InvokeResult;
import com.hotent.base.service.ServiceClient;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.constant.SysIndexColumnEnum;
import com.hotent.column.index.IndexTabList;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.params.IndexColumnImportParam;
import com.hotent.column.persistence.dao.SysIndexColumnDao;
import com.hotent.column.persistence.manager.AuthorityManager;
import com.hotent.column.persistence.manager.PortalWeixinMaterialManager;
import com.hotent.column.persistence.manager.SysIndexColumnManager;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.job.model.PlanObject;
import com.hotent.sys.constants.CategoryConstants;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysCategoryManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.manager.SysUserAppManager;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.sys.persistence.model.SysCategory;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.sys.persistence.model.SysUserApp;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserGroupService;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="sysIndexColumnManager")
public class SysIndexColumnManagerImpl
extends BaseManagerImpl<SysIndexColumnDao, SysIndexColumn>
implements SysIndexColumnManager {
    @Resource
    ServiceClient serviceClient;
    @Resource
    AuthorityManager authorityManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    FormFeignService formFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    MultiTenantHandler multiTenantHandler;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysIndexColumnManager sysIndexColumnService;
    @Resource
    IUserGroupService ig;
    @Resource
    PortalWeixinMaterialManager portalWeixinMaterialManager;
    @Resource
    FileService fileService;
    @Resource
    SysUserAppManager sysUserAppManager;
    @Resource
    SysAppManager sysAppManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BaseContext baseContext;
    @Resource
    SaaSConfig saasConfig;
    @Resource
    BpmModelFeignService bpmModelFeignService;
    private static final String FILE_NAME = "indexColumns.json";
    private final GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine();

    @Override
    public List<SysIndexColumn> getHashRightColumnList(QueryFilter<SysIndexColumn> filter, Map<String, Object> params, Boolean isParse, short type, IUser user) throws Exception {
        List<SysIndexColumn> list;
        try (MultiTenantIgnoreResult ignored = MultiTenantHandler.setThreadLocalIgnore();){
            if (this.saasConfig.isEnable()) {
                filter.addFilter(this.multiTenantHandler.getTenantIdColumn(), Arrays.asList("-1", user.getTenantId()), QueryOP.IN);
            }
            list = this.getByUserIdFilter(type, "-1", user.getTenantId());
        }
        if (isParse.booleanValue()) {
            this.parseList(list, params);
        }
        return list;
    }

    private void parseList(List<SysIndexColumn> list, Map<String, Object> params) throws Exception {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (SysIndexColumn sysIndexColumn : list) {
            String templateHtml = this.parseTemplateHtml(sysIndexColumn, params);
            sysIndexColumn.setTemplateHtml(templateHtml);
        }
    }

    public List<SysIndexColumn> getByUserIdFilter(short type, String ... tenantIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap map = new HashMap();
        params.put("relationMap", map);
        try {
            Map<String, Set<String>> authMap = this.authorityManager.getUserRightMap();
            ArrayNode array = this.ucFeignService.getCurrentUserAuthOrgLayout(ContextUtil.getCurrentUserId());
            if (BeanUtils.isNotEmpty((Object)array)) {
                HashSet<String> authOrgIdList = new HashSet<String>();
                for (JsonNode jsonNode : array) {
                    ObjectNode node = (ObjectNode)jsonNode;
                    authOrgIdList.add(node.get("orgId").asText());
                }
                authMap.put("auth_org", authOrgIdList);
            }
            params.put("relationMap", authMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params.put("objType", "indexColumn");
        params.put("isPublic", type);
        params.put("tenantIds", Arrays.asList(tenantIds));
        return ((SysIndexColumnDao)this.baseMapper).getByUserIdFilter(params);
    }

    public String parseTemplateHtml(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        ObjectNode json = this.parseTemplateJSON(sysIndexColumn, params);
        return json.get("html").asText();
    }

    private String parserHtml(String html, SysIndexColumn sysIndexColumn, PageBean pageBean, Map<String, Object> params) throws Exception {
        if (StringUtil.isEmpty((String)html)) {
            return "";
        }
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements els = doc.body().children();
        if (BeanUtils.isEmpty((Object)els)) {
            return doc.body().html();
        }
        Element el = els.get(0);
        el.attr("template-alias", sysIndexColumn.getAlias());
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        for (String key : params.keySet()) {
            json.set(key, JsonUtil.toJsonNode((Object)params.get(key)));
        }
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            json.put("currentPage", pageBean.getPage());
            json.put("pageSize", pageBean.getPageSize());
        }
        el.attr("template-params", json.toString());
        html = doc.body().html();
        return html;
    }

    public String parseTemplateHtmlJSON(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        ObjectNode json = this.parseTemplateJSON(sysIndexColumn, params);
        return json.toString();
    }

    public ObjectNode parseTemplateJSON(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        String dataFrom = sysIndexColumn.getDataFrom();
        String html = sysIndexColumn.getTemplateHtml();
        html = Base64.getFromBase64((String)html);
        String colType = sysIndexColumn.getColType();
        short dataMode = sysIndexColumn.getDataMode();
        String dataParam = sysIndexColumn.getDataParam();
        Object data = null;
        try {
            Class<?>[] parameterTypes = this.getParameterTypes(dataParam, params);
            Object[] param = this.getDataParam(dataParam, params);
            if (SysIndexColumn.DATA_MODE_SERVICE == dataMode) {
                data = this.getModelByHandler(dataFrom, param, parameterTypes);
            } else if (SysIndexColumn.DATA_MODE_QUERY == dataMode) {
                String alias = sysIndexColumn.getDataFrom();
                data = this.formFeignService.getQueryPage(alias);
            } else if (SysIndexColumn.DATA_MODE_WEBSERVICE == dataMode) {
                data = this.callWebService(dataFrom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Long height = BeanUtils.isEmpty((Object)sysIndexColumn.getColHeight()) ? 320L : sysIndexColumn.getColHeight();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("alias", sysIndexColumn.getAlias());
        model.put("title", sysIndexColumn.getName());
        model.put("url", sysIndexColumn.getColUrl());
        model.put("height", height);
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty((Object)colType) && SysIndexColumnEnum.ColnumType.HT_STATISTICAL_CHART.getValue().equals(colType) && BeanUtils.isNotEmpty((Object)data)) {
            json.set("option", JsonUtil.toJsonNode((Object)data));
        }
        json.put("isRefresh", sysIndexColumn.getSupportRefesh());
        json.put("refreshTime", sysIndexColumn.getRefeshTime());
        json.put("show", sysIndexColumn.getShowEffect());
        json.put("type", colType);
        json.put("height", height);
        json.put("html", html);
        if (BeanUtils.isNotEmpty((Object)data)) {
            json.set("data", JsonUtil.toJsonNode((Object)data));
        }
        json.set("model", JsonUtil.toJsonNode(model));
        json.put("requestType", sysIndexColumn.getRequestType());
        json.put("dataParam", sysIndexColumn.getDataParam());
        json.put("dataFrom", sysIndexColumn.getDataFrom());
        return json;
    }

    private ArrayNode getArrayParams(String dataParam, Object[] param, Class<?>[] parameterTypes) {
        ObjectMapper mapper = JsonUtil.getMapper();
        ArrayNode array = mapper.createArrayNode();
        if (StringUtil.isNotEmpty((String)dataParam)) {
            try {
                JsonNode paramArray = JsonUtil.toJsonNode((String)dataParam);
                for (int i = 0; i < paramArray.size(); ++i) {
                    ObjectNode obj = (ObjectNode)paramArray.get(i);
                    obj.set("value", JsonUtil.toJsonNode((Object)param[i]));
                    obj.put("type", parameterTypes[i].getCanonicalName());
                    array.add((JsonNode)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return array;
    }

    private String parseByStringTemplate(Object obj, String templateSource) throws TemplateException, IOException {
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        StringTemplateLoader loader = new StringTemplateLoader();
        cfg.setTemplateLoader((TemplateLoader)loader);
        cfg.setClassicCompatible(true);
        loader.putTemplate("freemaker", templateSource);
        Template template = cfg.getTemplate("freemaker");
        StringWriter writer = new StringWriter();
        template.process(obj, (Writer)writer);
        return writer.toString();
    }

    private PageBean handerPageBean(Object data) {
        PageBean pageBean = null;
        try {
            if (data instanceof PageList) {
                pageBean = new PageBean();
                PageList pageList = (PageList)data;
                int page = (int)pageList.getPage();
                int pageSize = (int)pageList.getPageSize();
                pageBean.setPage(page);
                pageBean.setPageSize(pageSize);
            } else if (data instanceof IndexTabList) {
                IndexTabList indexTablist = (IndexTabList)data;
                pageBean = this.getIndexTabPageBean(indexTablist);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageBean;
    }

    private PageBean getIndexTabPageBean(IndexTabList indexTablist) {
        if (BeanUtils.isEmpty((Object)indexTablist)) {
            return null;
        }
        return indexTablist.getPageBean();
    }

    private Class<?>[] getParameterTypes(String dataParam, Map<String, Object> params) throws Exception {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return new Class[0];
        }
        JsonNode jary = JsonUtil.toJsonNode((String)dataParam);
        Class[] parameterTypes = new Class[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            JsonNode json = jary.get(i);
            String type = "string";
            if (BeanUtils.isNotEmpty((Object)json.get("type"))) {
                type = json.get("type").toString();
            }
            parameterTypes[i] = BeanUtils.getParameterTypes((String)type);
        }
        return parameterTypes;
    }

    private Object[] getDataParam(String dataParam, Map<String, Object> params) {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return null;
        }
        ArrayNode jary = JsonUtil.getMapper().createArrayNode();
        Object[] args = new Object[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            Object val;
            ObjectNode json = (ObjectNode)jary.get(i);
            String name = json.get("name").asText();
            String type = json.get("type").asText();
            String mode = json.get("mode").asText();
            String value = json.get("value").asText();
            Object o = value;
            if ("1".equalsIgnoreCase(mode)) {
                o = params.get(name);
                if (JsonUtil.isEmpty((Object)o) && BeanUtils.isNotEmpty((Object)value)) {
                    o = value;
                }
            } else if ("2".equalsIgnoreCase(mode)) {
                o = this.groovyScriptEngine.executeString(value, params);
            }
            args[i] = val = StringUtil.parserObject((Object)o, (String)type);
        }
        return args;
    }

    private Object getModelByHandler(String handler, Object[] args, Class<?>[] parameterTypes) throws Exception {
        Method invokeMethod;
        Object model = null;
        if (StringUtil.isEmpty((String)handler)) {
            return null;
        }
        int rtn = SysIndexColumnManagerImpl.isHandlerValidNoCmd(handler, parameterTypes);
        if (rtn != 0) {
            return null;
        }
        String[] aryHandler = handler.split("[.]");
        if (aryHandler == null) {
            return null;
        }
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = AppUtil.getBean((String)beanId);
        if (serviceBean == null) {
            return null;
        }
        if (args == null || args.length == 0) {
            parameterTypes = new Class[]{};
        }
        if (BeanUtils.isEmpty((Object)(model = (invokeMethod = serviceBean.getClass().getDeclaredMethod(method, parameterTypes)).invoke(serviceBean, args)))) {
            model = null;
        }
        return model;
    }

    public static int isHandlerValidNoCmd(String handler, Class<?>[] parameterTypes) {
        Object serviceBean;
        if (!handler.contains(".")) {
            return -1;
        }
        String[] aryHandler = handler.split("[.]");
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        try {
            serviceBean = AppUtil.getBean((String)beanId);
        }
        catch (Exception ex) {
            return -2;
        }
        if (serviceBean == null) {
            return -2;
        }
        try {
            Method invokeMethod = serviceBean.getClass().getMethod(method, parameterTypes);
            if (invokeMethod != null) {
                return 0;
            }
            return -3;
        }
        catch (NoSuchMethodException e) {
            return -3;
        }
        catch (Exception e) {
            return -4;
        }
    }

    @Override
    public SysIndexColumn getByColumnAlias(String alias) {
        SysIndexColumn column = ((SysIndexColumnDao)this.baseMapper).getByColumnAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)column))) {
            boolean hasRight = this.sysAuthUserManager.hasRights(column.getId());
            column.setDisplayRights(hasRight);
        }
        return column;
    }

    @Override
    public String getHtmlByColumnAlias(String alias, Map<String, Object> params) throws Exception {
        SysIndexColumn sysIndexColumn = this.getByColumnAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexColumn))) {
            return "";
        }
        return this.parseTemplateHtmlJSON(sysIndexColumn, params);
    }

    @Override
    public String parserDesignHtml(String designHtml, List<SysIndexColumn> columnList) {
        if (StringUtil.isEmpty((String)designHtml)) {
            return null;
        }
        Document doc = Jsoup.parseBodyFragment((String)designHtml);
        Elements els = doc.select("[template-alias]");
        for (Element el : els) {
            String value = el.attr("template-alias");
            String h = this.getSysIndexColumn(value, columnList);
            Element parent = el.parent();
            el.remove();
            parent.append(h);
        }
        designHtml = doc.body().html();
        return designHtml;
    }

    private String getSysIndexColumn(String alias, List<SysIndexColumn> columnList) {
        for (SysIndexColumn sysIndexColumn : columnList) {
            if (!alias.equals(sysIndexColumn.getAlias())) continue;
            return sysIndexColumn.getTemplateHtml();
        }
        return "";
    }

    @Override
    public Map<String, List<SysIndexColumn>> getColumnMap(List<SysIndexColumn> columnList) throws Exception {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(CategoryConstants.CAT_INDEX_COLUMN.key());
        SysType type = new SysType();
        type.setId(sysCategory.getId());
        type.setName(sysCategory.getName());
        type.setParentId("-1");
        type.setTypeKey(sysCategory.getGroupKey());
        List sysTypeList = this.sysTypeManager.getByGroupKey(CategoryConstants.CAT_INDEX_COLUMN.key());
        sysTypeList.add(type);
        HashMap<String, String> typeIdName = new HashMap<String, String>();
        for (SysType t : sysTypeList) {
            typeIdName.put(t.getId(), t.getName());
        }
        LinkedHashMap<String, List<SysIndexColumn>> map1 = new LinkedHashMap<String, List<SysIndexColumn>>();
        for (SysIndexColumn sysIndexColumn : columnList) {
            List<SysIndexColumn> list;
            String name;
            String catalog = sysIndexColumn.getCatalog();
            if (typeIdName.containsKey(catalog)) {
                name = (String)typeIdName.get(catalog);
                list = (List)map1.get(name);
                if (BeanUtils.isEmpty((Object)list)) {
                    list = new ArrayList();
                }
                list.add(sysIndexColumn);
                map1.put(name, list);
                continue;
            }
            name = "\u9ed8\u8ba4\u680f\u76ee";
            list = (ArrayList<SysIndexColumn>)map1.get(name);
            if (BeanUtils.isEmpty((Object)list)) {
                list = new ArrayList<SysIndexColumn>();
            }
            list.add(sysIndexColumn);
            map1.put(name, list);
        }
        return map1;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getColumnMap2(List<SysIndexColumn> columnList) {
        LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>();
        ArrayList publicList = new ArrayList();
        ArrayList privateList = new ArrayList();
        if (BeanUtils.isNotEmpty(columnList)) {
            for (SysIndexColumn item : columnList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", item.getName());
                map.put("snapshotId", item.getSnapshotId());
                map.put("alias", item.getAlias());
                if (1 == item.getIsInit()) {
                    publicList.add(map);
                    continue;
                }
                privateList.add(map);
            }
        }
        result.put("\u516c\u6709\u680f\u76ee", publicList);
        result.put("\u79c1\u6709\u680f\u76ee", privateList);
        return result;
    }

    @Override
    public Boolean isExistAlias(String alias, String id) {
        if (id == null || "0".equals(id)) {
            id = null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("alias", alias);
        params.put("id", id);
        Integer count = ((SysIndexColumnDao)this.baseMapper).isExistAlias(params);
        return count > 0;
    }

    public Object callWebService(String alias) throws Exception {
        try {
            HashMap params = new HashMap();
            InvokeResult result = this.serviceClient.invoke(alias, params);
            ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
            if (StringUtil.isNotEmpty((String)result.getJson())) {
                jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)result.getJson());
                try {
                    return JsonUtil.toJsonNode((Object)jsonObject.get("list"));
                }
                catch (Exception e) {
                    return jsonObject.get("list").asText();
                }
            }
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonUtil.getMapper().createObjectNode();
        }
    }

    @Override
    public List<SysIndexColumn> batchGetColumnAliases(String aliases) {
        if (StringUtil.isEmpty((String)aliases)) {
            return new ArrayList<SysIndexColumn>();
        }
        String[] ary = aliases.split(",");
        List hasRightsColIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("indexColumn");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (hasRightsColIds.size() == 0) {
            hasRightsColIds.add("");
        }
        hasRightsColIds.forEach(v -> stringBuffer.append("'" + v + "',"));
        List<SysIndexColumn> sysIndexColumns = ((SysIndexColumnDao)this.baseMapper).batchGetByColumnAliases(Arrays.asList(ary), String.join((CharSequence)",", stringBuffer.substring(0, stringBuffer.length() - 1)));
        if (ContextUtil.getCurrentUser().isAdmin() && BeanUtils.isNotEmpty(sysIndexColumns)) {
            sysIndexColumns.forEach(item -> item.setDisplayRights(true));
        }
        return sysIndexColumns;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createAndAuth(SysIndexColumn sysIndexColumn) throws Exception {
        this.create((Model)sysIndexColumn);
        String ownerNameJson = " [{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
        if (1 == sysIndexColumn.getIsInit()) {
            String filterTenantId = this.baseContext.getCurrentTenantId();
            ArrayNode tenantList = this.ucFeignService.getTenantAll();
            ArrayList<SysIndexColumn> sysIndexColumns = new ArrayList<SysIndexColumn>();
            for (JsonNode jsonNode : tenantList) {
                String id = JsonUtil.getString((JsonNode)jsonNode, (String)"id");
                if (!StringUtil.isNotEmpty((String)id) || StringUtil.equals((String)filterTenantId, (String)id)) continue;
                SysIndexColumn tempSysIndexColumn = new SysIndexColumn();
                BeanUtils.copyNotNullProperties((Object)((Object)tempSysIndexColumn), (Object)((Object)sysIndexColumn));
                tempSysIndexColumn.setTenantId(id);
                tempSysIndexColumn.setId(null);
                sysIndexColumns.add(tempSysIndexColumn);
            }
            if (BeanUtils.isNotEmpty(sysIndexColumns)) {
                try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                    this.saveBatch(sysIndexColumns);
                }
                List ids = sysIndexColumns.stream().map(SysIndexColumn::getId).collect(Collectors.toList());
                this.sysAuthUserManager.batchSaveRights(ids, "indexColumn", ownerNameJson);
            }
        }
        this.sysAuthUserManager.saveRights(sysIndexColumn.getId(), "indexColumn", ownerNameJson);
    }

    @Override
    public List<SysIndexColumn> getAllByLayoutType(QueryFilter queryFilter) {
        return ((SysIndexColumnDao)this.baseMapper).selectList(this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public void deleteByNewsParentId(String parentId) {
        ((SysIndexColumnDao)this.baseMapper).deleteByNewsParentId(parentId);
    }

    @Override
    public Map<String, Object> exportColumn(List<String> ids) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List sysIndexColumns = ((SysIndexColumnDao)this.baseMapper).selectBatchIds(ids);
        String folderPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempFile/ht_sysIndexColumn_tempFile/").replace("/", File.separator);
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (SysIndexColumn sysIndexColumn : sysIndexColumns) {
            if (!BeanUtils.isNotEmpty((Object)sysIndexColumn.getSnapshotId())) continue;
            FileInfo file = this.fileService.get(sysIndexColumn.getSnapshotId());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.fileService.downloadFile(file.getId(), outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            map.put(file.getId() + "." + file.getExtensionName(), inputStream);
            sysIndexColumn.setFileInfo(file);
        }
        if (BeanUtils.isEmpty((Object)sysIndexColumns)) {
            return new HashMap<String, Object>();
        }
        map.put(FILE_NAME, JsonUtil.toJson((Object)sysIndexColumns));
        this.addAuthMap(map, ids);
        return map;
    }

    private void addAuthMap(Map<String, Object> map, List<String> ids) throws IOException {
        HashMap<String, String> rights = new HashMap<String, String>(ids.size());
        for (String id : ids) {
            ArrayNode right = this.sysAuthUserManager.getRights(id, "indexColumn");
            rights.put(id, JsonUtil.toJsonString((Object)right));
        }
        map.put("sysAuthUser.json", JsonUtil.toJson(rights));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importFile(String unZipFilePath) throws Exception {
        try {
            IndexColumnImportParam importParam = this.readImportFile(unZipFilePath);
            for (SysIndexColumn column : importParam.getSysIndexColumns()) {
                SysIndexColumn byAlias = ((SysIndexColumnDao)this.baseMapper).getByColumnAlias(column.getAlias());
                if (byAlias == null) continue;
                return false;
            }
            this.importIndexColumn(unZipFilePath, importParam, null);
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                throw e;
            }
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    private IndexColumnImportParam readImportFile(String unzipFilePath) throws IOException {
        if (Base64.isBase64((String)unzipFilePath)) {
            unzipFilePath = Base64.getFromBase64((String)unzipFilePath);
        }
        String sysIndexColumnJson = FileUtil.readFile((String)(unzipFilePath + File.separator + FILE_NAME));
        String sysAuthUserJson = FileUtil.readFile((String)(unzipFilePath + File.separator + "sysAuthUser.json"));
        List sysIndexColumns = (List)JsonUtil.toBean((String)sysIndexColumnJson, (TypeReference)new TypeReference<List<SysIndexColumn>>(){});
        Map sysAuhUser = (Map)JsonUtil.toBean((String)sysAuthUserJson, (TypeReference)new TypeReference<Map<String, String>>(){});
        IndexColumnImportParam importParam = new IndexColumnImportParam();
        importParam.setSysIndexColumns(sysIndexColumns);
        importParam.setSysAuthUserMap(sysAuhUser);
        return importParam;
    }

    private void importIndexColumn(String unzipFilePath, IndexColumnImportParam importParam, String status) throws Exception {
        if (Base64.isBase64((String)unzipFilePath)) {
            unzipFilePath = Base64.getFromBase64((String)unzipFilePath);
        }
        for (SysIndexColumn sysIndexColumn : importParam.getSysIndexColumns()) {
            SysIndexColumn byAlias = ((SysIndexColumnDao)this.baseMapper).getByColumnAlias(sysIndexColumn.getAlias());
            if (BeanUtils.isNotEmpty((Object)sysIndexColumn.getFileInfo())) {
                FileInfo fileInfo = sysIndexColumn.getFileInfo();
                File file = new File(unzipFilePath + File.separator + fileInfo.getId() + "." + fileInfo.getExtensionName());
                if (file.exists() && file.isFile()) {
                    String suid = UniqueIdUtil.getSuid();
                    fileInfo.setId(suid);
                    try {
                        this.fileService.uploadFile(fileInfo, Files.newInputStream(file.toPath(), new OpenOption[0]));
                        sysIndexColumn.setSnapshotId(suid);
                    }
                    catch (Exception e) {
                        this.log.error("\u4e0a\u4f20\u95e8\u6237\u622a\u56fe\u5feb\u7167\u5931\u8d25", (Throwable)e);
                    }
                }
            }
            if (!"ignore".equals(status) && StringUtil.isNotEmpty((String)sysIndexColumn.getDataParam())) {
                String colType = sysIndexColumn.getColType();
                JsonNode paramNode = JsonUtil.toJsonNode((String)sysIndexColumn.getDataParam());
                if (StringUtil.isNotEmpty((String)colType) && "HtProcessPublicity".equals(colType) && paramNode.has("selectType")) {
                    ArrayList<String> listNotExists = new ArrayList<String>();
                    ArrayNode selectTypeNode = (ArrayNode)paramNode.get("selectType");
                    for (JsonNode defNode : selectTypeNode) {
                        String defKey = JsonUtil.getString((JsonNode)defNode, (String)"defKey", (String)"");
                        ObjectNode resultNode = this.bpmModelFeignService.getProcDefByDefKey(defKey);
                        if (resultNode != null) continue;
                        listNotExists.add(defKey);
                    }
                    if (CollUtil.isNotEmpty(listNotExists)) {
                        ObjectNode msgNode = JsonUtil.createObjectNode();
                        msgNode.put("defKey", JsonUtil.toJsonString(listNotExists));
                        msgNode.put("filePath", Base64.getBase64((String)unzipFilePath));
                        throw new BaseException(ResponseErrorEnums.COLUMN_PARAMS_NOT_EXIST, JsonUtil.toJsonString((Object)msgNode));
                    }
                }
            }
            if (BeanUtils.isEmpty((Object)((Object)byAlias))) {
                String oldId = sysIndexColumn.getId();
                sysIndexColumn.setId(UniqueIdUtil.getSuid());
                if (this.saasConfig.isEnable()) {
                    sysIndexColumn.setTenantId(null);
                }
                Map<String, String> sysAuthUserMap = importParam.getSysAuthUserMap();
                this.createColumnAndAuth(sysIndexColumn, sysAuthUserMap.getOrDefault(oldId, ""));
                continue;
            }
            if (!StringUtil.isNotEmpty((String)status) || !"cover".equals(status)) continue;
            BeanUtils.copyNotNullProperties((Object)((Object)byAlias), (Object)((Object)sysIndexColumn));
            if (this.saasConfig.isEnable()) {
                sysIndexColumn.setTenantId(null);
            }
            ((SysIndexColumnDao)this.baseMapper).updateById((Object)byAlias);
        }
    }

    private void createColumnAndAuth(SysIndexColumn sysIndexColumn, String authJson) throws Exception {
        if (StringUtil.isEmpty((String)authJson)) {
            authJson = "[{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
        }
        this.create((Model)sysIndexColumn);
        if (1 == sysIndexColumn.getIsInit()) {
            String filterTenantId = this.baseContext.getCurrentTenantId();
            ArrayNode tenantList = this.ucFeignService.getTenantAll();
            ArrayList<SysIndexColumn> sysIndexColumns = new ArrayList<SysIndexColumn>();
            for (JsonNode jsonNode : tenantList) {
                String id = JsonUtil.getString((JsonNode)jsonNode, (String)"id");
                if (!StringUtil.isNotEmpty((String)id) || StringUtil.equals((String)filterTenantId, (String)id)) continue;
                SysIndexColumn tempSysIndexColumn = new SysIndexColumn();
                BeanUtils.copyNotNullProperties((Object)((Object)tempSysIndexColumn), (Object)((Object)sysIndexColumn));
                tempSysIndexColumn.setTenantId(id);
                tempSysIndexColumn.setId(null);
                sysIndexColumns.add(tempSysIndexColumn);
            }
            if (BeanUtils.isNotEmpty(sysIndexColumns)) {
                try (MultiTenantIgnoreResult ignored = MultiTenantHandler.setThreadLocalIgnore();){
                    this.saveBatch(sysIndexColumns);
                }
                List ids = sysIndexColumns.stream().map(SysIndexColumn::getId).collect(Collectors.toList());
                this.sysAuthUserManager.batchSaveRights(ids, "indexColumn", authJson);
            }
        }
        this.sysAuthUserManager.saveRights(sysIndexColumn.getId(), "indexColumn", authJson);
    }

    @Override
    public CommonResult<String> saveSysIndexColumn(SysIndexColumn sysIndexColumn) {
        String message = null;
        try {
            String orgId;
            String alias = sysIndexColumn.getAlias();
            Boolean isExist = this.sysIndexColumnService.isExistAlias(sysIndexColumn.getAlias(), sysIndexColumn.getId());
            if (isExist.booleanValue()) {
                message = "\u680f\u76ee\u522b\u540d\uff1a[" + alias + "]\u5df2\u5b58\u5728";
                return new CommonResult(false, message, null);
            }
            if (!ContextUtil.getCurrentUser().isAdmin() && BeanUtils.isNotEmpty((Object)(orgId = ((IGroup)this.ig.getGroupsByUserIdOrAccount(ContextUtil.getCurrentUserId()).get(0)).getGroupId()))) {
                sysIndexColumn.setOrgId(orgId);
            }
            if (StringUtil.isZeroEmpty((String)sysIndexColumn.getId())) {
                sysIndexColumn.setId(UniqueIdUtil.getSuid());
                sysIndexColumn.setCreateTime(LocalDateTime.now());
                this.sysIndexColumnService.createAndAuth(sysIndexColumn);
                if (SysIndexColumnEnum.ColnumType.HT_OFFICIAL_ACCOUNTS.getValue().equals(sysIndexColumn.getColType())) {
                    this.portalWeixinMaterialManager.pullWeixinMaterialByAppIdAndSecret(sysIndexColumn.getAppid(), sysIndexColumn.getSecret());
                }
                message = "\u6dfb\u52a0\u680f\u76ee\u6210\u529f";
            } else {
                sysIndexColumn.setUpdateTime(LocalDateTime.now());
                this.sysIndexColumnService.update((Model)sysIndexColumn);
                message = "\u66f4\u65b0\u680f\u76ee\u6210\u529f";
            }
            this.externalUniteHaldle(sysIndexColumn);
            return new CommonResult(true, message, null);
        }
        catch (Exception e) {
            return new CommonResult(false, message + "," + e.getMessage(), null);
        }
    }

    private void externalUniteHaldle(SysIndexColumn sysIndexColumn) throws IOException, ParseException {
        if (!SysIndexColumnEnum.ColnumType.HT_OFFICIAL_ACCOUNTS.getValue().equals(sysIndexColumn.getColType())) {
            return;
        }
        ObjectNode node = JsonUtil.createObjectNode();
        Map map = JsonUtil.toMap((String)sysIndexColumn.getDataParam());
        String timeType = MapUtil.getStringIgnoreKey((Map)map, (String)"timeType", (String)"");
        String date = MapUtil.getStringIgnoreKey((Map)map, (String)"date", (String)"");
        if ("day".equals(timeType)) {
            date = "1900-01-01 " + date;
        }
        LocalDateTime localDateTime = DateFormatUtil.parse((String)date);
        int day = localDateTime.getDayOfMonth();
        int h = localDateTime.getHour();
        int m = localDateTime.getMinute();
        int s = localDateTime.getSecond();
        StringBuilder cronBuilder = new StringBuilder();
        cronBuilder.append(s).append(" ").append(m).append(" ").append(h).append(" ");
        switch (timeType) {
            case "day": {
                cronBuilder.append("* * ? *");
                break;
            }
            case "month": {
                cronBuilder.append(day).append(" * ? *");
                break;
            }
            default: {
                throw new BaseException("\u65f6\u95f4\u7c7b\u578btimeType\u53ea\u80fd\u662fday\u548cmonth");
            }
        }
        PlanObject planObject = new PlanObject();
        planObject.setType(6);
        planObject.setTimeInterval(cronBuilder.toString());
        node.put("description", JsonUtil.toJson((Object)planObject));
        node.put("jobName", "\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7d20\u6750\u5217\u8868");
        node.put("triggerName", sysIndexColumn.getId());
        this.portalFeignService.saveOrDeleteTrigger(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importColumn(MultipartHttpServletRequest request, HttpServletResponse response) {
        String fileDir;
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        boolean isRepeat = true;
        boolean isParamsNotExist = false;
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            isRepeat = this.importFile(uzPath);
            if (!isRepeat) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64((String)uzPath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                BaseException baseException = (BaseException)e;
                if (ResponseErrorEnums.COLUMN_PARAMS_NOT_EXIST.getCode().equals(baseException.getCode())) {
                    isParamsNotExist = true;
                    fileDir = new CommonResult(true, "paramsNotExist", (Object)baseException.getMessage());
                    return fileDir;
                }
            }
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && isRepeat && !isParamsNotExist && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }

    @Override
    public String parseByAlias(String alias, String params) throws Exception {
        Map<String, Object> param = this.getParameterValueMap(params);
        String data = "";
        try {
            data = this.sysIndexColumnService.getHtmlByColumnAlias(alias, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    public CommonResult<String> validateProcAnn(String defKey) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"COL_TYPE", (Object)2);
        qw.eq((Object)"is_public", (Object)2);
        qw.eq((Object)"col_url", (Object)("/completeView/" + defKey));
        List sysIndexColumns = ((SysIndexColumnDao)this.getBaseMapper()).selectList((Wrapper)qw);
        if (BeanUtils.isEmpty((Object)sysIndexColumns)) {
            return new CommonResult(false, "\u8be5\u6d41\u7a0b\u672a\u914d\u7f6e\u6d41\u7a0b\u516c\u793a");
        }
        for (SysIndexColumn column : sysIndexColumns) {
            if (!this.sysAuthUserManager.hasRights(column.getId())) continue;
            return new CommonResult(true, "");
        }
        return new CommonResult(false, "\u60a8\u65e0\u6743\u67e5\u770b\u8be5\u6d41\u7a0b\u7684\u6d41\u7a0b\u516c\u793a");
    }

    @Override
    public String getData(String alias, String params) throws Exception {
        Map<String, Object> param = this.getParameterValueMap(params);
        String data = "";
        try {
            data = this.sysIndexColumnService.getHtmlByColumnAlias(alias, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importFileData(String unZipFilePath, String status) {
        boolean isParamsNotExist = false;
        try {
            IndexColumnImportParam importParam = this.readImportFile(unZipFilePath);
            this.importIndexColumn(unZipFilePath, importParam, status);
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                BaseException baseException = (BaseException)e;
                if (ResponseErrorEnums.COLUMN_PARAMS_NOT_EXIST.getCode().equals(baseException.getCode())) {
                    isParamsNotExist = true;
                    CommonResult commonResult = new CommonResult(true, "paramsNotExist", (Object)baseException.getMessage());
                    return commonResult;
                }
            }
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            if (!isParamsNotExist) {
                try {
                    File formDir;
                    String unZipFilePathStr = Base64.getFromBase64((String)unZipFilePath);
                    if (StringUtil.isNotEmpty((String)unZipFilePathStr) && (formDir = new File(unZipFilePathStr)).exists()) {
                        FileUtil.deleteDir((File)formDir);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
                }
            }
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    private Map<String, Object> getParameterValueMap(String params) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)params)) {
            return map;
        }
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)params);
        Iterator it = node.fields();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode value = node.get(key);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public List<SysIndexColumn> getCurrentUserColumn(Short isPublic) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (isPublic != null) {
            queryWrapper.eq((Object)"IS_PUBLIC", (Object)isPublic);
        }
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return this.list((Wrapper)queryWrapper);
        }
        List indexColumnIds = this.sysAuthUserManager.getCurrentUserColumnIds();
        if (BeanUtils.isEmpty((Object)indexColumnIds)) {
            return Lists.newArrayList();
        }
        queryWrapper.in((Object)"ID", (Collection)indexColumnIds);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysIndexColumn> getByColumnType(String columnType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"COL_TYPE", (Object)columnType);
        return this.list((Wrapper)queryWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(String ... ids) {
        ArrayList<String> listId = new ArrayList<String>(Arrays.asList(ids));
        if (BeanUtils.isEmpty(listId)) {
            return;
        }
        List sysIndexColumns = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysIndexColumn::getId, Arrays.asList(ids))).eq(SysIndexColumn::getIsInit, (Object)1));
        if (BeanUtils.isNotEmpty((Object)sysIndexColumns)) {
            List removeAlias = sysIndexColumns.stream().map(SysIndexColumn::getAlias).collect(Collectors.toList());
            try {
                MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();
                Object object = null;
                try {
                    List removeList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysIndexColumn::getAlias, removeAlias)).notIn(SysIndexColumn::getTenantId, new Object[]{"-1"}));
                    if (BeanUtils.isNotEmpty((Object)removeList)) {
                        List collect = removeList.stream().map(SysIndexColumn::getId).collect(Collectors.toList());
                        listId.addAll(collect);
                    }
                }
                catch (Throwable removeList) {
                    object = removeList;
                    throw removeList;
                }
                finally {
                    if (setThreadLocalIgnore != null) {
                        if (object != null) {
                            try {
                                setThreadLocalIgnore.close();
                            }
                            catch (Throwable removeList) {
                                ((Throwable)object).addSuppressed(removeList);
                            }
                        } else {
                            setThreadLocalIgnore.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"COL_TYPE", (Object)SysIndexColumnEnum.ColnumType.HT_OFFICIAL_ACCOUNTS.getValue());
        queryWrapper.in((Object)"ID", listId);
        queryWrapper.select(new String[]{"ID"});
        List list = this.list((Wrapper)queryWrapper);
        for (SysIndexColumn sysIndexColumn : list) {
            this.portalFeignService.delTrigger(sysIndexColumn.getId());
        }
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            this.removeByIds(listId);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map<String, String>> getSnapshotIdByAlias(String alias) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("alias", (Object)alias, QueryOP.IN);
        List sysIndexColumns = this.queryNoPage(queryFilter);
        ArrayList<SysIndexColumn> updateSysIndexColumns = new ArrayList<SysIndexColumn>();
        if (BeanUtils.isNotEmpty((Object)sysIndexColumns)) {
            for (SysIndexColumn sysIndexColumn : sysIndexColumns) {
                if (StringUtil.isEmpty((String)sysIndexColumn.getSnapshotId())) {
                    String filePath = String.format("image/portal/%s.jpg", sysIndexColumn.getAlias());
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream(filePath);
                    if (stream == null) continue;
                    FileInfo defaultFile = this.getDefaultFile(Long.valueOf(stream.available()), sysIndexColumn.getName() + ".jpg", "admin", "1", "\u8d85\u7ea7\u7ba1\u7406\u5458");
                    String id = UniqueIdUtil.getSuid();
                    defaultFile.setId(id);
                    this.fileService.thumbnailUpload(defaultFile, stream);
                    result.put(sysIndexColumn.getAlias(), id);
                    sysIndexColumn.setSnapshotId(id);
                    updateSysIndexColumns.add(sysIndexColumn);
                    continue;
                }
                result.put(sysIndexColumn.getAlias(), sysIndexColumn.getSnapshotId());
            }
        }
        if (BeanUtils.isNotEmpty(updateSysIndexColumns)) {
            this.updateBatchById(updateSysIndexColumns);
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", result);
    }

    private FileInfo getDefaultFile(Long byteCount, String fileName, String account, String userId, String userFullname) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String fileExt = FileUtil.getFileExt((String)fileName);
        String filePath = "portalThumbnail" + File.separator + account + File.separator + year + File.separator + month + File.separator + UniqueIdUtil.getUId() + "." + fileExt;
        FileInfo file = new FileInfo();
        file.setByteCount(byteCount);
        if (BeanUtils.isNotEmpty((Object)byteCount)) {
            file.setNote(byteCount / 1024L + "KB");
        }
        file.setFileType("thumbnail");
        file.setFileName(fileName.replace("." + fileExt, ""));
        file.setExtensionName(fileExt);
        file.setFilePath(filePath);
        file.setCreateTime(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)userId)) {
            file.setCreateBy(userId);
        }
        if (StringUtil.isNotEmpty((String)userFullname)) {
            file.setCreatorName(userFullname);
        }
        return file;
    }

    @Override
    public PageList<SysApp> queryMyPcApp(String sysColumnAlias) {
        IUser currentUser = ContextUtil.getCurrentUser();
        List list = this.sysUserAppManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"ACCOUNT_", (Object)currentUser.getAccount())).eq((Object)"TYPE_", (Object)"pc")).eq((Object)"COLUMN_ALIAS_", (Object)sysColumnAlias));
        QueryFilter queryFilter = QueryFilter.build();
        List authIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap(SysAuthUser.BPMDEFUSER_OBJ_TYPE.SYS_APP);
        PageList appPageList = new PageList();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        if (BeanUtils.isNotEmpty((Object)list)) {
            List appAliasList = list.stream().map(SysUserApp::getAppAlias).collect(Collectors.toList());
            queryFilter.addFilter("alias", appAliasList, QueryOP.IN);
            appPageList = this.sysAppManager.query(queryFilter);
        } else {
            SysIndexColumn myApplication = this.getByColumnAlias(sysColumnAlias);
            if (BeanUtils.isNotEmpty((Object)((Object)myApplication))) {
                ObjectNode dataParam;
                ArrayList<String> appAliasList = new ArrayList<String>();
                try {
                    dataParam = (ObjectNode)JsonUtil.toJsonNode((String)myApplication.getDataParam());
                }
                catch (Exception e) {
                    throw new BaseException("\u680f\u76ee\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u680f\u76ee\u914d\u7f6e!");
                }
                if (dataParam.has("myApplication") && dataParam.get("myApplication") instanceof ArrayNode) {
                    ArrayNode dataParamList = (ArrayNode)dataParam.get("myApplication");
                    for (JsonNode jsonNode : dataParamList) {
                        String appAlias = jsonNode.asText().replace("\\", "");
                        appAliasList.add(appAlias);
                    }
                }
                if (BeanUtils.isNotEmpty(appAliasList)) {
                    queryFilter.addFilter("alias_", appAliasList, QueryOP.IN);
                    appPageList = this.sysAppManager.query(queryFilter);
                }
            }
        }
        List rows = appPageList.getRows();
        if (BeanUtils.isNotEmpty((Object)rows) && !currentUser.isAdmin()) {
            rows.removeIf(row -> !authIds.contains(row.getId()));
            appPageList.setRows(rows);
        }
        return appPageList;
    }

    @Override
    public PageList<SysIndexColumn> listJson(QueryFilter<SysIndexColumn> queryFilter) {
        return new PageList(((SysIndexColumnDao)this.baseMapper).queryList((IPage<SysIndexColumn>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SysIndexColumn>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }
}

