/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FluentUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.column.params.NewsItem;
import com.hotent.column.service.WeChatOfficialService;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeChatOfficialServiceImpl
implements WeChatOfficialService {
    @Value(value="${weixin.tokenUrl:https://api.weixin.qq.com/cgi-bin/token}")
    private String tokenUrl;
    @Value(value="${weixin.materialUrl:https://api.weixin.qq.com/cgi-bin/material/batchget_material}")
    private String materialUrl;
    @Value(value="${weixin.materialcountUrl:https://api.weixin.qq.com/cgi-bin/material/get_materialcount}")
    private String materialcountUrl;
    @Value(value="${weixin.freepublish.batchget:https://api.weixin.qq.com/cgi-bin/freepublish/batchget}")
    private String freepublishResutlUrl;

    @Override
    public List<NewsItem> getNews(String appid, String secret, String type, int offset, int count) throws Exception {
        ArrayList<NewsItem> result = new ArrayList<NewsItem>();
        List<NewsItem> newsItemDataFromMateriaUrl = this.getMaterial(appid, secret, type, offset, count);
        if (!"news".equals(type)) {
            return newsItemDataFromMateriaUrl;
        }
        List<NewsItem> newsItemDataFromFreepublishResutUrl = this.getFreepublishResut(appid, secret, offset, count);
        if (BeanUtils.isNotEmpty(newsItemDataFromMateriaUrl)) {
            result.addAll(newsItemDataFromMateriaUrl);
        }
        if (BeanUtils.isNotEmpty(newsItemDataFromFreepublishResutUrl)) {
            result.addAll(newsItemDataFromFreepublishResutUrl);
        }
        result = result.stream().sorted((r1, r2) -> r2.getCreateTime().compareTo(r1.getCreateTime())).limit(count).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<NewsItem> getMaterial(String appid, String secret, String type, int offset, int count) throws Exception {
        return this.getNewsItemData(appid, secret, type, offset, count, this.materialUrl);
    }

    @Override
    public List<NewsItem> getFreepublishResut(String appid, String secret, int offset, int count) throws Exception {
        return this.getNewsItemData(appid, secret, null, offset, count, this.freepublishResutlUrl);
    }

    private List<NewsItem> getNewsItemData(String appid, String secret, String type, int offset, int count, String requestUrl) throws Exception {
        ArrayList<NewsItem> news = new ArrayList<NewsItem>();
        WeChatOfficialServiceImpl bean = (WeChatOfficialServiceImpl)AppUtil.getBean(this.getClass());
        String token = bean.getAccessToken(appid, secret);
        String curMaterialUrlUrl = requestUrl + "?access_token=" + token;
        ObjectNode params = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)type)) {
            params.put("type", type);
        }
        params.put("offset", offset);
        params.put("count", count > 20 ? 20 : count);
        String result = FluentUtil.post((String)curMaterialUrlUrl, null, (Object)params);
        JsonNode resultNode = JsonUtil.toJsonNode((String)result);
        if (resultNode.has("errcode") && resultNode.get("errcode").asInt() == 40001) {
            this.clearAccessTokenCacheByAppId(appid);
            return this.getNewsItemData(appid, secret, type, offset, count, requestUrl);
        }
        if (resultNode.has("item")) {
            ArrayNode items = (ArrayNode)resultNode.get("item");
            for (JsonNode item : items) {
                if (!item.has("content")) continue;
                LocalDateTime createTime = item.get("content").has("create_time") ? LocalDateTime.ofEpochSecond(item.get("content").get("create_time").asLong(), 0, ZoneOffset.ofHours(8)) : null;
                LocalDateTime updateTime = item.get("content").has("update_time") ? LocalDateTime.ofEpochSecond(item.get("content").get("update_time").asLong(), 0, ZoneOffset.ofHours(8)) : null;
                ArrayNode news_item = (ArrayNode)item.get("content").get("news_item");
                for (JsonNode node : news_item) {
                    NewsItem newItem = new NewsItem();
                    newItem.setTitle(node.get("title").asText(""));
                    newItem.setAuthor(node.get("author").asText(""));
                    newItem.setDigest(node.get("digest").asText(""));
                    newItem.setContent(node.get("content").asText(""));
                    newItem.setThumb_media_id(node.get("thumb_media_id").asText(""));
                    newItem.setContent_source_url(node.get("content_source_url").asText(""));
                    newItem.setShow_cover_pic(node.get("show_cover_pic").asInt());
                    newItem.setUrl(node.get("url").asText(""));
                    newItem.setNeed_open_comment(node.get("need_open_comment").asInt());
                    newItem.setThumb_url(node.get("thumb_url").asText(""));
                    newItem.setOnly_fans_can_comment(node.get("only_fans_can_comment").asInt());
                    newItem.setCreateTime(createTime);
                    newItem.setUpdateTime(updateTime);
                    news.add(newItem);
                }
            }
        } else {
            throw new WorkFlowException("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u56fe\u6587\u7d20\u6750\u5931\u8d25\uff1a" + result);
        }
        return news;
    }

    private int getMaterialcount(String token, String type) throws Exception {
        int count = 0;
        String curMaterialcountUrl = this.materialcountUrl + "?access_token=" + token;
        String result = FluentUtil.get((String)curMaterialcountUrl, null);
        JsonNode resultNode = JsonUtil.toJsonNode((String)result);
        switch (type) {
            case "news": {
                count = resultNode.get("news_count").asInt(0);
                break;
            }
            case "voice": {
                count = resultNode.get("voice_count").asInt(0);
                break;
            }
            case "video": {
                count = resultNode.get("video_count").asInt(0);
                break;
            }
            case "image": {
                count = resultNode.get("image_count").asInt(0);
            }
        }
        return count;
    }

    @Override
    @Cacheable(value={"eip:weixin:token"}, key="#appid", firstCache=@FirstCache(expireTime=115, timeUnit=TimeUnit.MINUTES))
    public String getAccessToken(String appid, String secret) throws Exception {
        String curTokenUrl = this.tokenUrl + "?grant_type=%s&appid=%s&secret=%s";
        String result = FluentUtil.get((String)(curTokenUrl = String.format(curTokenUrl, "client_credential", appid, secret)), null);
        JsonNode node = JsonUtil.toJsonNode((String)result);
        if (node.has("access_token")) {
            return node.get("access_token").asText();
        }
        throw new WorkFlowException("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7access_token\u5931\u8d25\uff1a" + result);
    }

    @CacheEvict(value={"eip:weixin:token"}, key="#appid")
    protected void clearAccessTokenCacheByAppId(String appid) {
    }
}

