/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.column.model.PortalNewsTree;
import com.hotent.column.persistence.manager.PortalNewsTreeManager;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portalNewsTree/v1/"})
public class PortalNewsTreeController
extends BaseController<PortalNewsTreeManager, PortalNewsTree> {
    @PostMapping(value={"/createEntity"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> createEntity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody PortalNewsTree t) throws Exception {
        if (StringUtil.isEmpty((String)t.getId())) {
            t.setId(UniqueIdUtil.getSuid());
            t.setIntervalTime(BigDecimal.valueOf(3000L));
            String parentId = t.getParentId();
            PortalNewsTree portalNewsTree = (PortalNewsTree)((PortalNewsTreeManager)this.baseService).get((Serializable)((Object)parentId));
            t.setPath(portalNewsTree.getPath() + t.getId() + ".");
            ((PortalNewsTreeManager)this.baseService).create((Model)t);
        } else {
            ((PortalNewsTreeManager)this.baseService).updateEntity(t);
        }
        return new CommonResult();
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u6811\u5f62\u83dc\u5355")
    public List<PortalNewsTree> getTree() {
        List list = ((PortalNewsTreeManager)this.baseService).getAll();
        list = BeanUtils.listToTree((List)list);
        return list;
    }

    @GetMapping(value={"/issue"})
    @ApiOperation(value="\u628a\u7b2c\u4e09\u7ea7\u83dc\u5355\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee")
    public CommonResult<String> issue(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        return ((PortalNewsTreeManager)this.baseService).issue(id);
    }

    @GetMapping(value={"/mobileIssue"})
    @ApiOperation(value="\u628a\u7b2c\u4e09\u7ea7\u83dc\u5355\u53d1\u5e03\u6210\u9996\u9875\u680f\u76ee")
    public CommonResult<String> mobileIssue(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) {
        return ((PortalNewsTreeManager)this.baseService).mobileIssue(id);
    }

    @RequestMapping(value={"mobileRemove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u53d1\u5e03", httpMethod="DELETE", notes="\u53d6\u6d88\u53d1\u5e03")
    public CommonResult<String> mobileRemove(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) {
        return ((PortalNewsTreeManager)this.baseService).mobileRemove(id);
    }

    @PostMapping(value={"exportTree"})
    @ApiOperation(value="\u5bfc\u51fa\u5206\u7c7b", httpMethod="POST", notes="\u5bfc\u51fa\u5206\u7c7b")
    public void exportTree(HttpServletResponse response, HttpServletRequest request, @RequestBody PortalNewsTree portalNewsTree, @RequestParam String exportType) throws Exception {
        ((PortalNewsTreeManager)this.baseService).exportTree(request, response, portalNewsTree, exportType);
    }

    @PostMapping(value={"importTree"})
    @ApiOperation(value="\u5bfc\u5165\u5206\u7c7b", httpMethod="POST", notes="\u5bfc\u5165\u5206\u7c7b")
    public CommonResult<String> importTree(MultipartHttpServletRequest request, @RequestParam String classifyId) {
        return ((PortalNewsTreeManager)this.baseService).importTree(request, classifyId);
    }
}

