/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.model.PortalWeixinMaterial;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.persistence.manager.PortalWeixinMaterialManager;
import com.hotent.column.persistence.manager.SysIndexColumnManager;
import com.hotent.sys.persistence.model.SysApp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysIndexColumn/sysIndexColumn/v1/"})
@Api(tags={"\u95e8\u6237\u680f\u76ee"})
@ApiGroup(group={"group_portal"})
public class SysIndexColumnController
extends BaseController<SysIndexColumnManager, SysIndexColumn> {
    @Resource
    PortalWeixinMaterialManager portalWeixinMaterialManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysIndexColumn> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexColumn> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        if (BeanUtils.isEmpty((Object)sorter)) {
            sorter.add(new FieldSort("ID", Direction.DESC));
        }
        queryFilter.setSorter(sorter);
        return ((SysIndexColumnManager)this.baseService).listJson(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysIndexColumn getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (SysIndexColumn)((SysIndexColumnManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysIndexColumn getByAlias(@ApiParam(name="alias", value="\u4e3b\u952e", required=true) @RequestParam String alias) throws Exception {
        return ((SysIndexColumnManager)this.baseService).getByColumnAlias(alias);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            ((SysIndexColumnManager)this.baseService).removeByIds(aryIds);
            return new CommonResult(true, ThreadMsgUtil.getMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5220\u9664\u680f\u76ee\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u9996\u9875\u680f\u76ee", httpMethod="POST", notes="\u6dfb\u52a0\u6216\u66f4\u65b0\u9996\u9875\u680f\u76ee")
    public CommonResult<String> save(@ApiParam(name="sysIndexColumn", value="\u9996\u9875\u680f\u76ee") @RequestBody SysIndexColumn sysIndexColumn) throws Exception {
        return ((SysIndexColumnManager)this.baseService).saveSysIndexColumn(sysIndexColumn);
    }

    @RequestMapping(value={"getTemp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9884\u89c8\u6a21\u7248", httpMethod="POST", notes="\u9884\u89c8\u6a21\u7248")
    public String getTemp(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        String html = "";
        SysIndexColumn sysIndexColumn = (SysIndexColumn)((SysIndexColumnManager)this.baseService).get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexColumn))) {
            html = "<div template-alias=\"" + sysIndexColumn.getAlias() + "\"></div>";
        }
        return JsonUtil.toJson((Object)html);
    }

    @RequestMapping(value={"getData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6")
    public String getData(@ApiParam(name="alias", value="\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="params", value="\u53c2\u6570", required=true) @RequestParam String params) throws Exception {
        return ((SysIndexColumnManager)this.baseService).getData(alias, params);
    }

    @RequestMapping(value={"parseByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6")
    public String parseByAlias(@ApiParam(name="alias", value="\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="params", value="\u53c2\u6570", required=true) @RequestParam String params) throws Exception {
        return ((SysIndexColumnManager)this.baseService).parseByAlias(alias, params);
    }

    @RequestMapping(value={"getDatasByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6\uff08\u6839\u636e\u522b\u540d\u6279\u91cf\u83b7\u53d6\uff09", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6\uff08\u6839\u636e\u522b\u540d\u6279\u91cf\u83b7\u53d6\uff09")
    public List<SysIndexColumn> getDatasByAlias(@ApiParam(name="alias", value="\u522b\u540d(\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00)", required=true) @RequestBody String alias) throws Exception {
        return ((SysIndexColumnManager)this.baseService).batchGetColumnAliases(alias);
    }

    @GetMapping(value={"validateProcAnn"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u5224\u65ad\u8be5\u6d41\u7a0b\u516c\u793a\u5217\u8868\u80fd\u5426\u8bbf\u95ee", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u5224\u65ad\u8be5\u6d41\u7a0b\u516c\u793a\u5217\u8868\u80fd\u5426\u8bbf\u95ee")
    public CommonResult<String> validateProcAnn(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key") @RequestParam String defKey) throws Exception {
        return ((SysIndexColumnManager)this.baseService).validateProcAnn(defKey);
    }

    @PostMapping(value={"exportColumn"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u95e8\u6237\u680f\u76ee", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u95e8\u6237\u680f\u76ee")
    public void exportColumn(@ApiParam(name="ids", value="id\u96c6\u5408") @RequestBody List<String> ids, HttpServletResponse response) throws Exception {
        String fileName = "indexColumn_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        Map<String, Object> map = ((SysIndexColumnManager)this.baseService).exportColumn(ids);
        HttpUtil.downLoadFile((HttpServletResponse)response, map, (String)fileName);
    }

    @RequestMapping(value={"importColumn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u680f\u76ee", httpMethod="POST", notes="\u5bfc\u5165\u680f\u76ee")
    public CommonResult<String> importColumn(MultipartHttpServletRequest request, HttpServletResponse response) {
        return ((SysIndexColumnManager)this.baseService).importColumn(request, response);
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u680f\u76ee", httpMethod="POST", notes="\u5bfc\u5165\u680f\u76ee")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status) throws Exception {
        return ((SysIndexColumnManager)this.baseService).importFileData(unZipFilePath, status);
    }

    @GetMapping(value={"getMaterial"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u56fe\u6587\u7d20\u6750\u680f\u76ee", httpMethod="GET", notes="\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u56fe\u6587\u7d20\u6750\u680f\u76ee")
    public List<PortalWeixinMaterial> getMaterial(@ApiParam(name="columnId", value="\u680f\u76eeid") @RequestParam String columnId, @ApiParam(name="offset", value="offset") @RequestParam int offset, @ApiParam(name="count", value="count") @RequestParam int count) {
        SysIndexColumn column = (SysIndexColumn)((Object)((SysIndexColumnManager)this.baseService).getById((Serializable)((Object)columnId)));
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(offset), Integer.valueOf(count)));
        filter.addFilter("appid", (Object)column.getAppid(), QueryOP.EQUAL);
        PageList page = this.portalWeixinMaterialManager.query(filter);
        return page.getRows();
    }

    @GetMapping(value={"getCurrentUserColumn"})
    @ApiOperation(value="\u6839\u636e\u680f\u76ee\u7c7b\u578b\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u680f\u76ee", httpMethod="GET", notes="\u6839\u636e\u680f\u76ee\u7c7b\u578b\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u680f\u76ee")
    public List<SysIndexColumn> getCurrentUserColumn(@RequestParam(required=false) Short isPublic) {
        return ((SysIndexColumnManager)this.baseService).getCurrentUserColumn(isPublic);
    }

    @RequestMapping(value={"getSnapshotIdByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u83b7\u53d6\u7f29\u7565\u56fe", httpMethod="POST", notes="\u6839\u636e\u522b\u540d\u83b7\u53d6\u7f29\u7565\u56fe")
    public CommonResult<Map<String, String>> getSnapshotIdByAlias(@ApiParam(name="alias", value="\u522b\u540d\uff08\u591a\u4e2a\u7528\uff0c\u9694\u5f00\uff09", required=true) @RequestParam String alias) throws Exception {
        return ((SysIndexColumnManager)this.baseService).getSnapshotIdByAlias(alias);
    }

    @RequestMapping(value={"queryMyPcApp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6211\u7684\u5e94\u7528\u680f\u76ee\u67e5\u8be2\u6211\u7684\u5df2\u6388\u6743\u7684PC\u5e94\u7528", httpMethod="POST", notes="\u6839\u636e\u6211\u7684\u5e94\u7528\u680f\u76ee\u67e5\u8be2\u6211\u7684\u5df2\u6388\u6743\u7684PC\u5e94\u7528")
    public PageList<SysApp> queryMyPcApp(@ApiParam(name="\u6211\u7684\u5e94\u7528\u680f\u76ee\u522b\u540d", value="sysColumnAlias", required=true) @RequestParam String sysColumnAlias) {
        return ((SysIndexColumnManager)this.baseService).queryMyPcApp(sysColumnAlias);
    }

    @RequestMapping(value={"getListByIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7ids\u83b7\u53d6\u591a\u4e2a\u680f\u76ee\u4fe1\u606f", httpMethod="GET", notes="\u901a\u8fc7ids\u83b7\u53d6\u591a\u4e2a\u680f\u76ee\u4fe1\u606f")
    public List<SysIndexColumn> getListByIds(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) {
        if (BeanUtils.isEmpty((Object)ids)) {
            return new ArrayList<SysIndexColumn>();
        }
        return ((SysIndexColumnManager)this.baseService).listByIds(Arrays.asList(ids.split(",")));
    }
}

