/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.handler.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.column.enums.RepeatEnum;
import com.hotent.column.handler.RepeatExcision;
import com.hotent.column.handler.dto.HolidayTimeDTO;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EveryWorkDayExcision<T>
implements RepeatExcision<T> {
    Logger logger = LoggerFactory.getLogger(EveryWorkDayExcision.class);

    @Override
    public RepeatEnum getAgendaRepeatEnum() {
        return RepeatEnum.EVERY_WORK_DAY;
    }

    @Override
    public List<T> handle(T t, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        ArrayList result = Lists.newArrayList();
        if (!this.recalculateAgendaDay(t, startDateTime).booleanValue()) {
            return result;
        }
        if (!this.checkStartTime(t, startDateTime, endDateTime)) {
            return result;
        }
        List<HolidayTimeDTO> holidayTimeDTOList = this.getValidData();
        T currrent = t;
        for (int i = 0; i < 1000; ++i) {
            result.add(currrent);
            currrent = this.next(currrent, endDateTime, holidayTimeDTOList);
            if (currrent == null) break;
        }
        return result;
    }

    private T next(T source, LocalDateTime endDateTime, List<HolidayTimeDTO> holidayTimeDTOList) {
        T newOne = this.newInstance(source);
        this.setFieldDate(newOne, "startTime", this.getFieldDate(newOne, "startTime").plusDays(1L));
        this.setFieldDate(newOne, "endTime", this.getFieldDate(newOne, "endTime").plusDays(1L));
        if (!this.checkStartTime(newOne, this.getFieldDate(source, "startTime"), endDateTime)) {
            return null;
        }
        if (this.checkHoliday(this.getFieldDate(newOne, "startTime").toLocalDate(), holidayTimeDTOList)) {
            newOne = this.next(newOne, endDateTime, holidayTimeDTOList);
        }
        return newOne;
    }

    private boolean checkHoliday(LocalDate localDate, List<HolidayTimeDTO> holidayTimeDTOList) {
        for (HolidayTimeDTO holidayTimeDTO : holidayTimeDTOList) {
            if (holidayTimeDTO.getStartTime().toLocalDate().compareTo(localDate) > 0 || holidayTimeDTO.getEndTime().toLocalDate().compareTo(localDate) < 0) continue;
            return holidayTimeDTO.getType() == 0;
        }
        return localDate.getDayOfWeek().getValue() >= 6;
    }

    private List<HolidayTimeDTO> getValidData() {
        ArrayList result = Lists.newArrayList();
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        CommonResult validData = ucFeignService.getValidData();
        if (validData.getState().booleanValue()) {
            for (ObjectNode node : (List)validData.getValue()) {
                try {
                    HolidayTimeDTO holidayTimeDTO = (HolidayTimeDTO)JsonUtil.toBean((JsonNode)node, HolidayTimeDTO.class);
                    result.add(holidayTimeDTO);
                }
                catch (IOException e) {
                    this.logger.warn("HolidayTimeDTO\u8f6c\u6362\u5931\u8d25.");
                }
            }
        }
        return result;
    }
}

