/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.column.model.MessageNews;
import com.hotent.column.persistence.dao.MessageNewsDao;
import com.hotent.column.persistence.manager.AuthorityManager;
import com.hotent.column.persistence.manager.MessageNewsManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="messageNewsManager")
public class MessageNewsManagerImpl
extends BaseManagerImpl<MessageNewsDao, MessageNews>
implements MessageNewsManager {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    AuthorityManager authorityManager;
    @Resource
    PermissionCalc permssionCalc;

    public PageList<MessageNews> query(QueryFilter queryFilter) {
        QueryFilter filter;
        PageList pageList;
        List querys = queryFilter.getQuerys();
        boolean isp = false;
        for (QueryField queryField : querys) {
            if (!"2".equals(queryField.getValue()) || !"FStatus".equals(queryField.getProperty()) && !"F_status".equals(queryField.getProperty())) continue;
            isp = true;
            break;
        }
        IUser user = ContextUtil.getCurrentUser();
        if (isp && !user.isAdmin() && (pageList = super.query(filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)))).getTotal() > 0L) {
            List all = pageList.getRows();
            Map<String, Set<String>> authMap = this.authorityManager.getUserRightMap();
            ArrayList<String> authIds = new ArrayList<String>();
            for (MessageNews messageNews : all) {
                try {
                    if (!StringUtil.isNotEmpty((String)messageNews.getFCkqxsz())) continue;
                    ArrayNode authArray = (ArrayNode)JsonUtil.toJsonNode((String)messageNews.getFCkqxsz());
                    for (JsonNode jsonNode : authArray) {
                        if (!this.permssionCalc.hasRight(jsonNode.toString(), authMap)) continue;
                        authIds.add(messageNews.getId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (authIds.size() > 1000) {
                int sourceSize = authIds.size();
                int size = authIds.size() / 1000 + 1;
                for (int i = 0; i < size; ++i) {
                    ArrayList subset = new ArrayList();
                    for (int j = i * 1000; j < (i + 1) * 1000; ++j) {
                        if (j >= sourceSize) continue;
                        subset.add(authIds.get(j));
                    }
                    if (subset.size() <= 0) continue;
                    queryFilter.addFilter("id", subset, QueryOP.IN, FieldRelation.OR, "group01");
                }
            } else if (authIds.size() > 0) {
                queryFilter.addFilter("id", authIds, QueryOP.IN, FieldRelation.AND, "group01");
            }
        }
        return super.query(queryFilter);
    }

    @Override
    public CommonResult<String> publicMsgNews(String array) throws Exception {
        if (StringUtil.isNotEmpty((String)array)) {
            String[] ids;
            for (String id : ids = array.split(",")) {
                MessageNews msgNew = (MessageNews)this.get((Serializable)((Object)id));
                if (!BeanUtils.isNotEmpty((Object)((Object)msgNew))) continue;
                msgNew.setFStatus("2");
                this.update((Model)msgNew);
            }
        } else {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u9700\u53d1\u5e03\u7684\u65b0\u95fb\u516c\u544aid");
        }
        return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
    }
}

