/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.column.model.PortalCustomTodo;
import com.hotent.column.persistence.dao.PortalCustomTodoDao;
import com.hotent.column.persistence.manager.PortalCustomTodoManager;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PortalCustomTodoManagerImpl
extends BaseManagerImpl<PortalCustomTodoDao, PortalCustomTodo>
implements PortalCustomTodoManager {
    @Override
    public void handleList(List<PortalCustomTodo> list, Boolean isDone) throws Exception {
        ArrayList<PortalCustomTodo> needUpds = new ArrayList<PortalCustomTodo>();
        for (int i = list.size() - 1; i >= 0; --i) {
            PortalCustomTodo todo = list.get(i);
            if (!"1".equals(todo.getIsRepeat())) continue;
            if ("1".equals(todo.getStatus())) {
                String repeatType;
                switch (repeatType = todo.getRepeatType()) {
                    case "1": {
                        this.checkRepeatTask(todo, needUpds);
                        break;
                    }
                    case "2": {
                        this.checkRepeatTask(todo, needUpds);
                        break;
                    }
                    case "3": {
                        this.checkRepeatTask(1440, todo, needUpds);
                        break;
                    }
                    case "4": {
                        this.checkRepeatTask(60, todo, needUpds);
                        break;
                    }
                    case "5": {
                        this.checkRepeatTask(1, todo, needUpds);
                        break;
                    }
                }
                if (BeanUtils.isNotEmpty((Object)isDone) && !isDone.booleanValue() && "1".equals(todo.getStatus())) {
                    list.remove(i);
                }
                if (!BeanUtils.isNotEmpty((Object)isDone) || !isDone.booleanValue() || !"0".equals(todo.getStatus())) continue;
                list.remove(i);
                continue;
            }
            if (!BeanUtils.isNotEmpty((Object)isDone) || !isDone.booleanValue()) continue;
            list.remove(i);
        }
        if (BeanUtils.isNotEmpty(needUpds)) {
            super.updateBatchById(needUpds);
        }
    }

    private void checkRepeatTask(PortalCustomTodo todo, List<PortalCustomTodo> needUpds) throws Exception {
        long repeatStartTime = TimeUtil.getTimeMillis((LocalDateTime)todo.getRepeatStartTime());
        long completeTime = TimeUtil.getTimeMillis((LocalDateTime)todo.getCompleteTime());
        int timeUnit = 4;
        if ("1".equals(todo.getRepeatType())) {
            timeUnit = 5;
        }
        while (repeatStartTime < completeTime) {
            repeatStartTime = TimeUtil.getNextTime((int)timeUnit, (int)1, (long)repeatStartTime);
        }
        if (repeatStartTime < TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())) {
            todo.setStatus("0");
            todo.setCompleteTime(null);
            todo.setUpdateTime(LocalDateTime.now());
            needUpds.add(todo);
        }
    }

    private void checkRepeatTask(int minuteConut, PortalCustomTodo todo, List<PortalCustomTodo> needUpds) throws Exception {
        long completeTime;
        int repeatTimes;
        long repeatStartTime = TimeUtil.getTimeMillis((LocalDateTime)todo.getRepeatStartTime());
        if (repeatStartTime + (long)(((repeatTimes = (int)(((completeTime = TimeUtil.getTimeMillis((LocalDateTime)todo.getCompleteTime())) - repeatStartTime) / (long)(60000 * minuteConut))) + 1) * 60 * 1000 * minuteConut) < TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now())) {
            todo.setStatus("0");
            todo.setCompleteTime(null);
            todo.setUpdateTime(LocalDateTime.now());
            needUpds.add(todo);
        }
    }
}

