/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.column.model.PortalNewsNoticeComment;
import com.hotent.column.persistence.dao.PortalNewsNoticeCommentDao;
import com.hotent.column.persistence.manager.PortalNewsNoticeCommentManager;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalNewsNoticeCommentManagerImpl
extends BaseManagerImpl<PortalNewsNoticeCommentDao, PortalNewsNoticeComment>
implements PortalNewsNoticeCommentManager {
    @Resource
    UCFeignService ucFeignService;

    @Override
    public PortalNewsNoticeComment getDetail(String id) {
        return (PortalNewsNoticeComment)this.get((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void comment(PortalNewsNoticeComment comment) {
        if (AuthenticationUtil.getCurrentUserId() != null) {
            comment.setUserId(AuthenticationUtil.getCurrentUserId());
            comment.setUserAccount(ContextUtil.getCurrentUser().getAccount());
            if (StringUtil.isEmpty((String)comment.getNickName())) {
                comment.setNickName(ContextUtil.getCurrentUser().getFullname());
            }
        }
        if (StringUtil.isEmpty((String)comment.getTopId())) {
            comment.setTopId(comment.getPortalNewsNoticeId());
        }
        this.save((Object)comment);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteComment(List<String> ids) throws Exception {
        this.removeByIds(ids);
        this.remove((Wrapper)Wrappers.lambdaQuery().in(PortalNewsNoticeComment::getTopId, ids));
    }

    @Override
    public PageList<PortalNewsNoticeComment> queryComment(QueryFilter<PortalNewsNoticeComment> queryFilter) {
        queryFilter.getSorter().add(new FieldSort("create_time_", Direction.ASC));
        Map param = queryFilter.getParams();
        String userId = AuthenticationUtil.getCurrentUserId();
        param.put("userId", userId);
        IPage<PortalNewsNoticeComment> result = ((PortalNewsNoticeCommentDao)this.baseMapper).queryComment((IPage<PortalNewsNoticeComment>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PortalNewsNoticeComment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        String userIds = result.getRecords().stream().filter(comment -> StringUtil.isNotEmpty((String)comment.getUserId())).map(PortalNewsNoticeComment::getUserId).collect(Collectors.joining(","));
        if (StringUtil.isNotEmpty((String)userIds)) {
            ArrayNode userList = this.ucFeignService.getUserByIds(userIds);
            List userVoList = JSONUtil.toList((String)userList.toString(), UserFacade.class);
            Map<String, UserFacade> userVoMap = userVoList.stream().collect(Collectors.toMap(UserFacade::getId, e -> e));
            for (PortalNewsNoticeComment comment2 : result.getRecords()) {
                if (StringUtil.isEmpty((String)comment2.getUserId())) continue;
                UserFacade user = userVoMap.get(comment2.getUserId());
                if (user != null) {
                    comment2.setUserPhoto(user.getPhoto());
                }
                if (!StringUtil.isNotEmpty((String)userId) || !userId.equals(comment2.getUserId())) continue;
                comment2.setOwn(true);
            }
        }
        return new PageList(result);
    }

    @Override
    public boolean clearComment(String newsId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery().eq(PortalNewsNoticeComment::getPortalNewsNoticeId, (Object)newsId));
    }
}

