/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.column.model.PortalNewsNotice;
import com.hotent.column.model.PortalNewsNoticeRead;
import com.hotent.column.model.PortalNewsTag;
import com.hotent.column.model.PortalNewsTree;
import com.hotent.column.persistence.dao.PortalNewsNoticeDao;
import com.hotent.column.persistence.dao.PortalNewsTreeDao;
import com.hotent.column.persistence.manager.PortalNewsNoticeManager;
import com.hotent.column.persistence.manager.PortalNewsNoticeReadManager;
import com.hotent.column.persistence.manager.PortalNewsTagManager;
import com.hotent.column.persistence.manager.PortalNewsTreeManager;
import com.hotent.file.model.FileInfo;
import com.hotent.file.service.FileService;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class PortalNewsNoticeManagerImpl
extends BaseManagerImpl<PortalNewsNoticeDao, PortalNewsNotice>
implements PortalNewsNoticeManager {
    @Resource
    PortalNewsNoticeDao portalNewsNoticeDao;
    @Resource
    PortalNewsNoticeReadManager portalNewsNoticeReadManager;
    @Resource
    PortalNewsTreeManager portalNewsTreeManager;
    @Resource
    PortalNewsTreeDao portalNewsTreeDao;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    FileService fileService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    PortalNewsTagManager portalNewsTagManager;

    public boolean save(PortalNewsNotice entity) {
        int count;
        if (StringUtil.isNotEmpty((String)entity.getCode()) && (count = this.count((Wrapper)Wrappers.lambdaQuery().eq(PortalNewsNotice::getCode, (Object)entity.getCode()))) > 0) {
            throw new BaseException(String.format("\u7f16\u7801[%s]\u5df2\u7ecf\u5b58\u5728\uff01", entity.getCode()));
        }
        boolean save = super.save((Object)entity);
        this.sysAuthUserManager.createDefaultByObjType(entity.getId(), SysAuthUser.BPMDEFUSER_OBJ_TYPE.NEWS_NOTICE);
        return save;
    }

    @Override
    public List<PortalNewsNotice> getNews(String classifyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        LocalDateTime now = LocalDateTime.now();
        if (!classifyId.equals("all")) {
            ArrayList<String> treeIds = new ArrayList<String>();
            QueryWrapper treeWrapper = new QueryWrapper();
            treeWrapper.like(true, (Object)"PATH_", (Object)(classifyId + "."));
            List treeList = this.portalNewsTreeDao.selectList((Wrapper)treeWrapper);
            for (Object portalNewsTree : treeList) {
                treeIds.add(((PortalNewsTree)((Object)portalNewsTree)).getId());
            }
            if (!treeIds.isEmpty()) {
                queryWrapper.in((Object)"CLASSIFY_ID_", treeIds);
            }
        }
        queryWrapper.orderByDesc((Object)"PUBLISH_TIME_");
        List selectList = ((PortalNewsNoticeDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        IUser currentUser = ContextUtil.getCurrentUser();
        HashMap<String, Boolean> authMap = null;
        if (BeanUtils.isNotEmpty((Object)selectList) && BeanUtils.isNotEmpty((Object)currentUser) && !currentUser.isAdmin()) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object notice : selectList) {
                list.add(notice.getId());
            }
            List authList = this.sysAuthUserManager.getAuthorizeIdsByUserAndList(SysAuthUser.BPMDEFUSER_OBJ_TYPE.NEWS_NOTICE, list);
            if (BeanUtils.isNotEmpty((Object)authList)) {
                authMap = new HashMap<String, Boolean>();
                for (String id : authList) {
                    authMap.put(id, true);
                }
            }
        }
        ArrayList<PortalNewsNotice> respNotice = new ArrayList<PortalNewsNotice>();
        for (Object notice : selectList) {
            if (notice.getEndTime() != null && notice.getEndTime().isBefore(now) || authMap != null && !authMap.containsKey(notice.getId())) continue;
            respNotice.add((PortalNewsNotice)((Object)notice));
        }
        return respNotice;
    }

    @Override
    public void deleteByClassifyId(String classifyId) {
        this.portalNewsNoticeDao.deleteByClassifyId(classifyId);
    }

    @Override
    public void deleteNewsByParentId(String parentId) {
        this.portalNewsNoticeDao.deleteNewsByParentId(parentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String export(List<String> ids) throws Exception {
        String fileName = "newsNotice_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        if (BeanUtils.isEmpty(ids)) {
            throw new BaseException("\u4f20\u5165\u7684id\u96c6\u5408\u4e3a\u7a7a");
        }
        List portalNewsNotices = ((PortalNewsNoticeDao)this.baseMapper).selectBatchIds(ids);
        if (BeanUtils.isEmpty((Object)portalNewsNotices)) {
            throw new BaseException("\u6839\u636eid\u96c6\u5408\u67e5\u627e\uff0c\u672a\u67e5\u5230\u4efb\u4f55\u8bb0\u5f55");
        }
        String zipPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + fileName).replace("/", File.separator);
        String folderPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + fileName + "/").replace("/", File.separator);
        File folder = new File(folderPath);
        try {
            if (!folder.exists()) {
                folder.mkdirs();
            }
            for (PortalNewsNotice item : portalNewsNotices) {
                if (!"1".equals(String.valueOf(item.getType())) || !StringUtil.isNotEmpty((String)item.getRotatingDisplayPictures()) || item.getRotatingDisplayPictures().startsWith("http")) continue;
                FileInfo fileInfo = this.fileService.get(item.getRotatingDisplayPictures());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.fileService.downloadFile(item.getRotatingDisplayPictures(), byteArrayOutputStream);
                FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), (File)new File(folderPath + fileInfo.getId() + "." + fileInfo.getExtensionName()));
                item.setFileInfo(fileInfo);
            }
            FileUtils.write((File)new File(folderPath + "newsNotice.json"), (CharSequence)JsonUtil.toJsonString((Object)portalNewsNotices));
            ZipUtil.zip((String)zipPath);
        }
        finally {
            FileUtil.deleteDir((File)folder);
        }
        return zipPath;
    }

    @Override
    public CommonResult<String> importCheck(String uzPath, String classifyId) throws Exception {
        String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "newsNotice.json"));
        SaaSConfig saaSConfig = (SaaSConfig)AppUtil.getBean(SaaSConfig.class);
        boolean enable = saaSConfig.isEnable();
        List list = (List)JsonUtil.toBean((String)fileStr, List.class);
        PortalNewsTree portalNewsTree = (PortalNewsTree)this.portalNewsTreeManager.get((Serializable)((Object)classifyId));
        if (BeanUtils.isEmpty((Object)((Object)portalNewsTree))) {
            throw new BaseException("\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u5165\u7684\u5206\u7c7b");
        }
        ArrayList titles = Lists.newArrayList();
        for (Object o : list) {
            PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsNotice.class));
            titles.add(portalNewsNotice.getTitle());
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalNewsNotice::getClassifyId, (Object)classifyId)).in(PortalNewsNotice::getTitle, (Collection)titles);
        List portalNewsNoticeList = ((PortalNewsNoticeDao)this.getBaseMapper()).selectList((Wrapper)query);
        if (BeanUtils.isNotEmpty((Object)portalNewsNoticeList)) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u6709\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u662f\u5426\u8fdb\u884c\u8986\u76d6\uff1f");
        }
        this.importFile(uzPath, classifyId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    @Override
    public void importFile(String uzPath, String classifyId) {
        try {
            String treeType;
            String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "newsNotice.json"));
            SaaSConfig saaSConfig = (SaaSConfig)AppUtil.getBean(SaaSConfig.class);
            boolean enable = saaSConfig.isEnable();
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            PortalNewsTree portalNewsTree = (PortalNewsTree)this.portalNewsTreeManager.get((Serializable)((Object)classifyId));
            if (BeanUtils.isEmpty((Object)((Object)portalNewsTree))) {
                throw new BaseException("\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u5165\u7684\u5206\u7c7b");
            }
            if (portalNewsTree.getPath().startsWith("100")) {
                treeType = "1";
            } else if (portalNewsTree.getPath().startsWith("200")) {
                treeType = "2";
            } else {
                throw new BaseException("\u6240\u5c5e\u5206\u7c7b\u672a\u77e5");
            }
            Map<String, PortalNewsNotice> portalNewsNoticeByTitleMap = this.getPortalNewsNoticeByTitleMap(classifyId, list);
            for (Object o : list) {
                PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsNotice.class));
                if (treeType.equals(portalNewsNotice.getType().toString())) {
                    throw new BaseException("\u6240\u5c5e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u5bfc\u5165");
                }
                FileInfo fileInfo = portalNewsNotice.getFileInfo();
                if (BeanUtils.isNotEmpty((Object)fileInfo) && !StringUtil.isEmpty((String)fileInfo.getId())) {
                    String suid = UniqueIdUtil.getSuid();
                    File file = new File(uzPath + File.separator + fileInfo.getId() + "." + fileInfo.getExtensionName());
                    if (file.exists() && file.isFile()) {
                        fileInfo.setId(suid);
                        portalNewsNotice.setRotatingDisplayPictures(suid);
                        this.fileService.uploadFile(fileInfo, (InputStream)new FileInputStream(file));
                    }
                }
                portalNewsNotice.setClassifyPath(portalNewsTree.getPath());
                portalNewsNotice.setClassifyId(classifyId);
                portalNewsNotice.setClassifyName(portalNewsTree.getName());
                QueryFilter filter = QueryFilter.build();
                filter.addFilter("CLASSIFY_ID_", (Object)portalNewsTree.getId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("ID_", (Object)portalNewsNotice.getId(), QueryOP.EQUAL, FieldRelation.AND);
                PageList old = this.query(filter);
                if (BeanUtils.isEmpty((Object)old.getRows()) || old.getRows().isEmpty()) {
                    if (portalNewsNoticeByTitleMap.containsKey(portalNewsNotice.getTitle())) {
                        PortalNewsNotice oldNotice = portalNewsNoticeByTitleMap.get(portalNewsNotice.getTitle());
                        portalNewsNotice.setId(oldNotice.getId());
                        portalNewsNotice.setCreateTime(oldNotice.getCreateTime());
                        this.updateById((Object)portalNewsNotice);
                        continue;
                    }
                    portalNewsNotice.setId(UniqueIdUtil.getSuid());
                    if (enable) {
                        portalNewsNotice.setTenantId(null);
                    }
                    this.create((Model)portalNewsNotice);
                    continue;
                }
                this.updateById((Object)portalNewsNotice);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    private Map<String, PortalNewsNotice> getPortalNewsNoticeByTitleMap(String classifyId, List<Object> list) throws Exception {
        ArrayList titles = Lists.newArrayList();
        for (Object o : list) {
            PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)o), PortalNewsNotice.class));
            titles.add(portalNewsNotice.getTitle());
        }
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PortalNewsNotice::getClassifyId, (Object)classifyId)).in(PortalNewsNotice::getTitle, (Collection)titles);
        List portalNewsNotices = ((PortalNewsNoticeDao)this.getBaseMapper()).selectList((Wrapper)query);
        if (BeanUtils.isNotEmpty((Object)portalNewsNotices)) {
            Map<String, PortalNewsNotice> map = portalNewsNotices.stream().collect(Collectors.toMap(PortalNewsNotice::getTitle, m -> m, (key1, key2) -> key2));
            return map;
        }
        return Maps.newHashMap();
    }

    @Override
    public PageList<PortalNewsNotice> listNewsCurrentUserAuth(QueryFilter<PortalNewsNotice> queryFilter) {
        IUser currentUser = ContextUtil.getCurrentUser();
        queryFilter.withQuery(new QueryField("t1.END_TIME_", (Object)LocalDateTime.now(), QueryOP.GREAT, FieldRelation.OR, "endTime"));
        queryFilter.withQuery(new QueryField("t1.END_TIME_", null, QueryOP.IS_NULL, FieldRelation.OR, "endTime"));
        if (!currentUser.isAdmin()) {
            List authorizeIdsByUserMap = this.sysAuthUserManager.getAuthorizeIdsByUserMap(SysAuthUser.BPMDEFUSER_OBJ_TYPE.NEWS_NOTICE);
            queryFilter.getQuerys().add(new QueryField("t1.ID_", (Object)authorizeIdsByUserMap, QueryOP.IN));
        }
        QueryWrapper convert2Wrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage<PortalNewsNotice> portalNewsNoticeIPage = ((PortalNewsNoticeDao)this.baseMapper).listNewsCurrentUserAuth((IPage<PortalNewsNotice>)this.convert2IPage(queryFilter.getPageBean()), (QueryWrapper<PortalNewsNotice>)convert2Wrapper, currentUser.getUserId());
        this.mapTagName(portalNewsNoticeIPage.getRecords());
        return new PageList(portalNewsNoticeIPage);
    }

    private void mapTagName(List<PortalNewsNotice> notices) {
        Map<String, PortalNewsTag> map = this.portalNewsTagManager.getAll().stream().collect(Collectors.toMap(PortalNewsTag::getAlias, item -> item));
        for (PortalNewsNotice notice : notices) {
            String[] tags;
            if (BeanUtils.isEmpty((Object)notice.getTag())) continue;
            for (String tag : tags = notice.getTag().split(",")) {
                if (!map.containsKey(tag)) continue;
                notice.getTagNames().add(map.get(tag).getName());
                notice.getTagStyles().add(map.get(tag).getStyle());
            }
        }
    }

    @Override
    public void handlePortalNewsNoticeRead(String id) {
        String currentUserId = ContextUtil.getCurrentUserId();
        PortalNewsNoticeRead portalNewsNoticeRead = this.portalNewsNoticeReadManager.getCurUserReadByNewsId(id, currentUserId);
        if (BeanUtils.isEmpty((Object)((Object)portalNewsNoticeRead))) {
            portalNewsNoticeRead = new PortalNewsNoticeRead();
            portalNewsNoticeRead.setId(UniqueIdUtil.getSuid());
            portalNewsNoticeRead.setPortalNewsNoticeId(id);
            portalNewsNoticeRead.setUserId(currentUserId);
            try {
                this.portalNewsNoticeReadManager.save((Object)portalNewsNoticeRead);
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
    }

    @Override
    public PortalNewsNotice getNewsById(String id, Boolean isRead) {
        JsonNode updateUser;
        JsonNode createUser;
        PortalNewsNotice portalNewsNotice = (PortalNewsNotice)this.get((Serializable)((Object)id));
        portalNewsNotice.setViewCount(portalNewsNotice.getViewCount() + 1L);
        if (StringUtil.isNotEmpty((String)portalNewsNotice.getCreateBy()) && BeanUtils.isNotEmpty((Object)(createUser = (JsonNode)this.ucFeignService.getUserById(portalNewsNotice.getCreateBy()).getValue())) && createUser.has("fullname")) {
            portalNewsNotice.setCreateByName(createUser.get("fullname").asText());
        }
        if (StringUtil.isNotEmpty((String)portalNewsNotice.getUpdateBy()) && BeanUtils.isNotEmpty((Object)(updateUser = (JsonNode)this.ucFeignService.getUserById(portalNewsNotice.getUpdateBy()).getValue())) && updateUser.has("fullname")) {
            portalNewsNotice.setUpdateByName(updateUser.get("fullname").asText());
        }
        if (isRead != null && isRead.booleanValue()) {
            this.handlePortalNewsNoticeRead(id);
        }
        ((PortalNewsNoticeDao)this.baseMapper).incrementViewCount(id);
        return portalNewsNotice;
    }

    @Override
    public void setReadByIds(List<String> ids) {
        String currentUserId = ContextUtil.getCurrentUserId();
        if (CollUtil.isEmpty(ids) || StringUtil.isEmpty((String)currentUserId)) {
            return;
        }
        ArrayList<PortalNewsNoticeRead> newsNoticeReadList = new ArrayList<PortalNewsNoticeRead>();
        for (String id : ids) {
            PortalNewsNoticeRead portalNewsNoticeRead = this.portalNewsNoticeReadManager.getCurUserReadByNewsId(id, currentUserId);
            if (!BeanUtils.isEmpty((Object)((Object)portalNewsNoticeRead))) continue;
            portalNewsNoticeRead = new PortalNewsNoticeRead();
            portalNewsNoticeRead.setId(UniqueIdUtil.getSuid());
            portalNewsNoticeRead.setPortalNewsNoticeId(id);
            portalNewsNoticeRead.setUserId(currentUserId);
            newsNoticeReadList.add(portalNewsNoticeRead);
        }
        if (CollUtil.isNotEmpty(newsNoticeReadList)) {
            this.portalNewsNoticeReadManager.saveBatch(newsNoticeReadList);
        }
    }
}

