/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.column.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.column.model.PortalWeixinMaterial;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.column.params.NewsItem;
import com.hotent.column.persistence.dao.PortalWeixinMaterialDao;
import com.hotent.column.persistence.manager.PortalWeixinMaterialManager;
import com.hotent.column.persistence.manager.SysIndexColumnManager;
import com.hotent.column.service.WeChatOfficialService;
import dm.jdbc.util.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalWeixinMaterialManagerImpl
extends BaseManagerImpl<PortalWeixinMaterialDao, PortalWeixinMaterial>
implements PortalWeixinMaterialManager {
    @Resource
    WeChatOfficialService weChatOfficialService;
    @Resource
    SysIndexColumnManager sysIndexColumnService;
    @Resource
    PortalWeixinMaterialDao portalWeixinMaterialDao;

    @Override
    @Transactional
    public CommonResult<String> pullWeixinMaterial() throws Exception {
        try {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.isNotNull((Object)"APPID_");
            List columns = this.sysIndexColumnService.list((Wrapper)wrapper);
            if (BeanUtils.isNotEmpty((Object)columns) && columns.size() > 0) {
                HashSet appIds = new HashSet();
                for (SysIndexColumn column : columns) {
                    if (!StringUtil.isNotEmpty((String)column.getAppid()) || !StringUtil.isNotEmpty((String)column.getSecret()) || appIds.contains(column.getAppid())) continue;
                    List<NewsItem> items = this.weChatOfficialService.getNews(column.getAppid(), column.getSecret(), "news", 0, 20);
                    this.handleMaterial(column.getAppid(), items);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u62c9\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u62c9\u53d6\u6210\u529f\uff01");
    }

    @Override
    @Transactional
    public CommonResult<String> pullWeixinMaterialByAppIdAndSecret(String appId, String secret) throws Exception {
        try {
            if (StringUtil.isEmpty((String)appId) || StringUtil.isEmpty((String)secret)) {
                return CommonResult.error((String)"appId \u6216 secret\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            List<NewsItem> items = this.weChatOfficialService.getNews(appId, secret, "news", 0, 20);
            this.handleMaterial(appId, items);
        }
        catch (Exception e) {
            return CommonResult.error((String)("\u62c9\u53d6\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return new CommonResult(true, "\u62c9\u53d6\u6210\u529f\uff01");
    }

    @Transactional
    private void handleMaterial(String appId, List<NewsItem> items) {
        ((PortalWeixinMaterialDao)this.baseMapper).delByAppid(appId);
        if (BeanUtils.isNotEmpty(items)) {
            List<PortalWeixinMaterial> list = this.trans(appId, items);
            this.saveBatch(list);
        }
    }

    private List<PortalWeixinMaterial> trans(String appId, List<NewsItem> items) {
        LocalDateTime pullTime = LocalDateTime.now();
        ArrayList<PortalWeixinMaterial> materials = new ArrayList<PortalWeixinMaterial>();
        for (NewsItem newsItem : items) {
            PortalWeixinMaterial material = new PortalWeixinMaterial();
            material.setId(UniqueIdUtil.getSuid());
            material.setAppid(appId);
            material.setAuthor(newsItem.getAuthor());
            material.setContent(newsItem.getContent());
            material.setTitle(newsItem.getTitle());
            material.setDigest(newsItem.getDigest());
            material.setContentSourceUrl(newsItem.getContent_source_url());
            material.setThumbMediaId(newsItem.getThumb_media_id());
            material.setThumbUrl(newsItem.getThumb_url());
            material.setShowCoverPic(newsItem.getShow_cover_pic());
            material.setUrl(newsItem.getUrl());
            material.setNeedOpenComment(newsItem.getNeed_open_comment());
            material.setOnlyFansCanComment(newsItem.getOnly_fans_can_comment());
            material.setCreateTime(newsItem.getCreateTime());
            material.setUpdateTime(newsItem.getUpdateTime());
            material.setPullTime(pullTime);
            materials.add(material);
        }
        return materials;
    }
}

