/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.hotent.base.dao.CommonDao;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.documentation.dao.DocumentationTableDao;
import com.hotent.documentation.handler.ExecutorHandler;
import com.hotent.documentation.manager.DocumentationConfigManager;
import com.hotent.documentation.manager.DocumentationTableManager;
import com.hotent.documentation.model.DocumentationConfig;
import com.hotent.documentation.model.DocumentationTable;
import com.hotent.documentation.util.ExecutorUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentationTableManagerImpl
extends BaseManagerImpl<DocumentationTableDao, DocumentationTable>
implements DocumentationTableManager {
    @Resource
    private CommonDao commonDao;
    @Resource
    private DocumentationConfigManager configManager;
    @Resource
    private DatabaseContext databaseContext;
    @Value(value="${configFormData.limitNumber}")
    private int limitNumber;

    @Override
    public DocumentationTable getDetail(String id) {
        DocumentationTable documentationTable = (DocumentationTable)this.get((Serializable)((Object)id));
        return documentationTable;
    }

    @Override
    @Transactional
    public void createOrUpdate(DocumentationTable documentationTable) {
        documentationTable.setUpdateTime(LocalDateTime.now());
        documentationTable.setUpdateBy(ContextUtil.getCurrentUserId());
        this.saveOrUpdate((Object)documentationTable);
    }

    @Override
    public String checkSql(DocumentationTable table) {
        ExecutorHandler handler = ExecutorUtil.getExecutorHandler(this.databaseContext.getDbType());
        List maps = this.commonDao.documentationQuery(handler.getSql(table, null));
        if (BeanUtils.isNotEmpty((Object)maps)) {
            return "\u6821\u9a8c\u6210\u529f,\u6570\u636e\u4e00\u5171\u6709 " + maps.size() + " \u6761";
        }
        return "\u6821\u9a8c\u6210\u529f\uff0c\u6570\u636e\u4e3a\u7a7a";
    }

    @Override
    public boolean containsSystem(List<String> asList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(DocumentationTable::getId, new Object[]{"1"});
        List list = this.list((Wrapper)wrapper);
        return BeanUtils.isNotEmpty((Object)list);
    }

    @Override
    public String getTargetName(DocumentationTable table, String time) {
        return "TRANSFER_" + time.replaceAll("-", "") + "_" + table.getTableName();
    }

    @Override
    public void executeSync() throws Exception {
        List<DocumentationTable> list = this.getMainTables();
        ExecutorHandler handler = ExecutorUtil.getExecutorHandler(this.databaseContext.getDbType());
        DocumentationConfig config = this.configManager.getDetail("1");
        boolean deleteData = "1".equals(config.getDeleteData());
        for (DocumentationTable table : list) {
            this.syncList(handler, config, this.limitNumber, deleteData, table);
        }
    }

    private void syncList(ExecutorHandler handler, DocumentationConfig config, int limitNumber, boolean deleteData, DocumentationTable table) throws Exception {
        List<DocumentationTable> subTables = table.getSubList();
        if (BeanUtils.isNotEmpty(subTables)) {
            for (DocumentationTable subTable : subTables) {
                this.syncList(handler, config, limitNumber, deleteData, subTable);
            }
        }
        List<String> dataTimes = handler.getDataTimes(this.getMainTable(table), config);
        for (String time : dataTimes) {
            List<Map<String, Object>> dataSource = handler.getDataSource(table, time);
            boolean noError = true;
            int index = 0;
            int lastIndex = 0;
            do {
                lastIndex = (index + 1) * limitNumber;
                if (dataSource.size() <= lastIndex) {
                    lastIndex = dataSource.size();
                }
                List<Map<String, Object>> list = dataSource.subList(index * limitNumber, lastIndex);
                try {
                    handler.batchInset(list, table, config, deleteData, time);
                }
                catch (Exception e) {
                    if (e instanceof BaseException) {
                        throw e;
                    }
                    handler.insertErrorLog(list, table, e.getMessage(), config, deleteData, time);
                    noError = false;
                }
                ++index;
            } while (lastIndex != dataSource.size() && noError);
        }
    }

    private DocumentationTable getMainTable(DocumentationTable table) {
        if (BeanUtils.isEmpty((Object)((Object)table.getParentTable()))) {
            return table;
        }
        return this.getMainTable(table.getParentTable());
    }

    private List<DocumentationTable> getMainTables() {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(DocumentationTable::getStart, (Object)"1")).orderByAsc(DocumentationTable::getOrder);
        List list = this.list((Wrapper)wrapper);
        Map<String, DocumentationTable> map = list.stream().collect(Collectors.toMap(DocumentationTable::getId, item -> item));
        List<DocumentationTable> mainList = list.stream().filter(i -> "0".equals(i.getParentId())).sorted((o1, o2) -> Integer.compare(Integer.parseInt(StringUtil.isEmpty((String)o2.getOrder()) ? "0" : o2.getOrder()), Integer.parseInt(StringUtil.isEmpty((String)o1.getOrder()) ? "0" : o1.getOrder()))).collect(Collectors.toList());
        list.forEach(i -> {
            DocumentationTable parent = (DocumentationTable)((Object)((Object)map.get(i.getParentId())));
            if (BeanUtils.isNotEmpty((Object)((Object)parent))) {
                i.setParentTable(parent);
                List<DocumentationTable> subList = parent.getSubList();
                if (BeanUtils.isEmpty(subList)) {
                    subList = new ArrayList<DocumentationTable>();
                }
                subList.add((DocumentationTable)((Object)i));
                parent.setSubList(subList);
            }
        });
        list.forEach(i -> {
            List<DocumentationTable> subList = i.getSubList();
            if (BeanUtils.isNotEmpty(subList)) {
                List<DocumentationTable> collect = subList.stream().sorted((o1, o2) -> Integer.compare(Integer.parseInt(StringUtil.isEmpty((String)o2.getOrder()) ? "0" : o2.getOrder()), Integer.parseInt(StringUtil.isEmpty((String)o1.getOrder()) ? "0" : o1.getOrder()))).collect(Collectors.toList());
                i.setSubList(collect);
            }
        });
        return mainList;
    }

    @Override
    public void updateStatus(DocumentationTable documentationTable) {
        LambdaUpdateWrapper lambda = new UpdateWrapper().lambda();
        ((LambdaUpdateWrapper)lambda.eq(DocumentationTable::getId, (Object)documentationTable.getId())).set(DocumentationTable::getStart, (Object)documentationTable.getStart());
        this.update((Wrapper)lambda);
    }
}

