/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.util;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class BatchSaveUtil {
    private static final int BATCH_SIZE = 1000;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public <U, R> R batchUpdateOrInsert(Class<U> mapperClass, Function<U, R> function) {
        boolean i = true;
        SqlSession batchSqlSession = this.sqlSessionFactory.openSession();
        batchSqlSession.getConfiguration().setDefaultExecutorType(ExecutorType.BATCH);
        R result = null;
        try {
            Object mapper = batchSqlSession.getMapper(mapperClass);
            result = function.apply(mapper);
            batchSqlSession.flushStatements();
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        catch (Exception e) {
            batchSqlSession.rollback();
            throw new RuntimeException(e);
        }
        finally {
            batchSqlSession.close();
        }
        return result;
    }

    public <T, U, R> int batchUpdateOrInsert(List<T> data, Class<U> mapperClass, BiFunction<T, U, R> function) {
        int i = 1;
        batchSqlSession.getConfiguration().setDefaultExecutorType(ExecutorType.BATCH);
        try (SqlSession batchSqlSession = this.sqlSessionFactory.openSession();){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = data.size();
            for (T element : data) {
                function.apply(element, mapper);
                if (i % 1000 == 0 || i == size) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.commit(!TransactionSynchronizationManager.isSynchronizationActive());
        }
        return i - 1;
    }
}

