/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.StringUtil;
import com.hotent.documentation.handler.ExecutorHandler;
import com.hotent.documentation.manager.DocumentationTableManager;
import com.hotent.documentation.model.DocumentationTable;
import com.hotent.documentation.util.ExecutorUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documentationTable/v1/"})
@Api(tags={"\u6570\u636e\u5f52\u6863\u76ee\u6807\u6570\u636e"})
@ApiGroup(group={"group_portal"})
public class DocumentationTableController
extends BaseController<DocumentationTableManager, DocumentationTable> {
    @GetMapping(value={"/getDetail"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6570\u636e\u8be6\u60c5")
    public CommonResult<DocumentationTable> getDetail(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam(required=true) String id) throws Exception {
        return CommonResult.ok().value((Object)((DocumentationTableManager)this.baseService).getDetail(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="DocumentationTable", value="\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u5bf9\u8c61", required=true) @RequestBody DocumentationTable documentationTable) throws Exception {
        String msg = StringUtil.isEmpty((String)documentationTable.getId()) ? "\u6dfb\u52a0\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6210\u529f" : "\u66f4\u65b0\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u6210\u529f";
        ((DocumentationTableManager)this.baseService).createOrUpdate(documentationTable);
        return CommonResult.ok().message(msg);
    }

    @PostMapping(value={"/checkSql"})
    @ApiOperation(value="\u6821\u9a8csql", httpMethod="POST", notes="\u6821\u9a8csql")
    public CommonResult<String> checkSql(@ApiParam(name="DocumentationTable", value="\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u5bf9\u8c61", required=true) @RequestBody DocumentationTable documentationTable) throws Exception {
        String result = "";
        try {
            result = ((DocumentationTableManager)this.baseService).checkSql(documentationTable);
        }
        catch (Exception e) {
            return CommonResult.error().message("\u6821\u9a8c\u5931\u8d25");
        }
        return CommonResult.ok().message(result);
    }

    @GetMapping(value={"/getFields"})
    @ApiOperation(value="\u6839\u636e\u8868\u540d\u83b7\u53d6\u8868\u5b57\u6bb5", httpMethod="GET", notes="\u6839\u636e\u8868\u540d\u83b7\u53d6\u8868\u5b57\u6bb5")
    public CommonResult<List<Map<String, Object>>> getFields(@ApiParam(name="tableName", value="\u8868\u540d", required=true) @RequestParam String tableName) throws Exception {
        List<Map<String, Object>> fields = null;
        try {
            ExecutorHandler handler = ExecutorUtil.getExecutorHandler("mysql");
            fields = handler.getFields(tableName);
        }
        catch (Exception e) {
            return CommonResult.error().message("\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25");
        }
        CommonResult result = new CommonResult();
        result.setValue(fields);
        return result;
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteTableById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        DocumentationTable documentationTable = (DocumentationTable)((Object)((DocumentationTableManager)this.baseService).getById((Serializable)((Object)id)));
        if ("1".equals(documentationTable.getSystem())) {
            return CommonResult.error().message("\u7cfb\u7edf\u9ed8\u8ba4\u6570\u636e\u4e0d\u80fd\u5220\u9664");
        }
        boolean result = ((DocumentationTableManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            throw new BaseException(ResponseErrorEnums.FAIL_DELETE);
        }
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteTableByIds(String ... ids) {
        boolean contains = ((DocumentationTableManager)this.baseService).containsSystem(Arrays.asList(ids));
        if (!contains) {
            boolean result = ((DocumentationTableManager)this.baseService).removeByIds(Arrays.asList(ids));
            if (!result) {
                throw new BaseException(ResponseErrorEnums.FAIL_DELETE);
            }
            return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
        }
        return CommonResult.error().message("\u7cfb\u7edf\u9ed8\u8ba4\u6570\u636e\u4e0d\u80fd\u5220\u9664");
    }

    @PostMapping(value={"/executeSync"})
    @ApiOperation(value="\u6267\u884c\u540c\u6b65", httpMethod="POST", notes="\u6821\u9a8csql")
    public CommonResult<String> executeSync() {
        try {
            ((DocumentationTableManager)this.baseService).executeSync();
        }
        catch (Exception e) {
            return CommonResult.error().message(e.getMessage());
        }
        return CommonResult.ok().message("\u540c\u6b65\u6210\u529f");
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="\u4fee\u6539\u542f\u52a8\u72b6\u6001", httpMethod="POST", notes="\u4fee\u6539\u542f\u52a8\u72b6\u6001")
    public CommonResult<String> updateStatus(@ApiParam(name="DocumentationTable", value="\u540c\u6b65\u6570\u636e\u76ee\u6807\u8868\u5bf9\u8c61", required=true) @RequestBody DocumentationTable documentationTable) {
        ((DocumentationTableManager)this.baseService).updateStatus(documentationTable);
        return CommonResult.ok().message("\u4fee\u6539\u6210\u529f");
    }
}

