/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.handler;

import com.hotent.base.dao.CommonDao;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.documentation.handler.ExecutorHandler;
import com.hotent.documentation.manager.DocumentationErrorLogManager;
import com.hotent.documentation.manager.DocumentationTableManager;
import com.hotent.documentation.model.DocumentationConfig;
import com.hotent.documentation.model.DocumentationTable;
import com.hotent.documentation.util.BatchSaveUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractExecutorHandler
implements ExecutorHandler {
    @Resource
    protected DocumentationErrorLogManager errorLogManager;
    @Resource
    protected DocumentationTableManager tableManager;
    @Resource
    protected CommonDao commonDao;
    @Resource
    protected DatabaseContext databaseContext;
    @Resource
    private BatchSaveUtil batchSaveUtil;

    @Override
    public List<Map<String, Object>> getDataSource(DocumentationTable table, String time) {
        String sql = this.getSql(table, time);
        return this.commonDao.documentationQuery(sql);
    }

    @Override
    @Transactional
    public void deleteDataSource(DocumentationTable table, List<Map<String, Object>> dataSource) {
        List ids = dataSource.stream().map(i -> (String)i.get("ID_")).collect(Collectors.toList());
        this.commonDao.documentationBatchDelete(table.getTableName(), "id_", ids);
    }

    @Override
    public List<Map<String, Object>> getExist(List<Map<String, Object>> dataSource, DocumentationTable table, DocumentationConfig config, String time) {
        List ids = dataSource.stream().map(i -> (String)i.get("ID_")).collect(Collectors.toList());
        String targetName = this.tableManager.getTargetName(table, time);
        try {
            List existData = (List)this.databaseContext.switchDS(config.getDataKey(), () -> this.commonDao.documentationQueryByField(targetName, "id_", ids));
            HashSet set = new HashSet();
            existData.forEach(i -> set.add((String)i.get("ID_")));
            return dataSource.stream().filter(i -> !set.contains(i.get("ID_"))).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return dataSource;
        }
    }

    @Override
    public void batchInset(List<Map<String, Object>> dataList, DocumentationTable table, DocumentationConfig config, boolean deleteData, String time) throws Exception {
        if (BeanUtils.isEmpty(dataList)) {
            return;
        }
        String targetName = this.tableManager.getTargetName(table, time);
        String sql = "select id_ from " + targetName + " where id_ = 1";
        try {
            this.databaseContext.switchDS(config.getDataKey(), () -> this.commonDao.documentationQuery(sql));
        }
        catch (Exception e) {
            String ddl = table.getDdl().toUpperCase().replaceAll(table.getTableName().toUpperCase(), targetName);
            try {
                this.databaseContext.switchDS(config.getDataKey(), () -> this.commonDao.documentationUpdate(ddl));
            }
            catch (Exception ex) {
                throw new BaseException(ex.getMessage());
            }
        }
        List<Map<String, Object>> fields = this.getFields(table.getTableName());
        StringJoiner sj = new StringJoiner(",");
        fields.stream().forEach(item -> sj.add((String)item.get("fieldName")));
        String insertFields = sj.toString();
        dataList = this.getExist(dataList, table, config, time);
        if (BeanUtils.isEmpty(dataList)) {
            return;
        }
        List<Map<String, Object>> finalDataList = dataList;
        long time2 = System.currentTimeMillis();
        this.databaseContext.switchDS(config.getDataKey(), () -> this.batchSaveUtil.batchUpdateOrInsert(CommonDao.class, commonMapper -> commonMapper.documentationBatchInsert(targetName, insertFields, finalDataList)));
        long time1 = System.currentTimeMillis();
        System.out.println("\u63d2\u5165\u6570\u636e\u8017\u65f6\uff1a" + (time1 - time2));
        if (deleteData) {
            AbstractExecutorHandler bean = (AbstractExecutorHandler)AppUtil.getBean(this.getClass());
            bean.deleteDataSource(table, dataList);
        }
    }

    @Override
    public boolean insertData(Map<String, Object> data, DocumentationTable table, DocumentationConfig config, boolean deleteData, String time) throws Exception {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        dataList.add(data);
        this.batchInset(dataList, table, config, deleteData, time);
        return true;
    }

    @Override
    public void insertErrorLog(List<Map<String, Object>> dataList, DocumentationTable table, String reason, DocumentationConfig config, boolean deleteData, String time) {
        for (Map<String, Object> map : dataList) {
            try {
                this.insertData(map, table, config, deleteData, time);
            }
            catch (Exception e) {
                this.errorLogManager.insertLog(map, table, reason);
            }
        }
    }
}

