/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.handler.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.documentation.handler.AbstractExecutorHandler;
import com.hotent.documentation.manager.DocumentationConfigManager;
import com.hotent.documentation.model.DocumentationConfig;
import com.hotent.documentation.model.DocumentationTable;
import com.hotent.documentation.util.ExecutorUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DMExecutorHandlerImpl
extends AbstractExecutorHandler {
    @Value(value="${spring.datasource.dynamic.datasource.master.username}")
    private String owner;
    @Autowired
    private DocumentationConfigManager configManager;

    public void afterPropertiesSet() throws Exception {
        ExecutorUtil.setExecutorHandler("dm", this);
    }

    @Override
    public List<Map<String, Object>> getFields(String tableName) {
        String dmSql = "select COLUMN_NAME fieldName from all_tab_columns where owner='" + this.owner + "' and Table_Name='" + tableName + "'";
        return this.commonDao.documentationQuery(dmSql);
    }

    @Override
    public List<String> getDataTimes(DocumentationTable table, DocumentationConfig config) {
        String beforeMonth = config.getBeforeMonth();
        LocalDateTime dateTime = LocalDateTime.now().minusMonths(Long.parseLong(beforeMonth));
        String time = DateFormatUtil.format((LocalDateTime)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        String sql = "SELECT TO_CHAR(" + table.getTimeKey() + ",'YYYY-mm') dataTime FROM " + table.getTableName() + " where " + table.getTimeKey() + " <= '" + time + "' GROUP BY   TO_CHAR(" + table.getTimeKey() + ",'YYYY-mm')";
        return this.commonDao.documentationQuery(sql).stream().map(i -> i.get("dataTime").toString()).collect(Collectors.toList());
    }

    @Override
    public String getSql(DocumentationTable table, String time) {
        String tableName = table.getTableName();
        String parentId = table.getParentId();
        String dml = table.getDml();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from " + tableName + " where 1=1");
        if (!"0".equals(parentId)) {
            DocumentationTable parentTable = (DocumentationTable)((Object)this.tableManager.getById((Serializable)((Object)parentId)));
            String parentSql = this.getSql(parentTable, time);
            sql.append(" and " + table.getField() + " in (" + parentSql.replace("*", table.getParentField()) + ")");
        } else if (BeanUtils.isNotEmpty((Object)time)) {
            sql.append(" and TO_CHAR(" + table.getTimeKey() + ", 'YYYY-mm') = '" + time + "'");
            DocumentationConfig config = this.configManager.getDetail("1");
            LocalDateTime dateTime = LocalDateTime.now().minusMonths(Long.parseLong(config.getBeforeMonth()));
            String beforeMonth = DateFormatUtil.format((LocalDateTime)dateTime, (String)"YYYY-MM");
            if (time.equals(beforeMonth)) {
                String beforeTime = DateFormatUtil.format((LocalDateTime)dateTime, (String)"YYYY-MM-dd HH:mm:ss");
                sql.append(" and " + table.getTimeKey() + "<= '" + beforeTime + "'");
            }
        }
        if (BeanUtils.isNotEmpty((Object)dml)) {
            sql.append(" and " + dml);
        }
        return sql.toString();
    }
}

