/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.documentation.manager.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.documentation.dao.DocumentationConfigDao;
import com.hotent.documentation.manager.DocumentationConfigManager;
import com.hotent.documentation.model.DocumentationConfig;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentationConfigManagerImpl
extends BaseManagerImpl<DocumentationConfigDao, DocumentationConfig>
implements DocumentationConfigManager {
    @Resource
    private PortalFeignService portalFeignService;

    @Override
    public DocumentationConfig getDetail(String id) {
        DocumentationConfig documentationConfig = (DocumentationConfig)this.get((Serializable)((Object)id));
        return documentationConfig;
    }

    @Override
    @Transactional
    public void createOrUpdate(DocumentationConfig documentationConfig) {
        if ("1".equals(documentationConfig.getAutorun())) {
            String autorunConfig = documentationConfig.getAutorunConfig();
            ObjectNode node = JsonUtil.createObjectNode();
            node.put("description", autorunConfig);
            node.put("jobName", "\u6570\u636e\u5f52\u6863\u5b9a\u65f6\u4efb\u52a1");
            node.put("triggerName", "\u6570\u636e\u5f52\u6863");
            this.portalFeignService.saveOrDeleteTrigger(node);
            ObjectNode nodes = (ObjectNode)this.portalFeignService.getTriggersJsonByJob("\u6570\u636e\u5f52\u6863\u5b9a\u65f6\u4efb\u52a1").get(0);
            if (nodes.get("state").asText().equals("PAUSED")) {
                this.portalFeignService.toggleTriggerRun("\u6570\u636e\u5f52\u6863");
            }
        } else {
            List jsonByJob = this.portalFeignService.getTriggersJsonByJob("\u6570\u636e\u5f52\u6863\u5b9a\u65f6\u4efb\u52a1");
            if (BeanUtils.isNotEmpty((Object)jsonByJob) && ((ObjectNode)jsonByJob.get(0)).get("state").asText().equals("NORMAL")) {
                this.portalFeignService.toggleTriggerRun("\u6570\u636e\u5f52\u6863");
            }
        }
        this.saveOrUpdate((Object)documentationConfig);
    }
}

