/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.feign.mockmvc;

import com.hotent.feign.mockmvc.MockMvcFeignObjectWrapper;
import com.hotent.feign.mockmvc.client.MockMvcClient;
import feign.Client;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

public class MockMvcFeignContext
extends FeignContext {
    private final MockMvcFeignObjectWrapper mockMvcFeignObjectWrapper;
    private final FeignContext delegate;

    public MockMvcFeignContext(MockMvcFeignObjectWrapper mockMvcFeignObjectWrapper, FeignContext delegate) {
        this.mockMvcFeignObjectWrapper = mockMvcFeignObjectWrapper;
        this.delegate = delegate;
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegate.getInstance(name, type);
        if (object instanceof Client) {
            if (this.mockmvcContextId(name)) {
                return (T)object;
            }
            if (object instanceof MockMvcClient) {
                MockMvcClient mockMvcClient = (MockMvcClient)object;
                return (T)mockMvcClient.getDelegate();
            }
        }
        return (T)this.mockMvcFeignObjectWrapper.wrap(object);
    }

    private boolean mockmvcContextId(String name) {
        List mockmvcContextIdList = (List)this.mockMvcFeignObjectWrapper.getApplicationContext().getEnvironment().getProperty("feign.mockmvcclient", List.class);
        return MockMvcFeignContext.matchContextId(name, mockmvcContextIdList);
    }

    private static boolean matchContextId(String name, List<String> mockmvcContextIdList) {
        if (CollectionUtils.isEmpty(mockmvcContextIdList)) {
            return false;
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String contextId : mockmvcContextIdList) {
            if (!antPathMatcher.match(contextId, name)) continue;
            return true;
        }
        return false;
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        HashMap convertedInstances = new HashMap();
        for (Map.Entry entry : instances.entrySet()) {
            if (entry.getValue() instanceof Client) {
                convertedInstances.put(entry.getKey(), entry.getValue());
                continue;
            }
            convertedInstances.put(entry.getKey(), this.mockMvcFeignObjectWrapper.wrap(entry.getValue()));
        }
        return convertedInstances;
    }
}

