/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.feign.mockmvc;

import com.hotent.feign.mockmvc.MockMvcFeignContext;
import com.hotent.feign.mockmvc.MockMvcFeignObjectWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.ApplicationContext;

public class MockMvcContextBeanPostProcessor
implements BeanPostProcessor {
    private final ApplicationContext applicationContext;
    private MockMvcFeignObjectWrapper mockMvcFeignObjectWrapper;

    public MockMvcContextBeanPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FeignContext && !(bean instanceof MockMvcFeignContext)) {
            return new MockMvcFeignContext(this.getMockMvcFeignObjectWrapper(), (FeignContext)bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private MockMvcFeignObjectWrapper getMockMvcFeignObjectWrapper() {
        if (this.mockMvcFeignObjectWrapper == null) {
            this.mockMvcFeignObjectWrapper = (MockMvcFeignObjectWrapper)this.applicationContext.getBean(MockMvcFeignObjectWrapper.class);
        }
        return this.mockMvcFeignObjectWrapper;
    }
}

