/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.feign.mockmvc;

import com.hotent.feign.mockmvc.client.MockMvcClient;
import feign.Client;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcFeignObjectWrapper {
    private final ApplicationContext applicationContext;
    private static MockMvc mockMvc;
    private static MockMvcClient mockMvcClient;

    public MockMvcFeignObjectWrapper(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof MockMvcClient)) {
            return MockMvcFeignObjectWrapper.getMockMvcClient(this.applicationContext, (Client)bean);
        }
        return bean;
    }

    private static MockMvc getMockMvc(ApplicationContext applicationContext) {
        if (mockMvc == null) {
            mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)((WebApplicationContext)applicationContext)).build();
        }
        return mockMvc;
    }

    public static MockMvcClient getMockMvcClient(ApplicationContext applicationContext, Client client) {
        return new MockMvcClient(MockMvcFeignObjectWrapper.getMockMvc(applicationContext), client);
    }

    public static MockMvcClient getMockMvcClient(ApplicationContext applicationContext) {
        return new MockMvcClient(MockMvcFeignObjectWrapper.getMockMvc(applicationContext));
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

