/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.feign.mockmvc.client;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public final class MockMvcClient
implements Client {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private MockMvc mockMvc;
    private final Client delegate;
    private static ThreadLocal<Integer> enterCount = new ThreadLocal();

    public MockMvcClient(MockMvc mockMvc, Client delegate) {
        this.mockMvc = mockMvc;
        this.delegate = delegate;
    }

    public MockMvcClient(MockMvc mockMvc) {
        this.mockMvc = mockMvc;
        this.delegate = new Client.Default(null, null);
    }

    public Client getDelegate() {
        return this.delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        MockHttpServletResponse response = null;
        try {
            MockMvcClient.incrementEnter();
            RequestBuilder requestBuilder = null;
            requestBuilder = this.getRequestBuilder(request, options);
            MvcResult andReturn = this.mockMvc.perform(requestBuilder).andReturn();
            response = andReturn.getResponse();
        }
        catch (IOException | ServletException e) {
            throw new RuntimeException("\u8c03\u7528feign\u65b9\u6cd5\u5f02\u5e38", e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8c03\u7528feign\u65b9\u6cd5\u5f02\u5e38", e);
        }
        finally {
            MockMvcClient.reduceEnter();
        }
        return this.toFeignResponse(response, request);
    }

    private RequestBuilder getRequestBuilder(Request request, Request.Options options) throws Exception {
        return this.createRequestBuilder(request, options);
    }

    Response toFeignResponse(HttpResponse httpResponse, Request request) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String reason = statusLine.getReasonPhrase();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        return Response.builder().status(statusCode).reason(reason).headers(headers).request(request).body(this.toFeignBody(httpResponse)).build();
    }

    Response.Body toFeignBody(HttpResponse httpResponse) {
        final HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return new Response.Body(){

            public Integer length() {
                return entity.getContentLength() >= 0L && entity.getContentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)entity.getContentLength()) : null;
            }

            public boolean isRepeatable() {
                return entity.isRepeatable();
            }

            public InputStream asInputStream() throws IOException {
                return entity.getContent();
            }

            public Reader asReader() throws IOException {
                return new InputStreamReader(this.asInputStream(), Util.UTF_8);
            }

            public Reader asReader(Charset charset) throws IOException {
                Util.checkNotNull((Object)charset, (String)"charset should not be null", (Object[])new Object[0]);
                return new InputStreamReader(this.asInputStream(), charset);
            }

            public void close() throws IOException {
                EntityUtils.consume((HttpEntity)entity);
            }
        };
    }

    private Response toFeignResponse(MockHttpServletResponse response, Request request) {
        int statusCode = response.getStatus();
        String reason = response.getErrorMessage();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (String name : response.getHeaderNames()) {
            String value = response.getHeader(name);
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        Response.Builder builder = Response.builder().body(response.getContentAsByteArray());
        return builder.status(statusCode).reason(reason).headers(headers).request(request).build();
    }

    private RequestBuilder createRequestBuilder(Request request, Request.Options options) throws URISyntaxException {
        org.apache.http.client.methods.RequestBuilder requestBuilder = org.apache.http.client.methods.RequestBuilder.create((String)request.httpMethod().name());
        URI uri = new URIBuilder(request.url()).build();
        requestBuilder.setUri(uri.getScheme() + "://" + uri.getAuthority() + uri.getRawPath());
        MockHttpServletRequestBuilder mockMvcRequestBuilders = this.createRequestBuilder(request.httpMethod().name(), request.url());
        List queryParams = URLEncodedUtils.parse((URI)uri, (Charset)requestBuilder.getCharset());
        for (Object queryParam : queryParams) {
            mockMvcRequestBuilders.param(queryParam.getName(), new String[]{queryParam.getValue()});
        }
        boolean hasAcceptHeader = false;
        for (Map.Entry entry : request.headers().entrySet()) {
            String headerName = (String)entry.getKey();
            if (headerName.equalsIgnoreCase(ACCEPT_HEADER_NAME)) {
                hasAcceptHeader = true;
            }
            if (headerName.equalsIgnoreCase("Content-Length")) continue;
            for (String headerValue : (Collection)entry.getValue()) {
                mockMvcRequestBuilders.header(headerName, new Object[]{headerValue});
            }
        }
        if (!hasAcceptHeader) {
            mockMvcRequestBuilders.header(ACCEPT_HEADER_NAME, new Object[]{"*/*"});
        }
        if (request.body() != null) {
            if (request.charset() != null) {
                String content = new String(request.body(), request.charset());
                mockMvcRequestBuilders.contentType(MediaType.APPLICATION_JSON).content(content);
            } else {
                mockMvcRequestBuilders.contentType(MediaType.APPLICATION_JSON).content(request.body());
            }
        } else {
            mockMvcRequestBuilders.contentType(MediaType.APPLICATION_JSON).content(new byte[0]);
        }
        return mockMvcRequestBuilders;
    }

    private MockHttpServletRequestBuilder createRequestBuilder(String name, String url) throws URISyntaxException {
        name = name.toUpperCase();
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder = null;
        if (url.indexOf("?") != -1) {
            url = url.substring(0, url.indexOf("?"));
        }
        switch (name) {
            case "GET": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]);
                break;
            }
            case "POST": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]);
                break;
            }
            case "HEAD": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.head((String)url, (Object[])new Object[0]);
                break;
            }
            case "PUT": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.put((String)url, (Object[])new Object[0]);
                break;
            }
            case "PATCH": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.patch((String)url, (Object[])new Object[0]);
                break;
            }
            case "DELETE": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.delete((String)url, (Object[])new Object[0]);
                break;
            }
            case "OPTIONS": {
                mockHttpServletRequestBuilder = MockMvcRequestBuilders.options((String)url, (Object[])new Object[0]);
                break;
            }
        }
        return mockHttpServletRequestBuilder;
    }

    public static void incrementEnter() {
        if (null == enterCount.get()) {
            enterCount.set(1);
        } else {
            enterCount.set(enterCount.get() + 1);
        }
    }

    public static void reduceEnter() {
        enterCount.set(enterCount.get() - 1);
    }

    public static Integer getEnter() {
        return enterCount.get();
    }

    public static void cleanEnter() {
        enterCount.remove();
    }
}

