/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.entity;

import com.hotent.enums.ResponseErrorEnums;
import java.io.Serializable;

public class CommonResult<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    Boolean state = true;
    String message;
    E value;
    private Integer code = 200;
    private String errorCode;
    private String logId;

    public static <E> CommonResult<E> ok() {
        CommonResult<E> cr = new CommonResult<E>(ResponseErrorEnums.SUCCESS_OPTION);
        return cr;
    }

    public static <E> CommonResult<E> error() {
        CommonResult<E> cr = new CommonResult<E>(ResponseErrorEnums.SYSTEM_ERROR);
        return cr;
    }

    public static <E> CommonResult<E> result(ResponseErrorEnums res) {
        CommonResult<E> cr = new CommonResult<E>(res);
        return cr;
    }

    public CommonResult<E> message(String message) {
        this.setMessage(message);
        return this;
    }

    public CommonResult<E> value(E val) {
        this.setValue(val);
        return this;
    }

    public CommonResult<E> log(String logId) {
        this.setLogId(logId);
        return this;
    }

    public CommonResult() {
    }

    public CommonResult(String message) {
        this(true, message, null);
    }

    public CommonResult(boolean state, String message) {
        this(state, message, null);
    }

    public CommonResult(boolean state, String message, E value) {
        this.state = state;
        this.message = message;
        this.value = value;
    }

    public CommonResult(ResponseErrorEnums error) {
        if (!error.getCode().equals("200")) {
            this.state = false;
        }
        this.errorCode = error.getCode();
        this.message = error.getMessage();
        this.code = error.getHttpCode();
    }

    public CommonResult(ResponseErrorEnums error, E value) {
        if (!error.getCode().equals("200")) {
            this.state = false;
        }
        this.errorCode = error.getCode();
        this.message = error.getMessage();
        this.code = error.getHttpCode();
        this.value = value;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

